define(['require', 'common', 'layer'], function (require, common, layer) {
    $('[rel=fast-add]').click(function () {
        layer.open({
            type: 1,
            title: '免费登记',
            area: ['800px', '480px'],
            content: $('#fast-add'),
        });
        common.captcha();
        require(['validator'], function () {
            $("#fast-add").validator({
                timely: 3,
                stopOnError: true,
                theme: 'yellow_right_effect',
                fields: {
                    column_id: "类目: required;",
                    name: "名称: required;",
                    phone: "电话: required;mobile|tel",
                    address: "地址: required;"
                },
                valid: function (form) {
                    var data = {
                        "column_id": $('#fast-add select[name=column_id]').val(),
                        "name": $('#fast-add input[name=name]').val(),
                        "phone": {
                            "phone": $('#fast-add input[name=phone]').val(),
                            "address": $('#fast-add input[name=address]').val(),
                            "intro": $('#fast-add textarea[name=intro]').val(),
                        }
                    };
                    if (!data.column_id) layer.msg('请选择类目');
                    $.post('/index/api/add', data, function (rs) {
                        if (rs.code == 1) {
                            $('#fast-add input,#fast-add textarea').val('');
                            layer.closeAll();
                            layer.alert('您的电话已登记，审核通过后即可展示。');
                        } else {
                            layer.msg(rs.msg);
                        }
                    }, 'json');
                }
            });
        });
    });
});