<?php
// +----------------------------------------------------------------------
// | [RhaPHP System] Copyright (c) 2017 http://www.rhaphp.com/
// +----------------------------------------------------------------------
// | [RhaPHP] 并不是自由软件,你可免费使用,未经许可不能去掉RhaPHP相关版权
// +----------------------------------------------------------------------
// | Author: Geeson <qimengkeji@vip.qq.com>
// +----------------------------------------------------------------------

namespace app\common\controller;

use app\common\model\Setting;
use think\facade\Config;
use think\Controller;
use think\facade\Request;
use think\facade\Session;

class Common extends Controller
{
    public $mid;//公众号标识
    public $adminLogin = false;//为 TRUE 需要管理登录，一般后台管理应用的控制器需要设为 true
    public $isWexinLogin = false;//是否微信登录 false为否，true为是
    public $onlyWexinOpen = false;//是否必须在微信浏览器打开  false为否，true为是
    public $scope = 'snsapi_userinfo';//snsapi_base||snsapi_userinfo

    public function initialize()
    {
        $mid = Request::param('mid');
        if (!$mid) {
            $this->error('公众号标识mid不存在');
        } else {
            $this->mid = $mid;
        }
        if (!$mpInfo = getMpInfo($mid)) {
            $this->error('没有该公众号信息');
        } else {
            $options = array(
                'appid' => $mpInfo['appid'],
                'appsecret' => $mpInfo['appsecret'],
                'token' => $mpInfo['valid_token'],
                'encodingaeskey' => $mpInfo['encodingaeskey']
            );
            Session::set('mp_options', $options);
        }
        if ($this->onlyWexinOpen == true) {//需要在微信浏览器打开
            if (isset($_SERVER['HTTP_USER_AGENT']) && strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') == false) {
                $wxObj = getWechatActiveObj($this->mid);
                $url = $wxObj->getOauthRedirect(getHostDomain(), 'state', $this->scope);
                $this->redirect($url);
            }
        }
        if ($this->adminLogin == true) {
            if (empty(getAdmin())) {
                $this->redirect('admin/Login/index');
            }
        }
        if (empty(getMember())) {
            if ($this->isWexinLogin == true) {
                //if (empty(getOrSetOpenid())) {
                session('callbackUrl', getHostDomain() . $_SERVER['REQUEST_URI']);
                $setingModel = new Setting();
                $registerConfValue = $setingModel->getSetting(['mpid' => $mid, 'name' => 'register', 'cate' => 'mp']);
                if (!empty($registerConfValue)) {
                    if ($registerConfValue['register_type'] == 3) {
                        $this->redirect('mp/Login/loginByReply', ['mid' => $mid]);
                    } elseif ($registerConfValue['register_type'] == 2) {//系统自动注册
                        $this->redirect('mp/Login/registerByAuto', ['mid' => $mid, 'scope' => $this->scope]);
                    }
                } else {
                    $this->error('你还没有保存《授权&注册->注册设置》，请先前往后台进行设置');
                }
                //}
            }
        }
        getOrSetOpenid(input('openid'));
        $this->assign('title', $mpInfo['name']);
        parent::initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 微信授权或者注册登录
     * 如果你控制器某个方法想要登录可以使用此，$isWexinLogin这个进入控制器后台就执行登录或者注册
     * @param string $scope
     */
    public function wexinLogin($scope = 'snsapi_userinfo')
    {
        if (empty($member = getMember())) {
            // if (empty(getOrSetOpenid())) {
            session('callbackUrl', getHostDomain() . $_SERVER['REQUEST_URI']);
            $setingModel = new Setting();
            $registerConfValue = $setingModel->getSetting(['mpid' => $this->mid, 'name' => 'register', 'cate' => 'mp']);
            if (!empty($registerConfValue)) {
                if ($registerConfValue['register_type'] == 3) {
                    $this->redirect('mp/Login/loginByReply', ['mid' => $this->mid]);
                } elseif ($registerConfValue['register_type'] == 2) {//系统自动注册
                    $this->redirect('mp/Login/registerByAuto', ['mid' => $this->mid, 'scope' => $scope]);
                }
            } else {
                $this->error('你还没有保存《授权&注册->注册设置》，请先前往后台进行设置');
            }
            //  }
        }
        return $member;
    }

    /**
     * 如果你的应用需要某个应用支持的，可以使用此检测
     * 检测某个应用是否安装与启用
     * @param string $addonName
     */
    public function check($addonName = '')
    {
        $path = ADDON_PATH . $addonName . DS;
        $info = getAddonInfo($addonName, $this->mid);
        if (!file_exists($path) || empty($info)) {
            $this->error('检测到你没有安装' . $addonName . '应用！');
        }
        if ($info['status'] == 0) {
            $this->error('检测到你没有启用' . $info['name'] . '应用！');
        }
    }
}