<?php
namespace app\admin\controller;

use think\Request;
use think\Db;
use think\Session;
use think\Controller;

class Common extends Controller
{
    protected $admin_user_info;
    
    /**
     * 初始化
     * @param void
     * @return void
     */
	public function _initialize()
	{
		$request = Request::instance();

		
		
		// 批量赋值
        $this->assign([
            'action_name'  => $request->action(),
            'controller_name' => $request->controller(),
            'module_name' => $request->module()
        ]);
		
        $route = $request->action().'/'.$request->controller().'/'.$request->module();
        
		if(!Session::has('admin_user_info'))
		{
			$this->error('您访问的页面不存在或已被删除！', '/',3);
		}
        else
        {
            $this->admin_user_info = Session::get('admin_user_info');
            $this->assign('admin_user_info',$this->admin_user_info);
        }


		$the_title=db("sysconfig")->where("varname='CMS_XCX_TITLE'")->find();
		$the_mobile=db("sysconfig")->where("varname='CMS_XCX_MOBILE'")->find();

        $setbasedata=array();
		$setbasedata['realip']=$this->getrealip();
		$setbasedata['realurl']=$_SERVER['HTTP_HOST'];
		$setbasedata['title']=$the_title['value'];
		$setbasedata['mobile']=$the_mobile['value'];

		$this->assign([
            'thebasedata'  => urlencode(base64_encode(json_encode($setbasedata))),
        ]);	
        //判断是否拥有权限
		if($this->admin_user_info['role_id'] <> 1)
		{
			$uncheck = array('admin/index/index','admin/index/upconfig','admin/index/upcache','admin/index/welcome');
            
			if(in_array($route, $uncheck))
			{
				
			}
			else
			{
				$menu_id = db('menu')->where(array('module'=>$request->module(), 'controller'=>$request->controller(), 'action'=>$request->action()))->value('id');
				if(!$menu_id){$this->error('你没有权限访问，请联系管理员！', CMS_ADMIN, 3);}
				
				$check = db('access')->where(array('role_id' => $this->admin_user_info['role_id'], 'menu_id' => $menu_id))->find();
				
				if(!$check)
				{
					$this->error('你没有权限访问，请联系管理员！', CMS_ADMIN, 3);
				}
			}
        }
        

        unset($request);
    }
	
    /**
     * 获取分页数据及分页导航
     * @param string $modelname 模块名与数据库表名对应
     * @param array  $map       查询条件
     * @param string $orderby   查询排序
     * @param string $field     要返回数据的字段
     * @param int    $listRows  每页数量，默认15条
     * 
     * @return 格式化后输出的数据。
     */
    public function pageList($modelname, $map = null, $orderby = '', $field = '*', $listRows = 15)
    {
        //获取当前数据对象的【主键名称】
        $id = Db::getTableInfo(config('database.prefix').$modelname, 'pk');
		$this->assign('pkid',$id);
		
        $orderby = !empty($orderby) ? $orderby : $id.' desc';
        
		$request = Request::instance();$param = $request->param(); //等价于$param = request()->param();
		
        $model = Db::name($modelname)->field($field);
        if($map != null){$model = $model->where($map);}
        
		// 查询满足的数据，并且每页显示15条数据
		$voList = $model->order($orderby)->paginate($listRows,false,array('query' => $param));
		
        return $voList;
    }
	
    //设置空操作
    public function _empty()
    {
        return $this->error('您访问的页面不存在或已被删除！');
    }
	
	public function getrealip() {
		if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
			$ip = getenv('HTTP_CLIENT_IP');
		} elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
			$ip = getenv('HTTP_X_FORWARDED_FOR');
		} elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
			$ip = getenv('REMOTE_ADDR');
		} elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		$res =  preg_match ( '/[\d\.]{7,15}/', $ip, $matches ) ? $matches [0] : '';
		return $res;
		
	}

}