<?php
namespace app\api\controller;
use think\Db;
use think\Request;
use app\common\lib\Token;
use app\common\lib\Helper;
use app\common\lib\ReturnData;
use app\common\logic\PageLogic;

class Page extends Base
{
	public function _initialize()
	{
		parent::_initialize();
    }
    
    public function getLogic()
    {
        return new PageLogic();
    }
    
    //列表
    public function index()
	{
        //参数
        $where = array();
        $limit = input('limit',10);
        $offset = input('offset', 0);
        if(input('keyword', null) !== null){$where['title'] = ['like','%'.input('keyword').'%'];}
        $orderby = input('orderby','id desc');
        
        $res = $this->getLogic()->getList($where,$orderby,['body'],$offset,$limit);
		
        if($res['list'])
        {
            foreach($res['list'] as $k=>$v)
            {
                $res['list'][$k]['url'] = http_host().get_front_url(array('pagename'=>$v['filename'],'type'=>'page'));
                if(!empty($v['litpic'])){$res['list'][$k]['litpic'] = http_host().$v['litpic'];}
            }
        }
        
		exit(json_encode(ReturnData::create(ReturnData::SUCCESS,$res)));
    }
    
    //详情
    public function detail()
	{
        //参数
        if(input('id', null) !== null){$where['id'] = input('id');}
        if(input('filename', null) !== null){$where['filename'] = input('filename');}
        if(!isset($where)){exit(json_encode(ReturnData::create(ReturnData::PARAMS_ERROR)));}
        
		$res = $this->getLogic()->getOne($where);
        if(!$res){exit(json_encode(ReturnData::create(ReturnData::PARAMS_ERROR)));}
        
        if(!empty($res['litpic'])){$res['litpic'] = http_host().$res['litpic'];}
        
		exit(json_encode(ReturnData::create(ReturnData::SUCCESS,$res)));
    }
    
   
}