<?php
namespace app\api\controller;
use think\Db;
use think\Request;
use app\common\lib\Token;
use app\common\lib\Helper;
use app\common\lib\ReturnData;
use app\common\logic\SlideLogic;

class Slide extends Base
{
	public function _initialize()
	{
		parent::_initialize();
    }
    
    public function getLogic()
    {
        return new SlideLogic();
    }
    
    //列表
    public function index()
	{
        //参数
        $where = array();
        $limit = input('limit',10);
        $offset = input('offset', 0);
        if(input('keyword', null) !== null){$where['title'] = ['like','%'.input('keyword').'%'];}
        if(input('target', null) !== null){$where['target'] = input('target');}
        if(input('group_id', null) !== null){$where['group_id'] = input('group_id');}
        $where['is_show'] = input('is_show',0);
        $orderby = input('orderby','rank asc');
        
        $res = $this->getLogic()->getList($where,$orderby,'*',$offset,$limit);
		
        if($res['list'])
        {
            foreach($res['list'] as $k=>$v)
            {
                if(!empty($v['pic'])){$res['list'][$k]['pic'] = http_host().$v['pic'];}
            }
        }
		$basedata=db("sysconfig")->order('id desc')->select();
		$newdata=array();
		foreach($basedata as $k=>$v){
			$newdata[$v['varname']]=$v['value'];
		}
		$temp_latlon=explode(',',$newdata['CMS_XCX_LATLON']);
        $res['basedata']=array(
			'contact'=>	$newdata['CMS_XCX_CONTACT'],
			'mobile'=>	$newdata['CMS_XCX_MOBILE'],
			'email'=>	$newdata['CMS_XCX_EMAIL'],
			'intro'=>	$newdata['CMS_XCX_INTRO'],
			'address'=>	$newdata['CMS_XCX_ADDRESS'],
			'logo'=>	$newdata['CMS_XCX_LOGO'],
			'title'=>	$newdata['CMS_XCX_TITLE'],
			'lat'=>	$temp_latlon[0],
			'lon'=>	$temp_latlon[1],
		);
		exit(json_encode(ReturnData::create(ReturnData::SUCCESS,$res)));
    }
    
    //详情
    public function detail()
	{
        //参数
        if(input('id', null) !== null){$where['id'] = input('id');}
        if(!isset($where)){exit(json_encode(ReturnData::create(ReturnData::PARAMS_ERROR)));}
        
		$res = $this->getLogic()->getOne($where);
        if(!$res){exit(json_encode(ReturnData::create(ReturnData::PARAMS_ERROR)));}
        
        if(!empty($res['pic'])){$res['pic'] = http_host().$res['pic'];}
        
		exit(json_encode(ReturnData::create(ReturnData::SUCCESS,$res)));
    }
    
  
}