<?php
namespace app\common\lib;

class Helper
{
	//保留两位小数，最后一位会四舍五入
    public static function formatPrice($price)
    {
        return sprintf("%.2f",$price);
    }
	
    //验证是否是合法的手机号码
    public static function isValidMobile($mobile)
    {
        return preg_match('/^(13[0-9]|14[0-9]|15[0-9]|17[0-9]|18[0-9])\d{8}$/', $mobile);
    }
	
    //验证是否是合法中文
    public static function isValidChinese($word, $length = 16)
    {
        $pattern = "/(^[\x{4e00}-\x{9fa5}]+)/u";

        preg_match($pattern, $word, $match);

        if (!$match)
		{
            return false;
        }

        if (mb_strlen($match[1]) > $length)
		{
            return false;
        }
		
        return $match[1];
    }
	
    //验证是否是合法的身份证号，简单验证
    public static function isValidIdCardNo($idcard)
    {
        $length = strlen($idcard);

        //15位老身份证
        if ($length == 15)
		{
            if (checkdate(substr($idcard, 8, 2), substr($idcard, 10, 2), '19' . substr($idcard, 6, 2)))
			{
                return true;
            }
        }
		
        //18位二代身份证号
        if ($length == 18)
		{
            if (!checkdate(substr($idcard, 10, 2), substr($idcard, 12, 2), substr($idcard, 6, 4)))
			{
                return false;
            }
			
            $idcard = str_split($idcard);
            if (strtolower($idcard[17]) == 'x')
			{
                $idcard[17] = '10';
            }
			
            //加权求和
            $sum = 0;
            //加权因子
            $wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1];
            for ($i = 0; $i < 17; $i++)
			{
                $sum += $wi[$i] * $idcard[$i];
            }

            //得到验证码所位置
            $position = $sum % 11;

            //身份证验证位值 10代表X
            $code = [1, 0, 10, 9, 8, 7, 6, 5, 4, 3, 2];
            if ($idcard[17] == $code[$position])
			{
                return true;
            }
        }

        return false;
    }
	
    //验证是否是合法的银行卡，不包含信用卡
    public static function isValidBankCard($card)
    {
        if (!is_numeric($card))
		{
            return false;
        }

        if (strlen($card) < 16 || strlen($card) > 19)
		{
            return false;
        }

        $cardHeader = [10, 18, 30, 35, 37, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 58, 60, 62, 65, 68, 69, 84, 87, 88, 94, 95, 98, 99];
        if (!in_array(substr($card, 0, 2), $cardHeader))
		{
            return false;
        }

        $numShouldCheck = str_split(substr($card, 0, -1));
        krsort($numShouldCheck);

        $odd = $odd['gt9'] = $odd['gt9']['tens'] = $odd['gt9']['unit'] = $odd['lt9'] = $even = [];
        array_walk($numShouldCheck, function ($item, $key) use (&$odd, &$even, $card){

            if ((strlen($card) == 16) && (substr($card, 0, 2) == '62'))
			{
                $key += 1;
            }

            if (($key & 1))
			{
                $t = $item * 2;
                if ($t > 9)
				{
                    $odd['gt9']['unit'][] = intval($t % 10);
                    $odd['gt9']['tens'][] = intval($t / 10);
                }
				else
				{
                    $odd['lt9'][] = $t;
                }
            }
			else
			{
                $even[] = $item;
            }
        });
		
        $total = array_sum($even);
        array_walk_recursive($odd, function ($item, $key) use (&$total) {
            $total += $item;
        });

        $luhm = 10 - ($total % 10 == 0 ? 10 : $total % 10);

        $lastNumOfCard = substr($card, -1, 1);
        if ($luhm != $lastNumOfCard)
		{
            return false;
        }
		
        return true;
    }
	
	//随机字母
    public static function randLetter($len)
    {
        $letter = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'];
        $result = '';
		
        for ($i = 0; $i < $len; $i++)
		{
            $result .= $letter[array_rand($letter, 1)];
        }
		
        return $result;
    }
    
    //生成二维码
    public static function qrcode($url,$size=150)
    {
        return 'data:image/png;base64,'.base64_encode(\QrCode::format('png')->encoding('UTF-8')->size($size)->margin(0)->errorCorrection('H')->generate($url));
    }
	
    //获取浏览器信息
    public static function getBrowser()
    {
        $browser = array('name'=>'unknown', 'version'=>'unknown');

        if(empty($_SERVER['HTTP_USER_AGENT'])) return $browser;

        $agent = $_SERVER["HTTP_USER_AGENT"];

        // Chrome should checked before safari
        if(strpos($agent, 'Firefox') !== false) $browser['name'] = "firefox";
        if(strpos($agent, 'Opera') !== false)   $browser['name'] = 'opera';
        if(strpos($agent, 'Safari') !== false)  $browser['name'] = 'safari';
        if(strpos($agent, 'Chrome') !== false)  $browser['name'] = "chrome";

        // Check the name of browser
        if(strpos($agent, 'MSIE') !== false || strpos($agent, 'rv:11.0')) $browser['name'] = 'ie';
        if(strpos($agent, 'Edge') !== false) $browser['name'] = 'edge';

        // Check the version of browser
        if(preg_match('/MSIE\s(\d+)\..*/i', $agent, $regs))       $browser['version'] = $regs[1];
        if(preg_match('/FireFox\/(\d+)\..*/i', $agent, $regs))    $browser['version'] = $regs[1];
        if(preg_match('/Opera[\s|\/](\d+)\..*/i', $agent, $regs)) $browser['version'] = $regs[1];
        if(preg_match('/Chrome\/(\d+)\..*/i', $agent, $regs))     $browser['version'] = $regs[1];

        if((strpos($agent, 'Chrome') == false) && preg_match('/Safari\/(\d+)\..*$/i', $agent, $regs)) $browser['version'] = $regs[1];
        if(preg_match('/rv:(\d+)\..*/i', $agent, $regs)) $browser['version'] = $regs[1];
        if(preg_match('/Edge\/(\d+)\..*/i', $agent, $regs)) $browser['version'] = $regs[1];

        return $browser;
    }
    
    /**
     * 检查是否是AJAX请求。
     * Check is ajax request.
     * 
     * @static
     * @access public
     * @return bool
     */
    public static function isAjaxRequest()
    {
        if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') return true;
        if(isset($_GET['HTTP_X_REQUESTED_WITH'])    && $_GET['HTTP_X_REQUESTED_WITH']    == 'XMLHttpRequest') return true;
        return false;
    }
    
    /**
     * 检查是否是POST请求
     */
    public static function isPostRequest()
    {
        if($_SERVER['REQUEST_METHOD'] == 'POST') return true;
        if($_POST) return true;
        
        return false;
    }
    
    /**
     * 是否是GET提交的
     */
    public static function isGetRequest()
    {
        return $_SERVER['REQUEST_METHOD'] == 'GET' ? true : false;
    }
    
    /**
     * 301跳转。
     * Header 301 Moved Permanently.
     * 
     * @param  string    $locate 
     * @access public
     * @return void
     */
    public static function header301($locate)
    {
        header('HTTP/1.1 301 Moved Permanently');
        die(header('Location:' . $locate));
    }
    
    /** 
     * 获取远程IP。
     * Get remote ip. 
     * 
     * @access public
     * @return string
     */
    public static function getRemoteIp()
    {
        $ip = '';
        if(!empty($_SERVER["REMOTE_ADDR"]))          $ip = $_SERVER["REMOTE_ADDR"];
        if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        if(!empty($_SERVER['HTTP_CLIENT_IP']))       $ip = $_SERVER['HTTP_CLIENT_IP'];

        return $ip;
    }
    
    /**
     * 建立文件夹
     *
     * @param string $aimUrl
     * @return viod
     */
    public static function createDir($aimUrl)
    {
        $aimUrl = str_replace('', '/', $aimUrl);
        $aimDir = '';
        $arr = explode('/', $aimUrl);
        $result = true;
        
        foreach ($arr as $str)
        {
            $aimDir .= $str . '/';
            
            if (!file_exists($aimDir))
            {
                $result = mkdir($aimDir);
            }
        }
        
        return $result;
    }
    
    //判断访问终端是否是微信浏览器
    public static function isWechatBrowser()
    { 
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false)
        { 
            return true; 
        }
        
        return false; 
    }
}