<?php
namespace app\index\controller;

use think\Request;
use think\Session;
use think\Controller;

class Index extends Controller
{
    //首页
    public function index()
	{
        return $this->fetch();
    }
	
    //列表页
    public function category()
	{
        $cat=input('cat');
        $pagenow=input('page');
        
		if(empty($cat) || !preg_match('/[0-9]+/',$cat)){$this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;}
        
		if(cache("catid$cat")){$post=cache("catid$cat");}else{$post = db('arctype')->where("id=$cat")->find();if(empty($post)){$this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;}cache("catid$cat",$post,2592000);}
		
		
        $this->assign('post',$post);
        
		$subcat="";$sql="";
		$post2=db('arctype')->field('id')->where("parent_id=$cat")->select();
		if(!empty($post2)){foreach($post2 as $row){$subcat=$subcat."typeid=".$row["id"]." or ";}}
		$subcat=$subcat."typeid=".$cat;
		$sql=$subcat." or typeid2 in (".$cat.")";//echo $subcat2;exit;
		$this->assign('sql',$sql);
		
		$counts=db("article")->where($sql)->count('id');
		if($counts>sysconfig('CMS_MAXARC')){$counts=sysconfig('CMS_MAXARC');}
		$pagesize=sysconfig('CMS_PAGESIZE');$page=0;
		if($counts % $pagesize){//取总数据量除以每页数的余数
		$pages = intval($counts/$pagesize) + 1; //如果有余数，则页数等于总数据量除以每页数的结果取整再加一,如果没有余数，则页数等于总数据量除以每页数的结果
		}else{$pages = $counts/$pagesize;}
		if(!empty($pagenow)){if($pagenow==1 || $pagenow>$pages){header("HTTP/1.0 404 Not Found");$this->error('您访问的页面不存在或已被删除！');exit;}$page = $pagenow-1;$nextpage=$pagenow+1;$previouspage=$pagenow-1;}else{$page = 0;$nextpage=2;$previouspage=0;}
		$this->assign('page',$page);
		$this->assign('pages',$pages);
		$this->assign('counts',$counts);
		$start=$page*$pagesize;
		
		$this->assign('datalist',arclist(array("sql"=>$sql,"limit"=>"$start,$pagesize"))); //获取列表
		$this->assign('pagenav',get_listnav(array("counts"=>$counts,"pagesize"=>$pagesize,"pagenow"=>$page+1,"catid"=>$cat))); //获取分页列表
        
        return $this->fetch($post['templist']);
	}
    
    //文章详情页
    public function detail()
	{
        $id=input('id');
        if(empty($id) || !preg_match('/[0-9]+/',$id)){$this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;}
        $article = db('article');
		
		if(cache("detailid$id")){$post=cache("detailid$id");}else{$post = db('article')->where("id=$id")->find();if(empty($post)){$this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;}$post['name'] = db('arctype')->where("id=".$post['typeid'])->value('name');cache("detailid$id",$post,2592000);}
		if($post)
        {
			$cat=$post['typeid'];
            $post['body']=ReplaceKeyword($post['body']);
            if(!empty($post['writer'])){$post['writertitle']=$post['title'].' '.$post['writer'];}
            
			$this->assign('post',$post);
            $pre = get_article_prenext(array('aid'=>$post["id"],'typeid'=>$post["typeid"],'type'=>"pre"));
            $this->assign('pre',$pre);
        }
        else
        {
            $this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;
        }
        
        //获取最新列表
        $where = '';
        if($pre){$where['typeid']=$post['typeid'];$where['id']=array('lt',$pre['id']);}
        $latest_posts = $article->where($where)->field('body',true)->order('id desc')->limit(5)->select();
        if(!$latest_posts){$latest_posts = $article->field('body',true)->order('id desc')->limit(5)->select();}
        $this->assign('latest_posts',$latest_posts);
        
		if(cache("catid$cat")){$post=cache("catid$cat");}else{$post = db('arctype')->where("id=$cat")->find();cache("catid$cat",$post,2592000);}
        
        return $this->fetch($post['temparticle']);
    }
	
    //标签详情页，共有3种显示方式，1正常列表，2列表显示文章，3显示描述
	public function tag()
	{
        $tag=input('tag');
        $pagenow=input('page');
        
		if(empty($tag) || !preg_match('/[0-9]+/',$tag)){$this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;}
        
		$post = db('tagindex')->where("id=$tag")->find();
        $this->assign('post',$post);
		
		$counts=db("taglist")->where("tid=$tag")->count('aid');
		if($counts>sysconfig('CMS_MAXARC')){$counts=sysconfig('CMS_BASEHOST');}
		$pagesize=sysconfig('CMS_PAGESIZE');$page=0;
		if($counts % $pagesize){//取总数据量除以每页数的余数
		$pages = intval($counts/$pagesize) + 1; //如果有余数，则页数等于总数据量除以每页数的结果取整再加一,如果没有余数，则页数等于总数据量除以每页数的结果
		}else{$pages = $counts/$pagesize;}
		if(!empty($pagenow)){if($pagenow==1 || $pagenow>$pages){header("HTTP/1.0 404 Not Found");$this->error('您访问的页面不存在或已被删除！');exit;}$page = $pagenow-1;$nextpage=$pagenow+1;$previouspage=$pagenow-1;}else{$page = 0;$nextpage=2;$previouspage=0;}
		$this->assign('page',$page);
		$this->assign('pages',$pages);
		$this->assign('counts',$counts);
		$start=$page*$pagesize;
		
		$posts=db("taglist")->where("tid=$tag")->order('aid desc')->limit("$start,$pagesize")->select();
		foreach($posts as $row)
		{
			$aid[] = $row["aid"];
		}
		$aid = isset($aid)?implode(',',$aid):"";
		
        if($aid!="")
        {
            if($post['template']=='tag2')
            {
                $this->assign('posts',arclist(array("sql"=>"id in ($aid)","orderby"=>"id desc","limit"=>"$pagesize","field"=>"title,body"))); //获取列表
            }
            else
            {
                $this->assign('posts',arclist(array("sql"=>"id in ($aid)","orderby"=>"id desc","limit"=>"$pagesize"))); //获取列表
            }
        }
		else
        {
            $this->assign('posts',""); //获取列表
        }
        
		$this->assign('pagenav',get_listnav(array("counts"=>$counts,"pagesize"=>$pagesize,"pagenow"=>$page+1,"catid"=>$tag,"urltype"=>"tag"))); //获取分页列表
		
		return $this->fetch($post['template']);
    }
    
	//标签页
    public function tags()
	{
		return $this->fetch();
    }
    
    //推荐页
	public function tuijian()
	{
        $pagenow=input('page');
        $where['tuijian'] = 1;
        
		$counts=db("article")->where($where)->count();
		if($counts>sysconfig('CMS_MAXARC')){$counts=sysconfig('CMS_BASEHOST');}
		$pagesize=sysconfig('CMS_PAGESIZE');$page=0;
		if($counts % $pagesize){//取总数据量除以每页数的余数
		$pages = intval($counts/$pagesize) + 1; //如果有余数，则页数等于总数据量除以每页数的结果取整再加一,如果没有余数，则页数等于总数据量除以每页数的结果
		}else{$pages = $counts/$pagesize;}
		if(!empty($pagenow)){if($pagenow==1 || $pagenow>$pages){header("HTTP/1.0 404 Not Found");$this->error('您访问的页面不存在或已被删除！');exit;}$page = $pagenow-1;$nextpage=$pagenow+1;$previouspage=$pagenow-1;}else{$page = 0;$nextpage=2;$previouspage=0;}
		$this->assign('page',$page);
		$this->assign('pages',$pages);
		$this->assign('counts',$counts);
		$start=$page*$pagesize;
        
        $posts = db('article')->where($where)->field('body',true)->order('id desc')->limit("$start,$pagesize")->select();
		$this->assign('posts',$posts); //获取列表
        $pagenav = '';if($nextpage<=$pages && $nextpage>0){$pagenav = get_pagination_url(http_host().'/tuijian',$_SERVER['QUERY_STRING'],$nextpage);} //获取上一页下一页网址
		$this->assign('pagenav',$pagenav);
        
		return $this->fetch();
    }
    
    //搜索页
	public function search()
	{
		if(isset($_REQUEST["keyword"]) && !empty($_REQUEST["keyword"]))
		{
			$keyword = $_REQUEST["keyword"]; //搜索的关键词
			if(strstr($keyword,"&")) exit;
			
			$map['title'] = array('LIKE',"%$keyword%");
			
            $this->assign('posts',db("article")->field('body',true)->where($map)->order('id desc')->limit(30)->select());
			$this->assign('keyword',$keyword);
		}
		else
		{
			$this->error('请输入正确的关键词', '/' , 3);exit;
		}
		
		return $this->fetch();
    }
    
    //单页面
    public function page()
	{
        $id=input('id');
        
        if(!empty($id) && preg_match('/[a-z0-9]+/',$id))
        {
            $map['filename']=$id;
            if(cache("pageid$id")){$post=cache("pageid$id");}else{$post = db('page')->where($map)->find();cache("pageid$id",$post,2592000);}
            
            if($post)
            {
                $this->assign('post',$post);
            }
            else
            {
                $this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;
            }
            
            return $this->fetch($post['template']);
        }
        else
        {
            $this->error('您访问的页面不存在或已被删除！', '/' , 3);exit;
        }
    }
    
    public function sitemap()
    {
		return $this->fetch();
    }
    
	
}