<?php
#administration
function administration()
{
	if(is_writable('config.php')) {
		$output = '<p class="infoline warning">'.l(config_444).'</p>';
	}
	if(file_exists('install.php')) {
		$output .= '<p class="infoline warning">'.l(install_remove).'</p>';
	}
	$output .= '<h2 class="title space_bottom">'.l('administration').'</h2><div id="administration">';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<small>'.l('rs_name').' '.l('rs_version').'</small>');
	$output .= '<ul><li class="sub_headline space_bottom space_top">'.l('section').'</li>';
	$output .= '<li onmouseover="toggle(\'administration_categories\')" onmouseout="toggle(\'administration_categories\')">'.l('categories').'</li>';
	$output .= '<li id="administration_categories" class="space_left hidden" onmouseover="toggle(\'administration_categories\')" onmouseout="toggle(\'administration_categories\')">';
	$output .= '<a href="'._rewrite_string.'action/category_new" title="'.l('new').'">'.l('new').'</a>';
	if(total('categories') > 0) {
		$output .= s('divider').'<a href="'._rewrite_string.'categories" title="'.l('view').'">'.l('view').'</a>';
	}
	$output .= '</li><li onmouseover="toggle(\'administration_articles\')" onmouseout="toggle(\'administration_articles\')">'.l('articles').'</li>';
	$output .= '<li id="administration_articles" class="space_left hidden" onmouseover="toggle(\'administration_articles\')" onmouseout="toggle(\'administration_articles\')">';
	if(total('categories') > 0) {
		$output .= '<a href="'._rewrite_string.'action/article_new" title="'.l('new').'">'.l('new').'</a>';
	}
	if(total('articles',1) > 0) {
		$output .= s('divider').'<a href="'._rewrite_string.'articles" title="'.l('view').'">'.l('view').'</a>';
	}
	$output .= '</li><li onmouseover="toggle(\'administration_pages\')" onmouseout="toggle(\'administration_pages\')">'.l('pages').'</li>';
	$output .= '<li id="administration_pages" class="space_left hidden" onmouseover="toggle(\'administration_pages\')" onmouseout="toggle(\'administration_pages\')">';
	$output .= '<a href="'._rewrite_string.'action/page_new" title="'.l('new').'">'.l('new').'</a>';
	if(total('articles',2) > 0) {
		$output .= s('divider').'<a href="'._rewrite_string.'pages" title="'.l('view').'">'.l('view').'</a>';
	}
	$output .= '</li><li onmouseover="toggle(\'administration_extras\')" onmouseout="toggle(\'administration_extras\')">'.l('extras').'</li>';
	$output .= '<li id="administration_extras" class="space_left hidden" onmouseover="toggle(\'administration_extras\')" onmouseout="toggle(\'administration_extras\')">';
	$output .= '<a href="'._rewrite_string.'action/extra_new" title="'.l('new').'">'.l('new').'</a>';
	if(total('articles',3) > 0) {
		$output .= s('divider').'<a href="'._rewrite_string.'extras" title="'.l('view').'">'.l('view').'</a>';
	}
	$output .= '</li><li onmouseover="toggle(\'administration_comments\')" onmouseout="toggle(\'administration_comments\')">'.l('comments').'</li>';
	$output .= '<li id="administration_comments" class="space_left hidden" onmouseover="toggle(\'administration_comments\')" onmouseout="toggle(\'administration_comments\')">';
	if(total('comments') > 0) {
		$output .= '<a href="'._rewrite_string.'comments" title="'.l('view').'">'.l('view').'</a>';
	}
	$output .= '</li><li class="sub_headline space_bottom space_top">'.l('action').'</li>';
	$output .= '<li><a href="'._rewrite_string.'statistics" title="'.l('statistics').'">'.l('statistics').'</a></li>';
	$output .= '<li><a href="'._rewrite_string.'settings" title="'.l('settings').'">'.l('settings').'</a></li>';
	$output .= '<li><a href="'._rewrite_string.'logout" title="'.l('logout').'">'.l('logout').'</a></li>';
	$output .= '</ul></fieldset></div>';
	echo $output;
}

#admin_list
function admin_list($item = '')
{
	switch($item) {
		case 'categories':
			$table = "categories";
			$subquery = "ORDER BY rank ASC";
			$single = 'category';
			break;
		case 'articles':
			$table = "articles";
			$subquery = "WHERE position = 1 ORDER BY rank ASC";
			$single = 'article';
			break;
		case 'pages':
			$table = "articles";
			$subquery = "WHERE position = 2 ORDER BY rank ASC";
			$single = 'page';
			break;
		case 'extras':
			$table = "articles";
			$subquery = "WHERE position = 3 ORDER BY rank ASC";
			$single = 'extra';
			break;
		case 'comments':
			$table = "comments";
			$subquery = "ORDER BY rank ASC";
			$single = 'comment';
			break;
	}
	$query = "SELECT * FROM ".db('prefix')."$table $subquery";
	$result = mysql_query($query);
	$back = '<a href="'._rewrite_string.'administration" title="'.l('back').'">'.l('back').'</a>';
	if($item != 'comments') {
		$new = s('divider').'<a href="'._rewrite_string.'action/'.$single.'_new" title="'.l($single.'_new').'">'.l($single.'_new').'</a>';
	}
	$output = '<h2 class="title space_bottom">'.l($item).'</h2><div id="admin_list">';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<small>'.$back.$new.'</small>');
	if($result == '' || mysql_num_rows($result) == '') {
		$output .= '<ul class="admin_error_list space_top"><li>'.l($single.'_no').'</li></ul>';
	} else if($result) {
		$output .= '<ul class="admin_'.$item.'_list space_top"><li class="space_bottom"><span class="sub_headline">'.l('title').'</span><span class="sub_headline float_right">'.l('rank').'</span></li>';
		while($r = mysql_fetch_array($result)) {
			if($r) {
				foreach($r as $key => $value) {
					$$key = stripslashes($value);
				}
			}
			$output .= '<li onmouseover="toggle(\'admin_'.$item.'_list_'.$id.'\')" onmouseout="toggle(\'admin_'.$item.'_list_'.$id.'\')"><span>';
			if($item == 'categories' || $item == 'pages') {
				$output .= '<a href="'._rewrite_string.$sef.'" title="'.$title.'">'.$title.'</a>';
			}
			if($item == 'articles') {
				$category_sef = retrieve('sef','categories','id',$category);
				$output .= '<a href="'._rewrite_string.$category_sef.'/'.$sef.'" title="'.$title.'">'.$title.'</a>';
			}
			if($item == 'extras') {
				$output .= $title;
			}
			if($item == 'comments') {
				$article_sef = retrieve('sef','articles','id',$article);
				$article_category = retrieve('category','articles','id',$article);
				$article_category_sef = retrieve('sef','categories','id',$article_category);
				if($article_category_sef) {
					$string = $article_category_sef.'/'.$article_sef;
				} else {
					$string = $article_sef;
				}
				$output .= '<a href="'._rewrite_string.$string.'" title="'.$name.'">'.$name.'</a>';
			}
			if($language != 'all') {
				$output .= ' ('.l($language).')';
			}
			$output .= '</span><span class="float_right">'.$rank.'</span></li>';
			$output .= '<li id="admin_'.$item.'_list_'.$id.'" class="space_left hidden" onmouseover="toggle(\'admin_'.$item.'_list_'.$id.'\')" onmouseout="toggle(\'admin_'.$item.'_list_'.$id.'\')">';
			if($publish != 'fp') {
					if($rank != 1) {
						$output .= '<a href="'._rewrite_string.'action/move/'.$id.'/'.$table.'/up/'.$item.'" title="'.l('up').'">'.l('up').'</a>';
					}
					if($rank != 1 && $rank != plumb('rank',$table,'desc')) {
						$output .= s('divider');
					}
					if($rank != plumb('rank',$table,'desc')) {
						$output .= '<a href="'._rewrite_string.'action/move/'.$id.'/'.$table.'/down/'.$item.'" title="'.l('down').'">'.l('down').'</a>';
					}
			} else {
				$output .= l('future_posting');
			}
			if($rank != 1 || $rank != plumb('rank',$table,'desc') || $publish == 'fp') {
				$output .= s('divider');
			}
			$output .= '<a href="'._rewrite_string.'action/'.$single.'_edit/'.$id.'" title="'.l('edit').'">'.l('edit').'</a>';
			if($publish == 'yes') {
				$output .= s('divider').'<a href="'._rewrite_string.'action/publish/'.$id.'/'.$table.'/no/'.$item.'" title="'.l('unpublish').'">'.l('unpublish').'</a>';
			} else if($publish == 'no') {
				$output .= s('divider').'<a href="'._rewrite_string.'action/publish/'.$id.'/'.$table.'/yes/'.$item.'" title="'.l('publish').'">'.l('publish').'</a>';
			}
			$output .= '</li>';
		}
		$output .= '</ul>';
	}
	$output .= '</fieldset></div>';
	echo $output;
}

#settings
function settings()
{
	$output = '<h2 class="title space_bottom">'.l('settings').'</h2>';
	$output .= '<div class="space_bottom"><small><a href="'._rewrite_string.'administration" title="'.l('back').'">'.l('back').'</a></small></div>';
	$output .= html_input('form','','settings','','','','','','','','','','post',_rewrite_string.'action/settings_change','');
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('general').'" onclick="toggle(\'settings_general\')">'.l('general').'</a>');
	$output .= '<div id="settings_general" class="hidden">';
	$output .= '<p><label for="language">'.l('language').':</label><br /><select id="language" class="select" name="language">';
	if(count(get_directory('languages','global.php')) > 1) {
		$output .= '<option value="detect"'.(s('language') == 'detect' ? ' selected="selected"' : '').'>'.l('detect').'</option>';
	}
	foreach(get_directory('languages','global.php') as $value) {
		$value = substr($value,0,2);
		$output .= '<option value="'.$value.'"'.(s('language') == $value ? ' selected="selected"' : '').'>'.l($value).'</option>';
	}
	$output .= '</select></p>';
	$output .= '<p><label for="template">'.l('template').':</label><br /><select id="template" class="select" name="template">';
	foreach(get_directory('templates','admin') as $value) {
		$output .= '<option value="'.$value.'"'.(s('template') == $value ? ' selected="selected"' : '').'>'.$value.'</option>';
	}
	$output .= '</select></p>';
	$output .= '<p><label for="captcha">'.l('captcha').':</label><br /><select id="captcha" class="select" name="captcha">';
	$output .= '<option value="random"'.(s('captcha') == 'random' ? ' selected="selected"' : '').'>'.l('random').'</option>';
	$output .= '<option value="addition"'.(s('captcha') == 'addition' ? ' selected="selected"' : '').'>'.l('addition').'</option>';
	$output .= '<option value="subtraction"'.(s('captcha') == 'subtraction' ? ' selected="selected"' : '').'>'.l('subtraction').'</option>';
	$output .= '<option value="no"'.(s('captcha') == 'no' ? ' selected="selected"' : '').'>'.l('disable').'</option></select></p>';
	$output .= '<p><label for="paginator">'.l('paginator').':</label><br /><select id="paginator" class="select" name="paginator">';
	$output .= '<option value="yes"'.(s('paginator') == 'yes' ? ' selected="selected"' : '').'>'.l('enable').'</option>';
	$output .= '<option value="no"'.(s('paginator') == 'no' ? ' selected="selected"' : '').'>'.l('disable').'</option></select></p>';
	$output .= '<p><label for="counter">'.l('counter').':</label><br /><select id="counter" class="select" name="counter">';
	$output .= '<option value="yes"'.(s('counter') == 'yes' ? ' selected="selected"' : '').'>'.l('enable').'</option>';
	$output .= '<option value="no"'.(s('counter') == 'no' ? ' selected="selected"' : '').'>'.l('disable').'</option></select></p>';
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('metadata').'" onclick="toggle(\'settings_metadata\')">'.l('metadata').'</a>');
	$output .= '<div id="settings_metadata" class="hidden">';
	$output .= html_input('text','title','title',s('title'),l('title'),'text','maxlength="50"','','','','','','','','');
	$output .= html_input('text','author','author',s('author'),l('author'),'text','maxlength="50"','','','','','','','','');
	$output .= html_input('text','copyright','copyright',s('copyright'),l('copyright'),'text','maxlength="50"','','','','','','','','');
	$output .= html_input('text','description','description',s('description'),l('description'),'text','maxlength="255"','','','','','','','','');
	$output .= html_input('text','keywords','keywords',s('keywords'),l('keywords'),'text','maxlength="255"','','','','','','','','');
	$output .= '<p><label for="robots">'.l('robots').':</label><br /><select id="robots" class="select" name="robots">';
	$output .= '<option value="all"'.(s('robots') == 'all' ? ' selected="selected"' : '').'>'.l('index').'</option>';
	$output .= '<option value="none"'.(s('robots') == 'none' ? ' selected="selected"' : '').'>'.l('index_no').'</option></select></p>';
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('contact').'" onclick="toggle(\'settings_contact\')">'.l('contact').'</a>');
	$output .= '<div id="settings_contact" class="hidden">';
	$output .= html_input('text','email','email',s('email'),l('email'),'text','maxlength="50"','','','','','','','','');
	$output .= html_input('text','subject','subject',s('subject'),l('subject'),'text','maxlength="50"','','','','','','','','');
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('formatting').'" onclick="toggle(\'settings_formatting\')">'.l('formatting').'</a>');
	$output .= '<div id="settings_formatting" class="hidden">';
	$output .= html_input('text','charset','charset',s('charset') == '' ? 'utf-8' : s('charset'),l('charset'),'text','maxlength="10"','','','','','','','','');
	$output .= html_input('text','divider','divider',s('divider') == '' ? '&#8201;&#8226;&#8201;' : s('divider'),l('divider'),'text','maxlength="10"','','','','','','','','');
	$output .= '<p><label for="time">'.l('time').':</label><br /><select id="time" class="select" name="time">';
	$output .= '<option value="H:i"'.(s('time') == 'H:i' ? ' selected="selected"' : '').'>H:i</option>';
	$output .= '<option value="h:i"'.(s('time') == 'h:i' ? ' selected="selected"' : '').'>h:i</option></select></p>';
	$output .= '<p><label for="date">'.l('date').':</label><br /><select id="date" class="select" name="date">';
	$output .= '<option value="d.m.Y"'.(s('date') == 'd.m.Y' ? ' selected="selected"' : '').'>d.m.Y</option>';
	$output .= '<option value="m.d.Y"'.(s('date') == 'm.d.Y' ? ' selected="selected"' : '').'>m.d.Y</option>';
	$output .= '<option value="Y.d.m"'.(s('date') == 'Y.d.m' ? ' selected="selected"' : '').'>Y.d.m</option></select></p>';
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('contents').'" onclick="toggle(\'settings_contents\')">'.l('contents').'</a>');
	$output .= '<div id="settings_contents" class="hidden">';
	$output .= '<p><label for="homepage">'.l('homepage').':</label><br /><select id="homepage" class="select" name="homepage">';
	$output .= '<option value="0"'.(s('homepage') == 0 ? ' selected="selected"' : '').'>'.l('none').'</option>';
	$query = "SELECT * FROM ".db('prefix')."articles WHERE position = 2 ORDER BY id ASC";
	$result = mysql_query($query);
	if($result) {
		while($r = mysql_fetch_array($result)) {
			$output .= '<option value="'.$r['id'].'"';
			if(s('homepage') == $r['id']) {
				$output .= ' selected="selected"';
			}
			$output .= '>'.$r['title'].'</option>';
		}
	}
	$output .= '</select></p>';
	$output .= html_input('text','limit','limit',s('limit') == '' ? 10 : s('limit'),l('limit'),'text','maxlength="2"','','','','','','','','');
	$output .= '<p><label for="order">'.l('order').':</label><br /><select id="order" class="select" name="order">';
	$output .= '<option value="desc"'.(s('order') == 'desc' ? ' selected="selected"' : '').'>'.l('ascending').'</option>';
	$output .= '<option value="asc"'.(s('order') == 'asc' ? ' selected="selected"' : '').'>'.l('descending').'</option></select></p>';
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('comments').'" onclick="toggle(\'settings_comments\')">'.l('comments').'</a>');
	$output .= '<div id="settings_comments" class="hidden">';
	$output .= '<p><label for="moderation">'.l('moderation').':</label><br /><select id="moderation" class="select" name="moderation">';
	$output .= '<option value="yes"'.(s('moderation') == 'yes' ? ' selected="selected"' : '').'>'.l('enable').'</option>';
	$output .= '<option value="no"'.(s('moderation') == 'no' ? ' selected="selected"' : '').'>'.l('disable').'</option></select></p>';
	$output .= '<p><label for="notification">'.l('notification').':</label><br /><select id="notification" class="select" name="notification">';
	$output .= '<option value="yes"'.(s('notification') == 'yes' ? ' selected="selected"' : '').'>'.l('enable').'</option>';
	$output .= '<option value="no"'.(s('notification') == 'no' ? ' selected="selected"' : '').'>'.l('disable').'</option></select></p>';
	$output .= '</div></fieldset>';
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('database').'" onclick="toggle(\'settings_database\')">'.l('database').'</a>');
	$output .= '<div id="settings_database" class="hidden">';
	$output .= html_input('text','host','',db('host'),l('host'),'text','','','','readonly','','','','','');
	$output .= html_input('text','name','',db('name'),l('name'),'text','','','','readonly','','','','','');
	$output .= html_input('text','username','',db('username'),l('username'),'text','','','','readonly','','','','','');
	$output .= html_input('text','prefix','',db('prefix'),l('prefix'),'text','','','','readonly','','','','','');
	$output .= html_input('text','mode','',db('mode') == 'normal' ? l('normal') : l('demo'),l('mode'),'text','','','','readonly','','','','','');
	$output .= '</div></fieldset><p>';
	$output .= html_input('submit','settings_change','settings_change',l('save'),'','button','','','','','','','','','');
	$output .= '</p></form>';
	$output .= html_input('form','','','','','','','','','','','','post',_rewrite_string.'action/login_change','');
	$output .= html_input('fieldset','','','','','','','','','','','','','','<a title="'.l('login').'" onclick="toggle(\'settings_login\')">'.l('login').'</a>');
	$output .= '<div id="settings_login" class="hidden">';
	$output .= '<p>'.l('login_limit').'</p>';
	$output .= html_input('text','username','username','',l('username'),'text','maxlength="10"','','','','','','','','');
	$output .= html_input('password','password1','password1','',l('password'),'text','maxlength="10"','','','','','','','','');
	$output .= html_input('password','password2','password2','',l('password_again'),'text','maxlength="10"','','','','','','','','');
	$output .= html_input('hidden','email','',s('email'),'','','','','','','','','','','');
	$output .= '</div></fieldset><p>';
	$output .= html_input('submit','login_change','login_change',l('save'),'','button','','','','','','','','','');
	$output .= '</p></form>';
	echo $output;
}
?>