<?php
#check_login
function check_login($input = '')
{
	$output = clean($input);
	$output = strip_tags($output);
	if(ctype_alnum($output) && strlen($output) > 4 && strlen($output) < 11) {
		return $output;
	}
}

#check_email
function check_email($input = '')
{
	$output = clean_mysql($input);
	$output = clean_script($output);
	$output = clean_html($output);
	if(preg_match('/[A-Z0-9._-]+@[A-Z0-9][A-Z0-9.-]{0,50}[A-Z0-9]\.[A-Z0-9.]{2,6}$/i',$output)) {
		list($username,$domain) = split('@',$output);
		if(function_exists('checkdnsrr') && !checkdnsrr($domain,'mx')) {
			$output = '';
		}
		return $output;
	}
}

#check_url
function check_url($input = '')
{
	$output = clean_mysql($input);
	$output = clean_script($output);
	$output = clean_html($output);
	if(preg_match('/[A-Z0-9][A-Z0-9.-]{0,50}[A-Z0-9]\.[A-Z0-9.]{2,6}$/i',$output)) {
		$output = substr($output,0,7) != 'http://' && substr($output,0,8) != 'https://' ? 'http://'.$output : $output;
		list($protocol,$domain) = split('//',$output);
		if(function_exists('checkdnsrr') && !checkdnsrr($domain,'mx')) {
			$output = '';
		}
		return $output;
	}
}

#check_sef
function check_sef($input = '',$mode = '')
{
	switch($mode) {
		case 'illegal':
			if($input != clean_special($input) || is_numeric($input)) {
				$output = 'yes';
			} else {
				$output = 'no';
			}
			break;
		default:
			$default_sef = explode(',',b('default_sef'));
			if(in_array($input,$default_sef)) {
				$output = 'yes';
			} else {
				$output = 'no';
			}
			break;
	}
	return $output;
}
?>