<?php
#clean
function clean($input = '') {
	$output = clean_mysql($input);
	$output = clean_script($output);
	$output = clean_html($output);
	$output = clean_special($output);
	return $output;
}

#clean_mysql
function clean_mysql($input = '')
{
	if(get_magic_quotes_gpc()) {
		$input = stripslashes($input);
	}
	if(_connect_to_db == 'yes' && function_exists('mysql_real_escape_string')) {
		$output = mysql_real_escape_string($input);
	} else if(function_exists('mysql_escape_string')) {
		$output = mysql_escape_string($input);
	}
	return $output;
}

#clean_script
function clean_script($input = '') {
	$search_characters = explode(',',b('script_characters'));
	$search_tags = explode(',',b('script_tags'));
	foreach($search_tags as $value => $item) {
		$replace_tags[$value] = '['.$item.']';
	}
	$output = replace($search_characters,'',$input);
	$output = replace($search_tags,$replace_tags,$output);
	return $output;
}

#clean_html
function clean_html($input = '') {
	$search = explode(',',b('html_tags').','.b('html_attributes'));
	foreach($search as $value => $item) {
		$replace[$value] = '['.$item.']';
	}
	$output = replace($search,$replace,$input);
	return $output;
}

#clean_special
function clean_special($input = '') {
	$output = preg_replace('/[^A-Z0-9_]+$/i','',$input);
	return $output;
}
?>