<?php
#html_input
function html_input($type = '',$name = '',$id = '',$value = '',$label = '',$class = '',$script1 = '',$script2 = '',$script3 = '',$status = '',$rows = '',$cols = '',$method = '',$action = '',$legend = '')
{
	if($id == '') {
		$label_string = '<label>'.$label.'</label>';
	} else if($label) {
		$label_string = '<label for="'.$id.'">'.$label.'</label>';
	}
	$id_string = $id ? ' id="'.$id.'"' : '';
	$class_string = $class ? ' class="'.$class.'"' : '';
	$script1_string = $script1 ? ' '.$script1 : '';
	$script2_string = $script2 ? ' '.$script2 : '';
	$script3_string = $script3 ? ' '.$script3 : '';
	$attribute_string = $id_string.$class_string.$script1_string.$script2_string.$script3_string;
	$value_string = ' value="'.$value.'"';
	$readonly_string = $status == 'readonly' ? ' readonly="readonly"' : '';
	$checked_string = $status == 'checked' ? ' checked="checked"' : '';
	$input_string = '<input type="'.$type.'" name="'.$name.'"'.$attribute_string;
	switch($type) {
		case 'form':
			$output = $method && $method != 'end' ? '<form method="'.$method.'" action="'.$action.'"'.$attribute_string.' accept-charset="'._charset.'">' : '</form>';
			break;
		case 'fieldset':
			$output = $legend && $legend != 'end' ? '<fieldset><legend'.$attribute_string.'>'.$legend.'</legend>' : '</fieldset>';
			break;
		case 'text':
		case 'password':
			$output = '<p>'.$label_string.': <br />'.$input_string.$value_string.$readonly_string.' /></p>';
			if($label == '') {
				$output = $input_string.$value_string.$readonly_string.' />';
			}
			break;
		case 'checkbox':
		case 'radio':
			$output = '<p>'.$input_string.$checked_string.' />'.$label_string.'</p>';
			break;
		case 'hidden':
		case 'submit':
		case 'reset':
		case 'button':
			$output = $input_string.$value_string.' />';
			break;
		case 'textarea':
			$output = '<p>'.$label_string.': <br /><textarea name="'.$name.'" rows="'.$rows.'" cols="'.$cols.'"'.$attribute_string.'>'.$value.'</textarea></p>';
			break;
	}
	return $output;
}

#html_select_date
function html_select_date($date = '',$unit = '',$number1 = '',$number2 = '',$format = '',$start = '',$limit = '')
{
	$output = '<p><label for="'.$unit.'">'.l($unit).':</label><br /><select id="'.$unit.'" class="select" name="'.$unit.'">';
	$$unit = $date ? substr($date,$number1,$number2) : intval(date($format));
	for($i = $start; $i < $limit; $i++) {
		$output .= '<option value="'.$i.'"';
		if($i == $$unit) {
			$output .= ' selected="selected"';
		}
		$output .= '>'.$i.'</option>';
	}
	$output .= '</select></p>';
	return $output;
}
?>