<?php
#rss_list
function rss_list()
{
	if(_rewrite == 'yes') {
		$language_string = '.'._language;
	} else {
		$language_string = '&amp;language='._language;
	}
	$output = '<ul class="rss_list">';
	if(total('articles',1) > 0) {
		$output .= '<li><a href="'._rewrite_string.'rss_articles'.$language_string.'" title="'.l('rss_articles').'">'.l('rss_articles').'</a></li>';
	}
	if(total('articles',2) > 0) {
		$output .= '<li><a href="'._rewrite_string.'rss_pages'.$language_string.'" title="'.l('rss_pages').'">'.l('rss_pages').'</a></li>';
	}
	if(total('comments') > 0) {
		$output .= '<li><a href="'._rewrite_string.'rss_comments'.$language_string.'" title="'.l('rss_comments').'">'.l('rss_comments').'</a></li>';
	}
	$article = retrieve('id','articles','sef',_article_sef);
	$page = retrieve('id','articles','sef',_category_sef);
	if($article) {
		$comment_article_counter = retrieve('count(id)','comments','article',$article);
		if($comment_article_counter > 0) {
			$output .= '<li><a href="'._rewrite_string.'rss_comments/'._article_sef.$language_string.'" title="'.l('rss_comments_article').'">'.l('rss_comments_article').'</a></li>';
		}
	} else if($page) {
		$comment_article_counter = retrieve('count(id)','comments','article',$page);
		if($comment_article_counter > 0) {
			$output .= '<li><a href="'._rewrite_string.'rss_comments/'._category_sef.$language_string.'" title="'.l('rss_comments_page').'">'.l('rss_comments_page').'</a></li>';
		}
	}
	$output .= '</ul>';
	echo $output;
}

#rss_generator
function rss_generator()
{
	if($_GET['language'] && file_exists('languages/'.$_GET['language'].'.php')) {
		$language = clean($_GET['language']);
		if(_rewrite == 'yes') {
			$language_string = '.'.$language;
		} else {
			$language_string = '&amp;language='.$language;
		}
	}
	switch(_category_sef) {
		case 'rss_articles':
			$description = l('articles');
			$subquery = "articles WHERE (language = '".$language."' || language = 'all') && position = 1 && publish = 'yes' ORDER BY rank "._order." LIMIT "._limit."";
			break;
		case 'rss_pages':
			$description = l('pages');
			$subquery = "articles WHERE (language = '".$language."' || language = 'all') && position = 2 && publish = 'yes' ORDER BY rank ASC";
			break;
		case 'rss_comments':
			$description = l('comments');
			$subquery = "comments WHERE (language = '".$language."' || language = 'all') && publish = 'yes'";
			if(retrieve('id','articles','sef',_article_sef)) {
				$article = retrieve('id','articles','sef',_article_sef);
				$subquery .= " && article = $article";
			} else if(retrieve('id','articles','sef',_category_sef)) {
				$page = retrieve('id','articles','sef',_category_sef);
				$subquery .= " && article = $page";
			}
			$subquery .= " ORDER BY rank "._order." LIMIT "._limit."";
			break;
	}
	header('Content-type: text/xml');
	$output .= '<?xml version="1.0" encoding="'._charset.'"?>'."\n";
	$output .= '<rss version="2.0" xmlns:atom="http://www.w3.org/2005/Atom">'."\n";
	$output .= '<channel>'."\n";
	$output .= '<title>'.s('title').'</title>'."\n";
	$output .= '<description>'.$description.'</description>'."\n";
	$output .= '<link>'._rewrite_string._full_string.$language_string.'</link>'."\n";
	$output .= '<atom:link href="'._rewrite_string._full_string.$language_string.'" rel="self" type="application/rss+xml" />'."\n";
	$output .= s('copyright') == '' ? '' : '<copyright>'.s('copyright').'</copyright>'."\n";
	$output .= '<generator>'.l('rs_name').'</generator>'."\n";
	$query = "SELECT * FROM ".db('prefix')."$subquery";
	$result = mysql_query($query);
	if($result) {
		while($r = mysql_fetch_array($result)) {
			if($r) {
				foreach($r as $key => $value) {
					$$key = stripslashes($value);
				}
			}
			$date = date(r,strtotime($date));
			if(_category_sef == 'rss_articles') {
				$category_sef = retrieve('sef','categories','id',$category);
				$string = $category_sef.'/'.$sef;
			} else if(_category_sef == 'rss_pages') {
				$string = $sef;
			} else if(_category_sef == 'rss_comments') {
				$title = $name;
				$article_sef = retrieve('sef','articles','id',$article);
				$article_category = retrieve('category','articles','sef',$article_sef);
				$article_category_sef = retrieve('sef','categories','id',$article_category);
				if($article_category_sef) {
					$string = $article_category_sef.'/'.$article_sef;
				} else {
					$string = $article_sef;
				}
			}
			$output .= '<item>'."\n";
			$output .= '<title>'.strip($title).'</title>'."\n";
			$output .= '<description>'.strip($text).'</description>'."\n";
			$output .= '<pubDate>'.$date.'</pubDate>'."\n";
			$output .= '<link>'._rewrite_string.$string.$language_string.'</link>'."\n";
			$output .= '<guid>'._rewrite_string.$string.$language_string.'</guid>'."\n";
			$output .= '</item>'."\n";
		}
	}
	$output .= '</channel>'."\n";
	$output .= '</rss>';
	echo $output;
	exit;
}

#rss_reader
function rss_reader($url = '',$limit = '')
{
	$contents = file_get_contents($url);
	if($contents) {
		preg_match_all('/<item.*>(.+)<\/item>/Uism',$contents,$items);
	} else {
		break;
	}
	foreach($items[1] as $value) {
		if($i++ == $limit) {
			break;
		}
		preg_match('/<title>(.+)<\/title>/Uism',$value,$title);
		preg_match('/<link>(.+)<\/link>/Uism',$value,$link);
		preg_match('/<pubDate>(.+)<\/pubDate>/Uism',$value,$date);
		preg_match('/<description>(.*)<\/description>/Uism',$value,$description);
		$title = entity($title[1]);
		$link = $link[1];
		$time = date(s('time'),strtotime($date[1]));
		$date = date(s('date'),strtotime($date[1]));
		$description = entity($description[1]);
		if($title && $link) {
			$output = '<h3 class="rss_title"><a href="'.$link.'" title="'.$title.'">'.$title.'</a></h3>';
		}
		if($time && $date) {
			$output .= '<small class="rss_date">'.$date.' '.l('at').' '.$time.'</small>';
		}
		if($description) {
			$output .= '<p class="rss_description">'.$description.'</p>';
		}
		echo $output;
	}
}
?>