if(window.addEventListener) {
	window.addEventListener('load',update_preview,'');
} else if(window.attachEvent) {
	window.attachEvent('onload',update_preview);
}

window.onload = hide_onload;

function update_preview()
{
	if(document.getElementById('text')) {
		var output = document.getElementById('text').value;
		document.getElementById('preview').innerHTML = output;
	}
	setTimeout("update_preview()",500);
}

function resize_input(input) {
	var a = input.value.split('\n');
	var b = 1;
	for(var i = 0; i < a.length; i++) {
		if(a[i].length > input.cols) {
			b = b + (Math.floor(a[i].length/input.cols));
		}
	}
	b = b + a.length;
	if(b > input.rows) {
		input.rows = b;
	}
}

function hide_input(input,guide) {
	query = input.value;
	if(query == guide) {
		input.value = '';
	}
}

function show_input(input,guide) {
	query = input.value;
	if(query == '') {
		input.value = guide;
	}
}

function hide_onload() {
	var tags = document.getElementsByTagName('*');
	for(var i = 0; i < tags.length; i++) {
		var classes = new String(tags[i].className).split(' ');
		for(var j = 0; j < classes.length; j++) {
			if(classes[j] == 'hidden') {		 
				tags[i].style.display = 'none';
			}
		}
	}
}

function toggle(input)
{
	var tag = document.getElementById(input);
	if(tag.style.display == '') {
		tag.style.display = 'none';
		return;
	}
	tag.style.display = '';
}