<?php
/*
WJCMS V1.1
WEBSITE: HTTP://WWW.WJCMS.CN
HELP: HTTP://BBS.WJCMS.CN
˵:δWJCMS.CNϻ߹ٷָվظ.ʹøľɵĺ.WJCMSŲ
*/
if(!defined('WJ_CMS')) exit('Access Denied');

class water{
	var $img;
	var $config;
	
	function __construct($img,$water='') {
		if (!$water) {
			require WJCMS_CACHE."wjcms_water.cache.php";
		}
		$this->img=$img;
		$this->config=$water;
	}
	
	function watermark() {
		$img=$this->img;
		if (!$this->checkimg($img))return false;
		$img_info = getimagesize($img);
		$img_width = $img_info[0];
		$img_height = $img_info[1];
		if($img_width < $this->config[minwidth] || $img_height < $this->config[minheight]) return false;
		switch ($img_info[2]) {
			case 1 :
				$img_new = imagecreatefromgif($img);
				break;
			case 2 :
				$img_new = imagecreatefromjpeg($img);
				break;
			case 3 :
				$img_new = imagecreatefrompng($img);
				break;
			default :
				return false;
		}
		if ($this->config[type]==1) { //ˮӡ
			$ifwaterimage = 0;
			$temp = imagettfbbox(ceil(5*2.5), 0, $this->config[ttf], $this->config[text]);
			$width = $temp[2] - $temp[6];
			$height = $temp[3] - $temp[7];
			unset($temp);
		} elseif ($this->config[type]==2) {//ͼƬˮӡ
			$ifwaterimage = 1;
			$water_info   = getimagesize($this->config[file]);
			$width        = $water_info[0];
			$height       = $water_info[1];
			switch($water_info[2]){
				case 1 :
					$water_img = imagecreatefromgif($this->config[file]);
					break;
				case 2 :
					$water_img = imagecreatefromjpeg($this->config[file]);
					break;
				case 3 :
					$water_img = imagecreatefrompng($this->config[file]);
					break;
				default :
					return;
			}
		}
		switch($this->config[pos]) { //
			case 0:
				$wx = rand(0,($img_width - $width));
				$wy = rand(0,($img_height - $height));
				break;
			case 1:
				$wx = 5;
				$wy = 5;
				break;
			case 2:
				$wx = ($img_width - $width) / 2;
				$wy = 0;
				break;
			case 3:
				$wx = $img_width - $width;
				$wy = 0;
				break;
			case 4:
				$wx = 0;
				$wy = ($img_width - $height) / 2;
				break;
			case 5:
				$wx = ($img_width - $width) / 2;
				$wy = ($img_height - $height) / 2;
				break;
			case 6:
				$wx = ($img_width - $width) / 2;
				$wy = $img_height - $height;
				break;
			case 7:
				$wx = 0;
				$wy = $img_height - $height;
				break;
			case 8:
				$wx = ($img_width - $width) / 2;
				$wy = $img_height - $height;
				break;
			case 9:
				$wx = $img_width - $width;
				$wy = $img_height - $height;
				break;
			default:
				$wx = rand(0,($img_width - $width));
				$wy = rand(0,($$img_height - $height));
				break;
		}
		if($ifwaterimage) {
			imagecopymerge($img_new, $water_img, $wx, $wy, 0, 0, $width, $height, $this->config[pct]);
		} else {
			$r = hexdec(substr($this->config[color],1,2));
			$g = hexdec(substr($this->config[color],3,2));
			$b = hexdec(substr($this->config[color],5));
			imagestring($img_new,$this->config[size],$wx,$wy,$this->config[text],imagecolorallocate($img_new,$r,$g,$b));
		}
		switch($img_info[2]){
			case 1 :
				imagegif($img_new, $img);
				break;
			case 2 :
				imagejpeg($img_new, $img, $this->config[quality]);
				break;
			case 3 :
				imagepng($img_new, $img);
				break;
			default :
				return;
		}
		if(isset($water_info)){
			unset($water_info);
		}
		if(isset($water_img)){
			imagedestroy($water_img);
		}
		unset($img_info);
		imagedestroy($img_new);
		return true;
	}
	
	function checkimg($img) {
		return extension_loaded('gd') && preg_match("/\.(jpg|jpeg|gif|png)/i", $img, $m) && file_exists($img) && function_exists('imagecreatefrom'.($m[1] == 'jpg' ? 'jpeg' : $m[1]));
	}
}
?>