<?php
function copyDir($source, $destination)
{
	$source = R_P.'codeTemplate'.DIRECTORY_SEPARATOR.$source;
	$destination = R_P.$destination;
	if (file_exists($destination)) Showmsg('channel_err_2');
	$result = true;
	if(!is_dir($source)) Showmsg('dirErr_1');

	if(!is_dir($destination) && !mkdir($destination, 0700)) Showmsg('dirErr_2');


	$handle = opendir($source);
	while(($file = readdir($handle)) !== false) 
	{
		if($file != '.' && $file != '..')
		{
			$src = $source . DIRECTORY_SEPARATOR . $file;
			$dtn = $destination . DIRECTORY_SEPARATOR . $file;
			if(is_dir($src))
			{
				copyDir($src, $dtn);
			}
			else 
			{  
				if(! copy($src, $dtn))
				{
					$result = false;
					break;
				}
			}
		}
	}
	closedir($handle);

	return $result;
}

function delDir($dir) {

	$dh=opendir($dir);
	if (!$dh) return true;
	else {
		while ($file=readdir($dh)) {
			if($file!="." && $file!="..") {
				$fullpath=$dir."/".$file;
				if(!is_dir($fullpath)) {
					unlink($fullpath);
				} else {
					deldir($fullpath);
				}
			}
		}

		closedir($dh);

		if(rmdir($dir)) {
			return true;
		} else {
			return false;
		}
	}
}
?>
