<?php

!defined('IN_HDWIKI') && exit('Access Denied');

require HDWIKI_ROOT.'/version.php';
require HDWIKI_ROOT.'/lib/file.class.php';
require HDWIKI_ROOT.'/lib/util.class.php';
require HDWIKI_ROOT.'/lib/hddb.class.php';
require HDWIKI_ROOT.'/lib/template.class.php';
require HDWIKI_ROOT.'/lib/cache.class.php';

class base {

	var $ip;
	var $time;
	var $db;
	var $view;
	var $cache;
	var $forward;
	var $user = array();
	var $setting = array();
	var $advertisement = array();
	var $channel = array();
	var $style=array();
	var $plugin = array();
	var $get = array();
	var $post = array();

	function base(& $get,& $post) {
		$this->time = time();
		$this->ip =util::getip();
		$this->get=& $get;
		$this->post=& $post;
		$this->init_db();
		$this->init_cache();
		$this->init_user();
		$this->init_template();
		$this->checkbanned();
	}

	function init_db(){
		$this->db=new hddb(DB_HOST, DB_USER, DB_PW, DB_NAME , DB_CHARSET , DB_CONNECT);
	}

	function init_cache(){
		$this->cache=new cache();
		$this->setting=$this->_load_cache('setting');
		$this->advertisement=$this->_load_cache('advertisement',1);
		$this->channel=$this->_load_cache('channel',1);
		$this->style= $this->_load_cache('style',1);
		$this->plugin= $this->_load_plugincache();
	}

	function _load_cache($cachename,$available=0){
		$cachedata=$this->cache->getcache($cachename);
		if(!is_array($cachedata)){
			$cachedata=array();
			$sql="select * from ".DB_TABLEPRE.$cachename;
			if($available){
				$sql=$sql."  where  available=1";
			}
			$query=$this->db->query($sql);
			if (!$query){
				return false;
			}
			while($data=$this->db->fetch_array($query)){
				if($available){
					$cachedata[]=$data;
				}else{
					if( isset($data['variable']) ){
						$cachedata[$data['variable']]=$data['value'];
					}else{
						$cachedata[$data['find']]=$data['replacement'];
					}
				}
			}
			$this->cache->writecache($cachename,$cachedata);
		}
		return $cachedata;
	}

	function _load_plugincache(){
		$plugindata=$this->cache->getcache('plugin');
		if(!is_array($plugindata)){
			$this->load('plugin');
			$plugindata=$_ENV['plugin']->read_all();
			$this->cache->writecache('plugin',$plugindata);
		}
		return $plugindata;
	}

	function init_template(){
		@$style=$this->hgetcookie('style');
		if(!isset($style)){
			$style=$this->setting['style_name'];
		}
		$this->view=new template($style);
		$this->view->setlang($this->setting['lang_name'],'front');
		//passport include
		$ppfile=HDWIKI_ROOT.'/data/passport.inc.php';
		if(file_exists($ppfile)){
			include($ppfile);
			$this->forward=$_SERVER['HTTP_REFERER'] ? $_SERVER['HTTP_REFERER']:$this->setting['site_url'];
			if(PP_TYPE=='client')
				$this->view->assign('pp_api',PP_API.PP_LOGIN);
		}
		$this->view->assign('pluginlist', array_values($this->plugin) );
		$advlist=$this->adv_filter($this->advertisement);
		if($advlist){
			$this->view->assign('advlist',$advlist);
		}
		$this->view->assign('channellist',$this->channel);
		$this->view->assign('stylelist',$this->style);
		$this->view->assign('user',$this->user);

		$referer=empty($_SERVER["QUERY_STRING"]) ? '' : "-".$this->setting['seo_prefix'].$_SERVER["QUERY_STRING"];
		$this->view->assign('referer',urlencode($referer) );
		$this->view->assign('timenow',$this->date($this->time,3));
		$this->view->assign('setting',$this->setting);
		$this->view->assign('navtitle','');
		
		$header_regulars = '';
		if ($this->checkable('doc-edit')) $header_regulars .= ',doc-edit';
		if ($this->checkable('doc-sandbox')) $header_regulars .= ',doc-sandbox';
		if ($this->checkable('doc-create')) $header_regulars .= ',doc-create';
		
		$this->view->assign('header_regulars', $header_regulars);
		
		if(isset($this->plugin["ucenter"]["available"])){
			$this->view->assign('isUcenter', true);
		}
		if($this->user['uid']){
			$this->view->assign('newpms',$this->newpms($this->user['uid']));
		}
		$this->view->assign('style',$style);
		$this->view->assign('pp_forward',$this->forward);
		$this->view->assign('adminlogin',$this->checkable('admin_main-login') );
	}

	function load($model, $base = NULL) {
		$base = $base ? $base : $this;
		if(empty($_ENV[$model])) {
			require HDWIKI_ROOT."/model/$model.class.php";
			eval('$_ENV[$model] = new '.$model.'model($base);');
		}
		return $_ENV[$model];
	}

	function loadplugin($model, $identifier=NULL) {
		$identifier = $identifier ? $identifier : $model ;
		if(empty($_ENV[$model])) {
			require HDWIKI_ROOT."/plugins/$identifier/model/$model.class.php";
			eval('$_ENV[$model] = new '.$model.'model($this);');
		}
		return $_ENV[$model];
	}

	function init_user() {
		@$sid=$this->hgetcookie('sid');
		@$uid=$this->hgetcookie('uid');
		if(isset($sid)) {
			if($uid){
				$this->user=$this->db->fetch_first("select u.*, g.*, s.* from ".DB_TABLEPRE."user u,".DB_TABLEPRE."usergroup g,".DB_TABLEPRE."session s where s.uid=u.uid and s.sid='$sid'  and u.groupid=g.groupid");
			}else{
				$this->user=$this->db->fetch_first("select g.*, s.* from ".DB_TABLEPRE."usergroup g,".DB_TABLEPRE."session s where  s.sid='$sid' and g.groupid=1");
			}
			$this->db->query("delete from ".DB_TABLEPRE."session where sid != '$sid' and uid=".$this->user['uid']);
		}else{
			$sid=util::random(6);
			$this->hsetcookie('sid',$sid,24*3600*365);
			$this->hsetcookie('uid',0,24*3600*365);
		}
		if(!(bool)$this->user){
			$this->user=$this->db->fetch_first("select * from ".DB_TABLEPRE."usergroup where groupid=1");
			$this->user['sid']=$sid;
			$this->db->query("replace into ".DB_TABLEPRE."session (sid,uid,username,`time`) values ('$sid',0,'".$this->user['grouptitle']."',$this->time)");
			if($uid){
				$this->hsetcookie('uid',0,24*3600*365);
			}
		}
	}

	function message($message, $redirect = '', $type = 1) {
		$this->view->assign('message', $message);
		$this->view->assign('redirect', $redirect);
		if($type == 0) {
			$this->view->display('message');
		} else if($type == 1){
			$this->view->display('admin_message');
		}else {
			$this->view->assign('ajax', 1);
			$this->view->assign('charset', WIKI_CHARSET);
			$this->view->display('message');
		}
		exit;
	}

	function header($url=''){
		if(empty($url)){
			header("Location:{$this->setting['site_url']}");
		}else{
			header("Location:{$this->setting['seo_prefix']}$url{$this->setting['seo_suffix']}");
		}
	}

	function date($time, $type = 3, $friendly=0) {
		$format[] = $type & 2 ? (!empty($this->setting['date_format']) ? $this->setting['date_format'] : 'Y-n-j') : '';
		$format[] = $type & 1 ? (!empty($this->setting['time_format']) ? $this->setting['time_format'] : 'H:i') : '';
		$timeoffset=$this->setting['time_offset']*3600+$this->setting['time_diff']*60;
		$timestring=gmdate(implode(' ', $format), $time + $timeoffset);
		if($friendly){
			$dtime=$this->time -$time;
			$dday=intval(date('Ymd',$this->time))-intval(date('Ymd',$time));
			$dyear=intval(date('Y',$this->time))-intval(date('Y',$time));
			if($dtime<60){
				$timestring= $dtime.$this->view->lang['beforeSeconds'];
			}elseif($dtime<3600){
				$timestring= intval($dtime/60).$this->view->lang['beforeMinutes'];
			}elseif($dtime>=3600 && 0==$dday){
				$timestring= intval($dtime/3600).$this->view->lang['beforeHours'];
			}
		}
		return $timestring;
	}

	function checkable($url){
		if(4==$this->user['groupid']){
			return true;
		}
		$anonymous_regular='user-boxlogin|user-login|user-check|user-checkusername|user-checkcode|user-checkpassword|user-getpass|user-code|hdapi-default';
		$regulars = explode('|', $anonymous_regular.'|'.$this->user['regulars']);
		return in_array($url,$regulars);
	}

	function checkbanned() {
		$ips=$this->cache->getcache('bannedip');
		$ips=(bool)$ips?$ips:array();
		$userip=explode(".",$this->ip);
		foreach($ips as $ip){
			$bannedtime=$ip['expiration']+$ip['time']-$this->time;
			if( $bannedtime>0
				&&($ip['expiration']&&$ip['ip1']=='*'||$ip['ip1']==$userip[0])
				&&($ip['ip2']=='*'||$ip['ip2']==$userip[1])
				&&($ip['ip3']=='*'||$ip['ip3']==$userip[2])
				&&($ip['ip4']=='*'||$ip['ip4']==$userip[3])
			){
				$this->message($this->view->lang['bannedIP'],'',0);
			}
		}
	}

	function hsetcookie($var, $value, $life = 0) {
		$domain=$this->setting['cookie_domain']?$this->setting['cookie_domain']:'';
		$cookiepre=$this->setting['cookie_pre']?$this->setting['cookie_pre']:'hd_';
		setcookie($cookiepre.$var, $value,$life ? $this->time + $life : 0, '/',$domain, $_SERVER['SERVER_PORT'] == 443 ? 1 : 0);
	}
	
	function hgetcookie($var) {
		$cookiepre=$this->setting['cookie_pre']?$this->setting['cookie_pre']:'hd_';
		return $_COOKIE[$cookiepre.$var];
 	}
	
	function writelog($regular,$pluginid){
		if(''==$pluginid){
			$menu=$this->db->fetch_first("select name from ".DB_TABLEPRE."regular where regular like'%".$regular."%'");
		}else{
			if(is_numeric($pluginid)){
				$menu=$this->db->fetch_first("select name from ".DB_TABLEPRE."plugin where pluginid='".$pluginid."'");
			}
		}
		$str="<?php exit;?>"."	".$this->user['username']."	".$this->user['grouptitle']."	".$this->ip."	".$this->date($this->time)."	".$menu['name']."	".$regular."\r\n";
		file::forcemkdir(HDWIKI_ROOT."/data/logs");
		$handle = fopen(HDWIKI_ROOT."/data/logs/".date('Ym')."_adminaccess.php","a");
		fwrite($handle,$str);
		fclose($handle);
	}
	
	function newpms($uid){
		$newpms=$totalpms=0;
		$blacklist=$this->db->fetch_first('select blacklist from '.DB_TABLEPRE.'blacklist where uid='.$uid);
		if('[ALL]]'!=$blacklist['blacklist']){
			$blackuser=str_replace(",","','",$blacklist['blacklist']);
			$query=$this->db->query('select id,new,delstatus from '.DB_TABLEPRE.'pms where toid='.$uid." and delstatus!=2 and  drafts!=1 and `from` not in ('$blackuser')");
			while($pms=$this->db->fetch_array($query)){
				if('1'==$pms['new']){
					$newpms++;
				}
				$totalpms++;
			}
		}
		return array($newpms,$totalpms);
	}

	function adv_filter($advertisement){
		$advlist=array();
		if (!is_array($advertisement)){return $advlist;}
		if(('index'!==$this->get[0] || 'default'!==$this->get[1])&&('view_doc'!==$this->get[0] || 'view'!==$this->get[1])&&'admin_'!==substr($this->get[0],0,6)){
			foreach($advertisement as $adv){
				$adv['targets']=explode(';',$adv['targets']);
				if('0'==$adv['type']||'1'==$adv['type']){
					if(in_array('all',$adv['targets'])||('user'==$this->get[0]&&'register'==$this->get[1]&&in_array('register',$adv['targets'])))
						if(($adv['starttime']=='0'||$adv['starttime']<=$this->time)&&($adv['endtime']=='0'||$adv['endtime']>=$this->time))
							$advlist[$adv['type']][]=$adv;
				}
			}
			foreach($advlist as $key=>$adv){
				$advlist[$key]=$adv[array_rand($adv)];
			}
		}
		return $advlist;
	}
	
	function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
		$ckey_length = 4;
		$key = md5($key ? $key : $this->setting['auth_key']);
		$keya = md5(substr($key, 0, 16));
		$keyb = md5(substr($key, 16, 16));
		$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';
		$cryptkey = $keya.md5($keya.$keyc);
		$key_length = strlen($cryptkey);
		$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
		$string_length = strlen($string);
		$result = '';
		$box = range(0, 255);
		$rndkey = array();
		for($i = 0; $i <= 255; $i++) {
			$rndkey[$i] = ord($cryptkey[$i % $key_length]);
		}
		for($j = $i = 0; $i < 256; $i++) {
			$j = ($j + $box[$i] + $rndkey[$i]) % 256;
			$tmp = $box[$i];
			$box[$i] = $box[$j];
			$box[$j] = $tmp;
		}
		for($a = $j = $i = 0; $i < $string_length; $i++) {
			$a = ($a + 1) % 256;
			$j = ($j + $box[$a]) % 256;
			$tmp = $box[$a];
			$box[$a] = $box[$j];
			$box[$j] = $tmp;
			$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
		}
		if($operation == 'DECODE') {
			if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
				return substr($result, 26);
			} else {
				return '';
			}
		} else {
			return $keyc.str_replace('=', '', base64_encode($result));
		}
	}	
	
	function multi($num, $perpage, $curpage, $mpurl, $maxpages = 0, $page = 10, $autogoto = TRUE, $simple = FALSE) {
		global $maxpage;
		$multipage = '';
		$seo_prefix=$this->setting['seo_prefix'];
		$seo_suffix=$this->setting['seo_suffix'];
		$mpurl = $seo_prefix.$mpurl.'-';
		$realpages = 1;
		if($num > $perpage) {
			$offset = 2;
			$realpages = @ceil($num / $perpage);
			$pages = $maxpages && $maxpages < $realpages ? $maxpages : $realpages;

			if($page > $pages) {
				$from = 1;
				$to = $pages;
			} else {
				$from = $curpage - $offset;
				$to = $from + $page - 1;
				if($from < 1) {
					$to = $curpage + 1 - $from;
					$from = 1;
					if($to - $from < $page) {
						$to = $page;
					}
				} elseif($to > $pages) {
					$from = $pages - $page + 1;
					$to = $pages;
				}
			}
			$multipage = ($curpage - $offset > 1 && $pages > $page ? '<a href="'.$mpurl.'1"'.$seo_suffix.' class="mar-r8">1 ...</a>' : '').
				($curpage > 1 && !$simple ? '<a href="'.$mpurl.($curpage - 1).$seo_suffix.'" class="mar-r8">&lsaquo;&lsaquo;</a>' : '');
			for($i = $from; $i <= $to; $i++) {
				$multipage .= $i == $curpage ? '<span class="bor_no">'.$i.'</span>' :'<a href="'.$mpurl.$i.$seo_suffix.'" class="mar-r8">'.$i.'</a>';
			}

			$multipage .= ($curpage < $pages && !$simple ? '<a href="'.$mpurl.($curpage + 1).$seo_suffix.'" class="mar-r8">&rsaquo;&rsaquo;</a>' : '').
				($to < $pages ? '<a href="'.$mpurl.$pages.$seo_suffix.'" class="mar-r8">... '.$realpages.'</a>' : '').
				(!$simple && $pages > $page && !$ajaxtarget ? '<kbd><input type="text" name="custompage" size="3" onkeydown="if(event.keyCode==13) {window.location=\''.$mpurl.'\'+this.value+\''.$seo_suffix.'\'; return false;}" /></kbd>' : '');

			$multipage = $multipage ? (!$simple ? '<span class="bor_no">&nbsp;'.$this->view->lang['commonTotal'].$num.$this->view->lang['commonTotalNum'].'&nbsp;</span>' : '').$multipage : '';
		}
		$maxpage = $realpages;
		return $multipage;
	}

}
?>