<?php

!defined('IN_HDWIKI') && exit('Access Denied');

class categorymodel {

	var $db;
	var $base;

	function categorymodel(&$base) {
		$this->base = $base;
		$this->db = $base->db;
	}
	
	function get_category($cid) {
		$categorylist=$this->get_category_cache();
		foreach($categorylist as $category){
			if($cid==$category['cid']){
				return $category;
			}
		}
	}
 
	function get_subcate($pid) {
		$subcategory = array();
		$query=$this->db->query("SELECT * FROM ".DB_TABLEPRE."category WHERE pid='$pid' ORDER BY displayorder ASC");
		while($category=$this->db->fetch_array($query)){
			$subcategory[]=$category;
		}
		return $subcategory;
	}
 
	function get_all_subcate($pid,$allcategory) {
		$sublist='';
		foreach($allcategory as $category){
			if($pid==$category['pid']){
				$sublist .=",".$category['cid'];
				$sublist .= $this->get_all_subcate($category['cid'], $allcategory);
			}
		}
		return $sublist;
	}
	

	function get_all_category() {
		$categorylist=array();
		$query=$this->db->query("SELECT * FROM ".DB_TABLEPRE."category ORDER BY displayorder ASC");
		while($category=$this->db->fetch_array($query)){
			$categorylist[]=$category;
		}
		return $categorylist;
	}
	

	function get_category_cache() {
		$categorylist=$this->base->cache->getcache('category',$this->base->setting['index_cache_time']);
		if( !is_array($categorylist) ){
			$categorylist=$_ENV['category']->get_all_category(); 
			$this->base->cache->writecache('category',$categorylist);
		}
		return $categorylist;
	}
	

	function get_site_category($pid,$categorylist){
		$sitecategory=array();
		foreach($categorylist as $i => $category){
			if($pid==$category['pid']){
				$parentid=$category['cid'];
				$sitecategory[$i]['parent']=$category;
				foreach($categorylist as $j => $subcategory){
					if($parentid==$subcategory['pid']){
						$sitecategory[$i]['child'][]=$subcategory;
					}
				}
			}
		}
		return $sitecategory;
	}
	
	function update_category_docs($cid,$docsnum=1){
		$category=$this->db->fetch_first("SELECT docs FROM ".DB_TABLEPRE."category WHERE cid='$cid' ");
		$docsnum=($category['docs']+$docsnum > 0)?$category['docs']+$docsnum:0;
		$this->db->query("UPDATE ".DB_TABLEPRE."category SET docs=$docsnum WHERE cid='$cid' ");
	}
	
	
	function get_child_tree($allcategory,$pid,$depth=1){
		$childtree='';
		foreach($allcategory as $category){
			if($pid==$category['pid']){
				$childtree .= "<option value=\"{$category['cid']}\">";
				$depthstr=str_repeat("--", $depth);
				$childtree .= $depth ? "&nbsp;&nbsp;|{$depthstr}&nbsp;{$category['name']}</option>" :"{$category['name']}</option>";
				$childtree .= $this->get_child_tree($allcategory, $category['cid'],$depth+1);
			}
		}
		return $childtree;
	}
	function get_child_string($allcategory,$pid,$depth=1){
		$childstring='';
		foreach($allcategory as $category){
			if($pid==$category['pid']){
				$childstring .= ','.$category['cid'];
				$childstring .= $this->get_child_string($allcategory, $category['cid'],$depth+1);
			}
		}
		return $childstring;
	}
	
	function get_categrory_tree($allcategory){
		$categrorytree='';
		$total=count($allcategory);
		for($i=0;$i<$total;$i++){
			if($allcategory[$i]['pid']==0){
				$categrorytree .= "<option value=\"{$allcategory[$i]['cid']}\">{$allcategory[$i]['name']}</option>";
				$categrorytree .=$this->get_child_tree($allcategory,$allcategory[$i]['cid'],1);
			}
		}
		return $categrorytree;
	}
	

	function add_category($pid,$name,$image,$discrib){		
		$cid = $this->db->result_first("SELECT cid FROM `".DB_TABLEPRE."category` WHERE pid='{$pid}' AND name='$name'");
		if( ! $cid){
			$pcat = $this->get_category($pid);
			$this->db->query("INSERT INTO `".DB_TABLEPRE."category` (`pid`,`name`,`image`,`description`) VALUES ('{$pid}','{$name}','{$image}','{$discrib}')");			
			$cid = $this->db->insert_id();
			$path = unserialize($pcat['navigation']);
			$path[] = array('cid'=>$cid,'name'=>$name);
			$navigation = addslashes(serialize($path));
			$this->db->query("UPDATE `".DB_TABLEPRE."category` SET navigation = '{$navigation}' WHERE cid = '{$cid}'");
			return true;			
		}else{
			return false;
		}		
	}
	
 
	function order_category($cid,$order){
		$this->db->query("UPDATE `".DB_TABLEPRE."category` SET displayorder = '{$order}' WHERE cid = '{$cid}'");
	}
	

	function edit_category($cid,$pid,$name,$ico,$discrib){		
		$this->db->query("UPDATE `".DB_TABLEPRE."category` SET pid = '{$pid}',image = '{$ico}', name = '{$name}', description = '{$discrib}' WHERE cid = '{$cid}'");		
		$allcat = $this->get_all_category();
		$child =$cid.$this->get_child_string($allcat,$cid);
		$query = $this->db->query("SELECT * FROM `".DB_TABLEPRE."category` WHERE cid IN ({$child})");
		while($category = $this->db->fetch_array($query)){
			$pcategory = $this->get_category($category['pid']);
			$navigation = unserialize($pcategory['navigation']);
			$navigation[] = array('cid'=>$category['cid'],'name'=>$category['name']);
			$navigation = addslashes(serialize($navigation));
			$this->db->query("UPDATE `".DB_TABLEPRE."category` SET navigation = '{$navigation}' WHERE cid = '{$category['cid']}'");
		}
	}
	

	function remove_category($cid){
		$allcategory = $this->get_all_category();
		$cidlist = $this->get_child_string($allcategory,$cid).$cid;
		$this->db->query("DELETE FROM `".DB_TABLEPRE."category` WHERE cid IN ({$cidlist})");
		$this->db->query("DELETE FROM `".DB_TABLEPRE."doc` WHERE cid IN ({$cidlist})");
		$this->db->query("DELETE FROM `".DB_TABLEPRE."edition` WHERE cid IN ({$cidlist})");
	}
	

	function merge_category($sourceid,$objectid){
		$allcat = $this->get_all_category();
		$child =$objectid.$this->get_child_string($allcat,$objectid);
		$childarray = explode(',',$child);
		if(in_array($sourceid,$childarray))return false;
		else{
			$s = $this->get_category($sourceid);		
			$j = $this->get_subcate($objectid);
			if(is_array($j)){
				foreach($j as $p){
					$path = unserialize($s['navigation']);
					$path[] = array('cid'=>$p['cid'],'name'=>$p['name']);
					$tpath = addslashes(serialize($path));
					unset($path);
					$this->db->query("UPDATE `".DB_TABLEPRE."category` SET pid = '{$sourceid}',navigation = '{$tpath}' WHERE cid = '{$p['cid']}'");
				}
			}
			$this->db->query("DELETE FROM `".DB_TABLEPRE."category` WHERE cid = '{$objectid}'");				
			$query = $this->db->query("SELECT * FROM `".DB_TABLEPRE."category` WHERE cid IN ({$child})");
			while($r = $this->db->fetch_array($query)){
				$t = $this->get_category($r['pid']);
				$path = NULL;
				$path = unserialize($t['navigation']);
				$path[] = array('cid'=>$r['cid'],'name'=>$r['name']);
				$path = addslashes(serialize($path));
				$this->db->query("UPDATE `".DB_TABLEPRE."category` SET navigation = '{$path}' WHERE cid = '{$r['cid']}'");
			}
			$this->db->query("UPDATE `".DB_TABLEPRE."doc` SET cid = '{$sourceid}' WHERE cid = '{$objectid}'");
			return true;
		}
	}
}


?>