<?php
class Cache
 {
  #const CLEAR_INCLUDE_PAGE = true;
  public $doCaching = true;
  public $autoClear = true;
  public $cacheId = false;
  private $_cacheDir;
  private $_settings;
   
  public function __construct($cacheDir, $settings)
   {
    $this->_cacheDir = $cacheDir;
    $this->_settings = $settings;
   }
  
  public function createChacheFile($content)
   {
    if($this->cacheId && $this->doCaching)
     {
      $cacheFile = $this->_cacheDir . str_replace('/','%',$this->cacheId).'.cache';
      if(!file_exists($cacheFile))
       {
        $content = str_replace('<?xml','<?php echo \'<?xml\'; ?>', $content);
        $fp = @fopen($cacheFile, 'w');
        @flock($fp, 2);
        @fwrite($fp, $content);
        @flock($fp, 3);
        @fclose($fp);
       }
     }  
   
   if(!file_exists($this->_cacheDir.'settings.php')) 
    {
     $this->_createCacheSettingsFile();
    }
   }
   
  private function _createCacheSettingsFile()
   {
    $content  = "<?php\n";
    $content .= '$settings[\'session_prefix\'] = \''.$this->_settings['session_prefix'].'\';'."\n";
    $content .= '$settings[\'index_page\'] = \''.$this->_settings['index_page'].'\';'."\n";
    #$content .= '$settings[\'caching\'] = '.$this->_settings['caching'].';'."\n";
    $content .= '?'.'>';
    $fp = @fopen($this->_cacheDir.'settings.php', 'w');
    @flock($fp, 2);
    @fwrite($fp, $content);
    @flock($fp, 3);
    @fclose($fp);
   }   

  public function clear($page=false)
   {
    if(!$page)
     {
      // delete all cache files (settings.php and *.cache):
      foreach(glob($this->_cacheDir.'{settings.php,*.cache}', GLOB_BRACE) as $cacheFile) 
       {
        @unlink($cacheFile);
       }    
     }
    else
     {
      // delete cache files of a specifid page:
      $page = str_replace('/','%', strtolower($page));
      // select page.cache and page,*.cahe
      foreach(glob($this->_cacheDir.'{'.$page.'.cache,'.$page.'\,*.cache}', GLOB_BRACE) as $cacheFile) 
       {
        @unlink($cacheFile);
       }
     }
   }

  public function clearPhoto($id)
   {
    // select *,photo,[id].cache and *,photo,[id],*.cache
    foreach(glob($this->_cacheDir.'{*\,'.IMAGE_IDENTIFIER.'\,'.$id.'.cache,*\,'.IMAGE_IDENTIFIER.'\,'.$id.'\,*.cache}', GLOB_BRACE) as $cacheFile) 
     {
      @unlink($cacheFile);
     }
   }
 
  function clearRelated($page)
   {
    $dbr = Database::$content->prepare("SELECT include_page FROM ".Database::$db_settings['pages_table']." WHERE lower(page)=lower(:page) LIMIT 1");
    $dbr->bindParam(':page', $page, PDO::PARAM_STR);
    $dbr->execute();
    $data = $dbr->fetch();
    if(isset($data['include_page']))
     {
      $dbr2 = Database::$content->prepare("SELECT page, type FROM ".Database::$db_settings['pages_table']." WHERE id=:id LIMIT 1");
      $dbr2->bindParam(':id', $data['include_page'], PDO::PARAM_INT);
      $dbr2->execute();
      $data2 = $dbr2->fetch();
      if(isset($data2['page']))
       {
        #if($data2['type']=='news')
        # {
          $this->clear($data2['page']);
        # }
       }
     }
    } 
 }
?>
