<?php
/**
 * Mail class to send e-mails
 *
 * @author Mark Alexander Hoschek <alex at mylittlehomepage dot net>
 * @copyright 2009 Mark Alexander Hoschek
 */

class Mail 
 {
  private $charset = 'utf-8';
  private $mail_header_separator = "\r\n"; // try to use "\n" if messages are not sent (see http://php.net/manual/en/function.mail.php)
  private $sender_name = false;
  private $mail_parameter = false;
  
  /**
   * Sets charset of the e-mail.
   *
   * @param string $charset
   */
  public function set_charset($charset)
   {
    $this->charset = $charset;
   }

  /**
   * Sets the additional mail parameter used as 5th parameter of the mail() function.
   *
   * @param string $mail_parameter
   */
  public function set_mail_parameter($mail_parameter)
   {
    $this->mail_parameter = $mail_parameter;
   }

  /**
   * Sets the sender name.
   *
   * @param string $sender_name
   */
  public function set_sender_name($sender_name)
   {
    $this->sender_name = $sender_name;
   }

  /**
   * Checks whether an e-mail address is (syntactically) valid or not.
   *
   * @param string $email
   * @return bool
   */
  public function is_valid_email($email)
   {
    if(preg_match("/^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/", $email))
     {
      return true;
     }
    return false;
   }
  
  /**
  * sends an e-mail
  *
  * @param string $to
  * @param string $subject
  * @param string $message
  * @param string $headers  
  * @return bool 
  */ 
  public function send($to, $from, $subject, $message)
   {    
    #$message = wordwrap($message, 70);  
    if($this->sender_name)
     {
      $headers = "From: " . mb_encode_mimeheader($this->sender_name, $this->charset, "Q")." <".$from.">". $mail_header_separator;
     }
    else
     {
      $headers  = "From: " . $from . $this->mail_header_separator;
      #$headers = "From: " . $settings['forum_email'] . $this->mail_header_separator;
      #$headers .= "Reply-to: " . $from . $this->mail_header_separator;
     }
 
    $headers .= "X-Sender-IP: ".$_SERVER["REMOTE_ADDR"] . $this->mail_header_separator;
    #$headers .= "X-Mailer: " . BASE_URL . $this->mail_header_separator;
    $headers .= "Content-Type: text/plain; charset=" . $this->charset . $this->mail_header_separator;
    $headers .= "Content-transfer-encoding: 8bit" . $this->mail_header_separator;

    $subject = mb_encode_mimeheader($subject, $this->charset, "Q");
    
    if($this->mail_parameter)
     {
      if(@mail($to, $subject, $message, $headers, $this->mail_parameter))
       {
        return true;
       }
      else
       {
        return false;
       }
     } 
    else
     {
      if(@mail($to, $subject, $message, $headers))
       {
        return true;
       }
      else
       {
        return false;
       }   
     }
   }
 }
?>
