<?php
if(!defined('IN_INDEX')) exit;

// menus:
$template->assign('menus', get_menus());

// global content blocks:
$template->assign('gcb', get_global_content_blocks());

// content:
if(empty($data)) // might already be set if error page was loaded
 {
  if($data=get_content(PAGE))
   {
    // count views:
    if($settings['count_views']==1)
     {
      $dbr = Database::$content->prepare("UPDATE ".Database::$db_settings['pages_table']." SET views=views+1 WHERE id=:id");
      $dbr->bindParam(':id', $data['id'], PDO::PARAM_INT);
      $dbr->execute();
     }   
   }
  else
   {
    $no_cache = true;
    if($data=get_content($settings['error_page']))
     {
      header($_SERVER['SERVER_PROTOCOL'] . " 404 Not Found");
      header("Status: 404 Not Found");
     }
    else
     {
      raise_error('404');
     } 
   }
 }
   
if($data['language_file']=='') $language_file = $settings['default_page_language_file'];
else $language_file = $data['language_file'];

#require('./cms/includes/classes/Localization.class.php');
#$loc = new Localization('./cms/lang/'.$language_file);
#$localization = Localization::getInstance(BASE_PATH.'cms/lang/'.$language_file);
$localization = new Localization(BASE_PATH.'cms/lang/'.$language_file);

mb_internal_encoding(Localization::$lang['charset']);

#require('./cms/lang/'.$language_file);
#$template->set_lang($lang);

#$template->config_load($language_file);
#$lang = $template->get_config_vars();
setlocale(LC_ALL, Localization::$lang['locale']);
#$template->assign('config_file', $language_file);
define('CHARSET', Localization::$lang['charset']);
#define('TIME_FORMAT', Localization::$lang['time_format']);
#define('TIME_FORMAT_FULL', Localization::$lang['time_format_full']);

// breadcrumbs:
$template->assign('breadcrumbs', get_breadcrumbs($data['breadcrumbs']));
  
$page = $data['page'];

$content = $data['content'];
if($settings['content_auto_link']==1) $content = make_link($content);
if($settings['content_smilies']==1) $content = smilies($content);
if($data['content_formatting']==1) $content = auto_html($content);

if($settings['content_function']==1) $content = preg_replace_callback("#\[function:(.+?)\]#is", "content_function", $content);
$content = preg_replace_callback("#\[image:(.+?)\]#is", "create_image", $content);
$content = preg_replace_callback("#\[thumbnail:(.+?)\]#is", "create_thumbnail", $content);
$content = preg_replace_callback("#\[gallery:(.+?)\]#is", "create_gallery", $content);
$content = preg_replace('/\[\[([^|\]]+?)(?:\|([^\]]+))?\]\]/e', "'<a href=\"\$1\">'.(('\$2')?'\$2':'\$1').'</a>'", $content);
   
$sidebar_1 = $data['sidebar_1'];
if($settings['content_auto_link']==1) $sidebar_1 = make_link($sidebar_1);
if($settings['content_smilies']==1) $sidebar_1 = smilies($sidebar_1);
if($data['sidebar_1_formatting']==1) $sidebar_1 = auto_html($sidebar_1);
if($sidebar_1!='') $sidebar_1 = preg_replace('/\[\[([^|\]]+?)(?:\|([^\]]+))?\]\]/e', "'<a href=\"\$1\">'.(('\$2')?'\$2':'\$1').'</a>'", $sidebar_1);
  
$sidebar_2 = $data['sidebar_2'];
if($settings['content_auto_link']==1) $sidebar_2 = make_link($sidebar_2);
if($settings['content_smilies']==1) $sidebar_2 = smilies($sidebar_2);
if($data['sidebar_2_formatting']==1) $sidebar_2 = auto_html($sidebar_2);
if($sidebar_2!='') $sidebar_2 = preg_replace('/\[\[([^|\]]+?)(?:\|([^\]]+))?\]\]/e', "'<a href=\"\$1\">'.(('\$2')?'\$2':'\$1').'</a>'", $sidebar_2);
  
$sidebar_3 = $data['sidebar_3'];
if($settings['content_auto_link']==1) $sidebar_3 = make_link($sidebar_3);
if($settings['content_smilies']==1) $sidebar_3 = smilies($sidebar_3);
if($data['sidebar_3_formatting']==1) $sidebar_3 = auto_html($sidebar_3);
if($sidebar_3!='') $sidebar_3 = preg_replace('/\[\[([^|\]]+?)(?:\|([^\]]+))?\]\]/e', "'<a href=\"\$1\">'.(('\$2')?'\$2':'\$1').'</a>'", $sidebar_3);
  
$sections_array = explode(',',$data['sections']);
foreach($sections_array as $section)
 {
  $sections[] = $section;
 }  
$template->assign('section', $sections);

$custom_values_array = explode(',',$data['custom_values']);
foreach($custom_values_array as $custom_value)
 {
  $custom_values[] = $custom_value;
 }  
$template->assign('custom_value', $custom_values);
      
$page_id = $data['id'];
  
$template->assign('id', $data['id']);
$template->assign('page', $page);
$template->assign('settings', $settings);
$template->assign('type', $data['type']);
$template->assign('title', $data['title']);
$template->assign('page_title', $data['page_title']);
$template->assign('keywords', $data['keywords']);
$template->assign('description', $data['description']);
$template->assign('page_info', $data['page_info']);
$template->assign('headline', $data['headline']);
#$template->assign('headline', $data['headline']);
$template->assign('content', $content);
$template->assign('sidebar_1', $sidebar_1);
$template->assign('sidebar_2', $sidebar_2);
$template->assign('sidebar_3', $sidebar_3);
$template->assign('menu_1', $data['menu_1']);
$template->assign('menu_2', $data['menu_2']);
$template->assign('menu_3', $data['menu_3']);
$template->assign('gcb_1', intval($data['gcb_1']));
$template->assign('gcb_2', intval($data['gcb_2']));
$template->assign('gcb_3', intval($data['gcb_3']));

if(isset($_SESSION[$settings['session_prefix'].'user_id']) && is_authorized_to_edit($_SESSION[$settings['session_prefix'].'user_id'],$_SESSION[$settings['session_prefix'].'user_type'],$data['author'],$data['edit_permission'],$data['edit_permission_general'])) 
 {
  $template->assign('authorized_to_edit', true);
 }
else
 {
  $template->assign('authorized_to_edit', false);
 }

$template->assign('timestamp', $data['time']);
  
#$template->assign('created', format_time($loc->lang['time_format'], $data['time']));
#$template->assign('last_modified', format_time($loc->lang['time_format'], $data['last_modified']));

if($data['display_time']==1) 
 {
  $template->assign('display_time', true);
  $localization->replacePlaceholder('time', $data['time'], 'page_time', Localization::FORMAT_TIME);
 }
else
 {
  $template->assign('display_time', false);
 }

$localization->replacePlaceholder('last_modified', $data['last_modified'], 'page_last_modified', Localization::FORMAT_TIME);
$localization->replacePlaceholder('created', $data['time'], 'page_last_modified', Localization::FORMAT_TIME);

  
#$template->assign('lang', $lang['lang']);

$content_type = $data['content_type'] ? $data['content_type'] : 'text/html';
#$charset = $data['charset'] ? $data['charset'] : $loc->lang['charset'];
$template_file = $data['template'];

if($data['type']!='default')
 {
  include(BASE_PATH.'cms/config/page_types.conf.php');
  if(isset($page_types[$data['type']]['page_type']))
   {
    include(BASE_PATH.'cms/includes/page_types/'.$page_types[$data['type']]['page_type']);
   }
 }
else
 {
  if(isset($cache) && empty($no_cache))
   {
    $cache->cacheId = PAGE;
   }
 }
?>
