<?php
if(!defined('IN_INDEX')) exit;

$media_dir = str_replace('/','',MEDIA_DIR);
$file_dir = 'files';

$template->assign('media_dir', $media_dir);
$template->assign('file_dir', $file_dir);

if(isset($_SESSION[$settings['session_prefix'].'user_id']))
 {
  $directory = isset($_REQUEST['directory']) && $_REQUEST['directory']==$media_dir ? $media_dir : $file_dir;
  #if(isset($_REQUEST['dir'])) $dir = $_REQUEST['dir'];
  #if(empty($dir)) $dir = 'files';
  #if($dir!='files' && $dir!='images') $dir='files';
  $template->assign('directory', $directory);

 // delete:
 if(isset($_REQUEST['delete']))
  {
   if(isset($_REQUEST['confirmed']))
    {
     @chmod(BASE_PATH.$directory.'/'.$_REQUEST['delete'], 0777);
     if(!@unlink(BASE_PATH.$directory.'/'.$_REQUEST['delete'])) $errors[] = Localization::$lang['delete_file_error'];
     header('Location: '.BASE_URL.ADMIN_DIR.'index.php?mode=filemanager&directory='.$directory);
     exit;
    }
   else
    {
     $template->assign('file', htmlspecialchars($_REQUEST['delete']));
     $action = 'delete';
    }
  }

 if(isset($_POST['upload_file_submit']))
  {
   $file_name = trim($_POST['file_name']);
   $compression = intval($_POST['compression']);
   $upload_mode = intval($_POST['upload_mode']);
   $resize = intval($_POST['resize']);
   $resize_xy = $_POST['resize_xy'];
   #if(empty($_FILES['probe']) || $_FILES['probe']['size'] == 0 || $_FILES['probe']['error']) $errors[] = Localization::$lang['error_no_file'];
   if($compression < 1 || $compression > 100) $errors[] = 'invalid_compression_value';

   if(empty($errors))
    {
     // filename already exists?
     if($file_name=='') $file_name = basename($_FILES['probe']['name']);
     if(file_exists(BASE_PATH.$directory.'/'.$file_name) && empty($_POST['overwrite_file'])) 
      {
       $file_name = '';
       $errors[] = 'upload_file_exists';
      }
    }
   if(empty($errors))
    {
     $size=getimagesize($_FILES['probe']['tmp_name']);
     if(is_array($size) && ($size[2] == 1 || $size[2] == 2 || $size[2] == 3) && $upload_mode==2)
      {
       // its an image and it should be manipulated
       $width=$size[0];
       $height=$size[1];
       if($resize_xy=='x')
         {
          $x = $resize;
          $y = intval($height*$x/$width);
         }
       else
         {
          $y = $resize;
          $x = intval($width*$y/$height);
         }
       if($size[2]==1) // GIF
         {
          $current_image=ImageCreateFromGIF($_FILES['probe']['tmp_name']);
          $new_image=ImageCreate($x,$y);
          ImageCopyResized($new_image,$current_image,0,0,0,0,$x,$y,$width,$height);
          if(!@ImageGIF($new_image, BASE_PATH.$directory.'/'.$file_name)) $errors[] = 'upload_error';
         }
       elseif($size[2]==2) // JPG
         {
          $current_image=ImageCreateFromJPEG($_FILES['probe']['tmp_name']);
          $new_image=imagecreatetruecolor($x,$y);
          ImageCopyResized($new_image,$current_image,0,0,0,0,$x,$y,$width,$height);
          if(!@ImageJPEG($new_image, BASE_PATH.$directory.'/'.$file_name, $compression)) $errors[] = 'upload_error';
         }
       elseif($size[2]==3) // PNG
         {
          $current_image=ImageCreateFromPNG($_FILES['probe']['tmp_name']);
          $new_image=imagecreatetruecolor($x,$y);
          ImageCopyResized($new_image,$current_image,0,0,0,0,$x,$y,$width,$height);
          if(!@ImagePNG($new_image, BASE_PATH.$directory.'/'.$file_name)) $errors[] = 'upload_error';
         }
      }
     else
      {
       @move_uploaded_file($_FILES['probe']['tmp_name'], BASE_PATH.$directory.'/'.$file_name) or $errors[] = 'upload_error';
      }
    }
   if(empty($errors))
    {
     @chmod(BASE_PATH.$directory.'/'.$file_name, 0644);
     // save upload defaults:
     Database::$content->beginTransaction();
     $dbr = Database::$content->prepare("UPDATE ".Database::$db_settings['settings_table']." SET value=:value WHERE name=:name");
     $dbr->bindValue(':name', 'resize', PDO::PARAM_STR);
     $dbr->bindParam(':value', $resize, PDO::PARAM_STR);
     $dbr->execute();
     $dbr->bindValue(':name', 'resize_xy', PDO::PARAM_STR);
     $dbr->bindParam(':value', $resize_xy, PDO::PARAM_STR);
     $dbr->execute();
     $dbr->bindValue(':name', 'compression', PDO::PARAM_STR);
     $dbr->bindParam(':value', $compression, PDO::PARAM_STR);
     $dbr->execute();
     Database::$content->commit();     
     header('Location: '.BASE_URL.ADMIN_DIR.'index.php?mode=filemanager&directory='.$directory);
     exit();
    }
   else
    {
     $template->assign('errors', $errors);
     $action='upload';
    }
  }

  if(isset($_REQUEST['action'])) $action = $_REQUEST['action'];
  if(empty($action)) $action = 'main';

  switch($action)
   {
    case 'main':
     $fp=opendir(BASE_PATH.$directory.'/');
     while($file = readdir($fp))
      {
       #if($file!='.' && $file!='..')
       if(is_file(BASE_PATH.$directory.'/'.$file))
        {
         $file_array[] = $file;
        }
      }
     closedir($fp);
    
     if(isset($file_array))
      {
       natcasesort($file_array);
      
       if(function_exists('mime_content_type'))
        {
         $mime_content_type=true;
         $template->assign('mime_content_type', $mime_content_type);
        }
      
       $i=0;
       foreach($file_array as $file)
        {
         $files[$i]['filename'] = htmlspecialchars($file);
         $files[$i]['size'] = number_format(filesize(BASE_PATH.$directory.'/'.$file)/1000,1,",",".");
         $files[$i]['last_modified'] = strftime(Localization::$lang['time_format'], filectime(BASE_PATH.$directory.'/'.$file));
         if(isset($mime_content_type)) 
          { 
           $files[$i]['mime_content_type'] = mime_content_type(BASE_PATH.$directory.'/'.$file);
          }
         ++$i;
        }
       if(isset($files))
        {
         $template->assign('files', $files); 
        }
      }
     $template->assign('subtitle', Localization::$lang['filemanager']);
     $template->assign('subtemplate', 'filemanager.inc.tpl');
    break;
    case 'upload';
     $template->assign('subtitle', Localization::$lang['upload_file']);
     $template->assign('subtemplate', 'filemanager_upload.inc.tpl');

     break;
    case 'delete':
     $template->assign('subtitle', Localization::$lang['delete_file']);
     $template->assign('subtemplate', 'filemanager_delete.inc.tpl');
     break;
   }
 }
