<?php
if(!defined('IN_INDEX')) exit;

$comment = new Comment(PAGE, $data['id']);

// settings:
$comment->comments_per_page = $settings['comments_per_page'];
$comment->comment_order = $settings['comment_order'];
$comment->name_maxlength = $settings['name_maxlength'];
$comment->email_hp_maxlength = $settings['email_hp_maxlength'];
$comment->word_maxlength = $settings['word_maxlength'];
$comment->comment_maxlength = $settings['comment_maxlength'];
$comment->prevent_repeated_posts_minutes = $settings['prevent_repeated_posts_minutes'];
$comment->akismet_key = $settings['akismet_key'];
$comment->akismet_entry_check = $settings['akismet_entry_check'];
$comment->remove_blank_lines = $settings['comment_remove_blank_lines'];
$comment->auto_link = $settings['comment_auto_link'];
$comment->smilies = $settings['comment_smilies'];

if(isset($_SESSION[$settings['session_prefix'].'user_id']))
 {
  $comment->set_admin_mode();
 }

$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'main';

if(isset($_POST['preview']))
 {
  if($preview = $comment->preview())
   {
    $template->assign('preview', $preview);
   }
 }
elseif(isset($_POST['save']))
 {
  if($comment->form_session==false)
   {
    if($preview = $comment->preview())
     {
      $template->assign('preview', $preview);
     }
   }
  elseif($comment->save())
   {
    if(isset($cache))
     {
      $cache->clear(PAGE);
      $cache->clearRelated(PAGE);
     }    
    header('Location: '.BASE_URL.PAGE.'#comments');
    exit;
   }
 }
elseif(isset($_SESSION[$settings['session_prefix'].'user_id']) && isset($_GET['get_2']) && $_GET['get_2']=='edit' && isset($_GET['get_3']))
 {
  $template->assign('edit_data', $comment->get_edit_data($_GET['get_3']));
  $action = 'edit';
 }
elseif(isset($_POST['edit_save']))
 {
  $comment->edit_save();
  if(isset($cache))
   {
    $cache->clear(PAGE);
   }      
  header('Location: '.BASE_URL.PAGE.','.$comment->current_page.'#comments');
 }
elseif(isset($_SESSION[$settings['session_prefix'].'user_id']) && isset($_GET['get_2']) && $_GET['get_2']=='delete' && isset($_GET['get_3']))
 {
  $comment->delete($_GET['get_3']);
  if(isset($cache))
   {
    $cache->clear(PAGE);
    $cache->clearRelated(PAGE);
   }
  header('Location: '.BASE_URL.PAGE.','.$comment->current_page.'#comments');
 }

$comments = $comment->get_comments();
 
$template->assign('comments', $comments);
$template->assign('pagination', pagination($comment->total_pages,$comment->current_page));
$template->assign('current_page', $comment->current_page);
$template->assign('errors', $comment->errors);
$template->assign('form_values', $comment->form_values);
$template->assign('form_session_data', $comment->form_session_data);
$template->assign('form_session', $comment->form_session);

$template->assign('subtemplate', 'comments.inc.tpl');
 
if(isset($cache))
 {
  if($comment->current_page > 1)
   {
    $cache->cacheId = PAGE . ',' . $comment->current_page;
   }
  else
   {
    $cache->cacheId = PAGE;
   }
 }  
?>
