<?php
$dbr = Database::$content->prepare("SELECT COUNT(*) FROM ".Database::$db_settings['notes_table']." WHERE note_section=:note_section");
$dbr->bindParam(':note_section', $data['type_addition'], PDO::PARAM_STR);
$dbr->execute();     
$total_items = $dbr->fetchColumn();

$total_pages = ceil($total_items / $settings['notes_per_page']);

if(isset($_GET['get_1'])) $current_page = intval($_GET['get_1']); else $current_page = 1;
if($current_page<1) $current_page = 1;
if($current_page>$total_pages) $current_page = $total_pages;

$dbr = Database::$content->prepare("SELECT id, time, title, text, text_formatting, link, linkname FROM ".Database::$db_settings['notes_table']." WHERE note_section=:note_section ORDER BY sequence ASC LIMIT ".(($current_page-1)*$settings['notes_per_page']).", ".$settings['notes_per_page']);
$dbr->bindParam(':note_section', $data['type_addition'], PDO::PARAM_STR);
$dbr->execute();
$i=0;
while($notes_data = $dbr->fetch())
 {
  $notes[$i]['id'] = $notes_data['id'];
  $notes[$i]['time'] = $notes_data['time'];
  $notes[$i]['title'] = $notes_data['title'];
  if($notes_data['text_formatting']==1) $notes[$i]['text'] = auto_html($notes_data['text']);
  else $notes[$i]['text'] = $notes_data['text'];
  #$notes[$i]['text'] = format_paragraph($notes_data['text']);
  if(mb_substr($notes_data['link'],0,7) != 'http://' && mb_substr($notes_data['link'],0,8) != 'https://' && mb_substr($notes_data['link'],0,6) != 'ftp://' && mb_substr($notes_data['link'],0,9) != 'gopher://' && mb_substr($notes_data['link'],0,7) != 'news://')
   {
    $notes[$i]['link'] = BASE_URL.$notes_data['link'];
   }
  else
   {
    $notes[$i]['link'] = $notes_data['link'];
   }
  $notes[$i]['linkname'] = $notes_data['linkname'];
  $localization->bindReplacePlaceholder($notes_data['id'], 'time', $notes_data['time'], 'note_time', Localization::FORMAT_TIME);
  $i++;
 }
if(isset($notes))
 {
  $template->assign('notes', $notes);
 }

$localization->replacePlaceholder('current_page', $current_page, 'pagination');
$localization->replacePlaceholder('total_pages', $total_pages, 'pagination');

$template->assign('pagination', pagination($total_pages,$current_page));
$template->assign('subtemplate', 'notes.inc.tpl');

if(isset($cache))
 {
  if($current_page > 1)
   {
    $cache->cacheId = PAGE . ',' . $current_page;
   }
  else
   {
    $cache->cacheId = PAGE;
   }
 }
?>
