<?php
if(!defined('IN_INDEX')) exit;

$current_time = time();

$dbr = Database::$content->prepare("SELECT id, page, title, teaser, teaser_formatting, content, content_formatting, time, last_modified FROM ".Database::$db_settings['pages_table']." WHERE include_rss=:include_rss AND time<=:time AND status!=0 ORDER BY time DESC LIMIT ".$settings['rss_maximum_items']);
$dbr->bindParam(':include_rss', $page_id, PDO::PARAM_INT);
$dbr->bindParam(':time', $current_time, PDO::PARAM_INT);
$dbr->execute();

$i=0;
while($rss_data = $dbr->fetch()) 
 {
  $rss_items[$i]['title'] = htmlspecialchars($rss_data['title']);    

  if($rss_data['teaser']!='')
   {
    if($rss_data['teaser_formatting']==1)
     {
      $rss_items[$i]['content'] = auto_html($rss_data['teaser']);
     }
    else
     {
      $rss_items[$i]['content'] = $rss_data['teaser'];
     }
   }
  else
   {
    if($rss_data['content_formatting']==1)
     {
      $rss_items[$i]['content'] = auto_html($rss_data['content']);
     }
    else
     {
      $rss_items[$i]['content'] = $rss_data['content'];
     }
   }

  $rss_items[$i]['link'] = BASE_URL.$rss_data['page'];
  $rss_items[$i]['pubdate'] = date('r',$rss_data['time']);
  $i++;
 }

if(isset($rss_items))
 {
  $template->assign('rss_items',$rss_items);
 }
 
$content_type = 'text/xml';
$template_file = 'rss.tpl';

if(isset($cache))
 {
  $cache->cacheId = PAGE;
 }
?>
