<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $lang['lang']; ?>" dir="<?php echo $lang['dir']; ?>">
<head>
<title><?php echo $settings['website_title']; if($page_title): ?> - <?php echo $page_title; elseif($title): ?> - <?php echo $title; endif; ?></title>
<meta http-equiv="content-type" content="text/html; charset=<?php echo $lang['charset']; ?>" />
<meta name="robots" content="index, follow" />
<meta name="description" content="<?php if($description) echo $description; else echo $settings['default_description']; ?>" />
<meta name="keywords" content="<?php if($keywords) echo $keywords; else echo $settings['default_keywords']; ?>" />
<meta name="generator" content="phpSQLiteCMS <?php echo $settings['version']; ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>templates/style.css" media="all" />
<!--[if lt IE 7.0]><link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>templates/style_ie.css" media="all" /><![endif]-->
<link rel="alternate" type="application/rss+xml" title="RSS" href="<?php echo BASE_URL; ?>rss" />
<link rel="shortcut icon" href="<?php echo BASE_URL; ?>templates/images/favicon.ico" />
<script src="<?php echo BASE_URL; ?>js/main.js" type="text/javascript"></script>
<?php if($admin): ?>
<script src="<?php echo BASE_URL; ?>js/admin.js" type="text/javascript"></script>
<?php endif; ?>
</head>
<body>
<?php if($admin) include('./templates/admin/subtemplates/admin_menu.inc.tpl'); ?>

<div id="topwrapper">
<div id="top">
<div class="logo"><h1><a href="<?php echo BASE_URL; ?>"><?php echo $settings['website_title']; ?></a></h1></div>
<div class="subtitle"><?php echo $settings['website_subtitle']; ?></div>
</div>
</div>

<?php if($menu_1 && isset($menus[$menu_1])): ?>
<div id="navwrapper">
<div id="nav">
<ul id="navlist">
<?php foreach($menus[$menu_1] as $item): ?><li><a href="<?php echo $item['link']; ?>" title="<?php echo $item['title']; ?>"<?php if($item['accesskey']!=''): ?> accesskey="<?php echo $item['accesskey']; ?>"<?php endif; ?><?php if(!empty($item['section']) && $item['section']==$section[0]): ?> id="current"<?php endif; ?>><?php echo $item['name']; ?></a></li><?php endforeach; ?>
</ul>
</div>
</div>
<?php endif; ?>

<div id="mainwrapper">
<div id="main">
<?php if($sidebar_1): ?><div id="sidebarwrapper"><?php endif; ?>
<div id="content">

<?php if($breadcrumbs): ?>
<p id="breadcrumbs">&bull; <?php foreach($breadcrumbs as $breadcrumb): ?><a href="<?php echo BASE_URL.$breadcrumb['page']; ?>"><?php echo $breadcrumb['title']; ?></a> &raquo; <?php endforeach; ?><?php if($title) echo $title; ?></p>
<?php endif; ?>

<?php if($page_info): ?>
<p id="pageinfo"><?php echo $page_info; ?></p>
<?php endif; ?>

<?php if($display_time): ?>
<p id="time"><?php echo $lang['page_time']; ?></p>
<?php endif; ?>

<?php if($headline): ?>
<h1><?php echo $headline; ?></h1>
<?php endif; ?>

<?php if(empty($hide_content)) echo $content; ?>

<?php if(isset($subtemplate)) include('./templates/subtemplates/'.$subtemplate); ?>

</div>

<?php if($sidebar_1): ?></div><?php endif; ?>

<?php if($sidebar_1): ?>
<div id="sidebar">
<?php echo $sidebar_1; ?>
</div>
<?php endif; ?>
</div>
</div>

<div id="bottomwrapper">
<div id="bottom">
<p class="left"><?php /* echo $settings['website_footnote_1']; */ ?><?php if($type!='news' && $type!='search' && $type!='notes' && $type!='guestbook') echo $lang['page_last_modified']; ?></p>
<p class="right"><?php echo $settings['website_footnote_2']; ?></p>
</div>
</div>

<?php /* this is for the global content blocks demonstration: */ ?>
<?php if($gcb_1 && isset($gcb[$gcb_1])) echo $gcb[$gcb_1]; ?>
<?php if($gcb_2 && isset($gcb[$gcb_2])) echo $gcb[$gcb_2]; ?>
<?php if($gcb_3 && isset($gcb[$gcb_3])) echo $gcb[$gcb_3]; ?>

<div id="poweredby"><a href="http://phpsqlitecms.net/">powered by phpSQLiteCMS</a></div>

</body>
</html>
