<?php
if(!defined('XIHU_DEFINED')) exit('Done');
require 'admin/sources/chklogin.php';

include(BASE_DIR . '/admin/lang/' . LANG_DIR . '/lang_backup.php');

$backupHeader = <<<EOT
<?php die;  ?>
HEADER SIZE:HeaderSize
BACKUP TIME:{BackupTime}
TABLE IN PACKAGE:{Tables}
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>START BACKUP SQL<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\r\n
EOT;

define('BACKUP_HEADER',	$backupHeader);
define('BACKUP_INDEX_FILE_START_LINE',	2);
  
function SQLDumpTable($db, $table)
{
	$dumpStr= "DROP TABLE IF EXISTS $table;\n";
	
	$rslt	= $db->query("SHOW CREATE TABLE $table");
	
	$arr	= $db->fetchArray($rslt);
	
	$dumpStr	.= $arr['Create Table'] . ";\n\n";

	$rslt		= $db->query("SELECT * FROM $table");
	$numfields	= $db->numFields($rslt);
	
	$startTime	= time();
	
	while($row = $db->fetchArray($rslt, MYSQL_NUM))
	{
		$comma = "";
		$dumpStr .= "INSERT INTO $table VALUES(";

		for($i = 0, $cnt = $db->numFields($rslt); $i < $cnt; $i++)
		{
			$dumpStr .= $comma . "'" . $db->escapeString($row[$i]) . "'";
			$comma = " ,";
		}
		
		$dumpStr .= ");\n";
		
		if((time() - $startTime) % 30) Header("Noop-Header: noop");
	}

	return $dumpStr;
}

function splitSql(&$ret, $sql)
{
    $sql          = trim($sql);
    $sql_len      = strlen($sql);
    $char         = '';
    $string_start = '';
    $in_string    = false;
    $time0        = time();

    for($i = 0; $i < $sql_len; ++$i)
    {
        $char = $sql[ $i ];

        if($in_string)
        {
            while(true)
            {
                $i	= strpos($sql, $string_start, $i);

                if(!$i)
                {
                    $ret[]  = $sql;
                    return TRUE;
                }

                else if($string_start == '`' || $sql[ $i-1 ]  != '\\')
                {
                    $string_start      = '';
                    $in_string         = false;
                    break;
                }
                else
                {
                    $j                     = 2;
                    $escaped_backslash     = false;

                    while ($i-$j > 0 && $sql[ $i-$j ]  == '\\')
                    {
                        $escaped_backslash = !$escaped_backslash;
                        $j++;
                    }

                    if($escaped_backslash)
                    {
                        $string_start  = '';
                        $in_string     = false;
                        break;
                    }
                    else
                    {
                        $i++;
                    }
                }
            }
        }
        else if($char == ';')
        {
            $ret[]       = substr($sql, 0, $i);
            $sql        = ltrim(substr($sql, min($i + 1, $sql_len)));
            $sql_len    = strlen($sql);
            if($sql_len)
            {
                $i      = -1;
            }
            else
            {
                return TRUE;
            }
        }
        else if(($char == '"')  || ($char == '\'')  || ($char == '`'))
        {
            $in_string    = TRUE;
            $string_start = $char;
        }
        else if($char == '#'
                  || ($char == ' ' && $i > 1 && $sql[ $i-2 ] . $sql[ $i-1 ]  == '--'))
        {

            $start_of_comment = (($sql[ $i ]  == '#')  ? $i : $i-2);

            $end_of_comment   = (strpos(' ' . $sql, "\012", $i+2))
                                ? strpos(' ' . $sql, "\012", $i+2)
                                : strpos(' ' . $sql, "\015", $i+2);
            if(!$end_of_comment)
            {

                if($start_of_comment > 0)
                {
                    $ret[]     = trim(substr($sql, 0, $start_of_comment));
                }
                return TRUE;
            }
            else
            {
                $sql          = substr($sql, 0, $start_of_comment) . ltrim(substr($sql, $end_of_comment));
                $sql_len      = strlen($sql);
                $i--;
            }
        }

        $time1     = time();

        if($time1 >= $time0 + 30)
        {
            $time0 = $time1;
            header('X-pmaPing: Pong');
        }
    }

    if(!empty($sql) && trim($sql))
    {
        $ret[]  = $sql;
    }

    return true;
}

if(empty($in['event'])){
	$backupList = getBackupList();

	for($i = 0, $cnt = count($backupList); $i < $cnt; $i++)
	{
		$backupList[$i]['strBackupTime']	= Date('Y-m-d H:i', $backupList[$i]['BackupTime']);
		$backupList[$i]['Size']			= getSizeStr($backupList[$i]['BackupSize']);
		$backupList[$i]['FileName']		= md5($backupList[$i]['FileName']);
	}
	
	include template('list_backup.html');
}
else if($in['event'] == 'backup'){
	set_time_limit(0);
			
	$rslt = $db->listTables(DB_NAME);
	
	$ret = array();
	
	while($arr = $db->fetchArray($rslt, FETCH_NUM))
	{
		if($arr[0])
		{
			if(substr($arr[0], 0, strlen(TABLE_PREFIX)) == TABLE_PREFIX)
  				$ret[] = $arr[0];
		}
	}
	
	if(empty($in['postFlag']))
	{
		$DatabaseSpace = getSizeStr($db->getDatabaseSize(TABLE_PREFIX));

		
		$TableList = getOptions($ret);
		
    	include template('input_backup.html');
	}
	else
	{
  		srand((double)microtime() * 1000000);
  		
  		$fileName = BACKUP_DIR .'/'. md5(uniqid(rand())) . '.php';

  		$fp = fopen($fileName, 'w');
  		
  		if(!is_resource($fp))
  		{
  			$this->halt($LANG['LANG_backup_failed']);
  		}
  		
  		$header = BACKUP_HEADER;
  		
  		$header = str_replace('{BackupTime}', sprintf('%010d', time()), $header);
  		$header = str_replace('{Tables}', count($in['Tables']) == count($ret) 
  												? $LANG['LANG_backup_all_tables'] 
  													: implode($in['Tables'], ','), $header);
  													
  		$header	= str_replace('HeaderSize', sprintf('%010d', strlen($header)), $header);
  		
  		fwrite($fp, $header);
  		
  		for($i = 0, $cnt = count($in['Tables']); $i < $cnt; $i++)
  		{
  			fwrite($fp, SQLDumpTable($db, $in['Tables'][$i]));
  		}
  		
  		fclose($fp);
  		
  		$this->showInfo($LANG['LANG_backup_succeed'], SCRIPT_NAME . '?do=backup');
	}
}
else if($in['event'] == 'restore'){
   	    	
	set_time_limit(0);

	$backupList = getBackupList();
	
	for($i = 0, $cnt = Count($backupList); $i < $cnt; $i++)
	{
		if(md5($backupList[$i]['FileName']) == $in['ids'])
		{
			$fp = fopen(BACKUP_DIR . $backupList[$i]['FileName'], 'rb');
			
			fseek($fp, $backupList[$i]['HeaderSize'], SEEK_CUR);
			
			$buf = fread($fp, filesize(BACKUP_DIR . $backupList[$i]['FileName']));
			
			fclose($fp);

			splitSql($queries, $buf);
			
			for($j = 0, $j_cnt = count($queries); $j < $j_cnt; $j++)
			{
				$db->query($queries[$j]);
			}

		  	$this->showInfo(sprintf($LANG['LANG_backup_restore_succ'], date('Y-m-d H:i:s', $backupList[$i]['BackupTime'])), $CURRENT_MODULE, 5);
			break;
		}
	}
}
else if($in['event'] == 'download'){
    	
	$backupList = getBackupList();
	
	for($i = 0, $cnt = Count($backupList); $i < $cnt; $i++)
	{
		if(md5($backupList[$i]['FileName']) == $in['ids'])
		{
			$tmpname = TEMP_DIR . '/' . 'backup.tmp.php';
			
			if(!touch($tmpname))
			{
				$this->halt($LANG['LANG_backup_temp_nopriv']);
			}

			if(extension_loaded('bz2'))
			{
				$filename = 'backup_' . date('Ymd', $backupList[$i]['BackupTime']) . '.sql.bz2';
				
				$fp = bzopen($tmpname, 'w');
				
				bzwrite($fp, file_get_contents(BACKUP_DIR. '/' . $backupList[$i]['FileName']));
				bzclose($fp);
			}
			else if(function_exists('gzencode'))
			{
				$filename = 'backup_' . date('Ymd', $backupList[$i]['BackupTime']) . '.sql.gz';

				$fp = fopen($tmpname, 'w');
				
				fwrite($fp, gzencode(file_get_contents(BACKUP_DIR. '/' . $backupList[$i]['FileName'])));
				fclose($fp);
			}
			else
			{
				$filename = 'backup_' . date('Ymd', $backupList[$i]['BackupTime']) . '.sql';

				copy(BACKUP_DIR. '/' . $backupList[$i]['FileName'], $tmpname);
			}    			
			
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=" . basename($filename));
			header("Content-Length: " . filesize($tmpname));
	
			readfile($tmpname);
			
			@unlink($tmpname);
			die;
		}
	}
	
	$this->showInfo($LANG['LANG_backup_nonexists'], SCRIPT_NAME . '?do=backup');
}
else if($in['event'] == 'delete'){
		
	$hDir = openDir(BACKUP_DIR);
	
	while(($file = readDir($hDir)) !== false)
	{
		if($file == '.' || $file == '..') continue;
		
		if(md5($file) == $in['ids'])
		{
			if(unlink(BACKUP_DIR .'/'. $file))
			{
			}
			else
			{
				closeDir($hDir);
				$this->halt($LANG['LANG_backup_delete_failed']);
			}
		}
	}
			
	closeDir($hDir);
	
	$this->showInfo($LANG['LANG_backup_delete_succeed'], SCRIPT_NAME . '?do=backup');
}
else {
	
}

function getBackupList()
{
	$backupDir = BACKUP_DIR;
	
	$hDir = openDir($backupDir);
	
	$list = array();
	
	while(($file = readDir($hDir)) !== false)
	{
		if($file == '.' || $file == '..' || !is_file($backupDir .'/'. $file)) continue;
		
		$fp = fopen($backupDir .'/'. $file, 'r');
		
		$tmp = fread($fp, 81);
		
		preg_match("/HEADER SIZE:([0-9]+)\r\nBACKUP TIME:([0-9]+)\r\n/iUs", $tmp, $arr);
		
		if($arr)
		{
			$headerSize = $arr[1];
			$backupTime = $arr[2];
		}
		else continue;
		
		fseek($fp, 0);
		
		$tmp = fread($fp, $headerSize);
		
		$tables = substr($tmp, 81, -82) . ' ';
		
		fclose($fp);
		
		$list[] = array(
							'HeaderSize'	=> $headerSize, 
							'BackupTime'	=> $backupTime, 
							'Tables'		=> $tables, 
							'BackupSize'	=> filesize($backupDir .'/'. $file) - $headerSize,
							'FileName'		=> $file,
					   );
	}
	
	closeDir($hDir);
	
	function cmp($a, $b)
	{
		if($a['BackupTime'] == $b['BackupTime']) return 0;
		return $a['BackupTime'] > $b['BackupTime'] ? -1 : 1;
	}
	
	usort($list, 'cmp');
	
	return $list;
}

?>