<?php
if(!defined('XIHU_DEFINED')) exit('Done');
require 'admin/sources/chklogin.php';

include(BASE_DIR . '/admin/lang/' . LANG_DIR . '/lang_query.php');

function PMA_splitSql(&$ret, $sql, $release = 0xFFFFFFFF)
{
	$sql          = trim($sql);
	$sql_len      = strlen($sql);
	$char         = '';
	$string_start = '';
	$in_string    = FALSE;
	$time0        = time();
	
	for ($i = 0; $i < $sql_len; ++$i) {
	    $char = $sql[$i];
	
	    // We are in a string, check for not escaped end of strings except for
	    // backquotes that can't be escaped
	    if ($in_string) {
	        for (;;) {
	            $i         = strpos($sql, $string_start, $i);
	            // No end of string found -> add the current substring to the
	            // returned array
	            if (!$i) {
	                $ret[] = $sql;
	                return TRUE;
	            }
	            // Backquotes or no backslashes before quotes: it's indeed the
	            // end of the string -> exit the loop
	            else if ($string_start == '`' || $sql[$i-1] != '\\') {
	                $string_start      = '';
	                $in_string         = FALSE;
	                break;
	            }
	            // one or more Backslashes before the presumed end of string...
	            else {
	                // ... first checks for escaped backslashes
	                $j                     = 2;
	                $escaped_backslash     = FALSE;
	                while ($i-$j > 0 && $sql[$i-$j] == '\\') {
	                    $escaped_backslash = !$escaped_backslash;
	                    $j++;
	                }
	                // ... if escaped backslashes: it's really the end of the
	                // string -> exit the loop
	                if ($escaped_backslash) {
	                    $string_start  = '';
	                    $in_string     = FALSE;
	                    break;
	                }
	                // ... else loop
	                else {
	                    $i++;
	                }
	            } // end if...elseif...else
	        } // end for
	    } // end if (in string)
	
	    // We are not in a string, first check for delimiter...
	    else if ($char == ';') {
	        // if delimiter found, add the parsed part to the returned array
	        $ret[]      = substr($sql, 0, $i);
	        $sql        = ltrim(substr($sql, min($i + 1, $sql_len)));
	        $sql_len    = strlen($sql);
	        if ($sql_len) {
	            $i      = -1;
	        } else {
	            // The submited statement(s) end(s) here
	            return TRUE;
	        }
	    } // end else if (is delimiter)
	
	    // ... then check for start of a string,...
	    else if (($char == '"') || ($char == '\'') || ($char == '`')) {
	        $in_string    = TRUE;
	        $string_start = $char;
	    } // end else if (is start of string)
	
	    // ... for start of a comment (and remove this comment if found)...
	    else if ($char == '#'
	             || ($char == ' ' && $i > 1 && $sql[$i-2] . $sql[$i-1] == '--')) {
	        // starting position of the comment depends on the comment type
	        $start_of_comment = (($sql[$i] == '#') ? $i : $i-2);
	        // if no "\n" exits in the remaining string, checks for "\r"
	        // (Mac eol style)
	        $end_of_comment   = (strpos(' ' . $sql, "\012", $i+2))
	                          ? strpos(' ' . $sql, "\012", $i+2)
	                          : strpos(' ' . $sql, "\015", $i+2);
	        if (!$end_of_comment) {
	            // no eol found after '#', add the parsed part to the returned
	            // array if required and exit
	            if ($start_of_comment > 0) {
	                $ret[]    = trim(substr($sql, 0, $start_of_comment));
	            }
	            return TRUE;
	        } else {
	            $sql          = substr($sql, 0, $start_of_comment)
	                          . ltrim(substr($sql, $end_of_comment));
	            $sql_len      = strlen($sql);
	            $i--;
	        } // end if...else
	    } // end else if (is comment)
	
	    // ... and finally disactivate the "/*!...*/" syntax if MySQL < 3.22.07
	    else if ($release < 32270
	             && ($char == '!' && $i > 1  && $sql[$i-2] . $sql[$i-1] == '/*')) {
	        $sql[$i] = ' ';
	    } // end else if
	
	    // loic1: send a fake header each 30 sec. to bypass browser timeout
	    $time1     = time();
	    if ($time1 >= $time0 + 30) {
	        $time0 = $time1;
	        header('X-pmaPing: Pong');
	    } // end if
	} // end for
	
	// add any rest to the returned array
	if (!empty($sql) && ereg('[^[:space:]]+', $sql)) {
	    $ret[] = $sql;
	}
	
	return TRUE;
} // end of the 'PMA_splitSqlFile()' function

//$db = &$this->db;

$Affected  = '';

if(empty($in['btnSubmit']))
{
	include template('input_query.html');;
}
else
{
	$in['qrStr'] = stripslashes(trim(unfilterHtmlChars($in['qrStr'])));
	
	$OriginalQuery = $in['qrStr'];
	
	if(!$in['qrStr']) $this->halt($LANG['LANG_query_err_input']);
	
	PMA_SplitSql($Queries, $in['qrStr']);
	
	foreach($Queries as $v)
	{
	  	$v = trim($v);
	  	
	  	if(eregi("into([[:blank:]]*)outfile", $v)) continue;
	  	if(eregi("into([[:blank:]]*)dumpfile", $v)) continue;
	  	if(eregi('^drop', $v)) continue;
	  	
	  	$rslt = $db->query($v);
	  	
	  	if(!$rslt)
	  	{
	  		$Affected .= '<b>'.$v . $LANG['LANG_query_err'] . $db->ErrorNo() . ':</b>'.$db->ErrorMsg().'<HR>';
	  	}
	  	else
	  	{
		  	if(eregi('^select', $v) || eregi('^show', $v) )
		  	{
			  	$ResultSet = "<table width=100% border=0 cellspacing=0 cellpadding=5 style='word-break:break-all' class='adminlist'>\n";
			  	
		  		$ResultSet .= "<tr class='list_title'>";
			  	for($i = 0, $cnt = $db->numFields($rslt); $i < $cnt; $i++)
			  	{
			  		$ResultSet .= "<th>".$db->fieldName($rslt, $i)."</th>";
			  	}
		  		$ResultSet .= "</tr>\n";
			  	
			  	while($arr = $db->fetchArray($rslt))
			  	{
			  		$ResultSet .= "<tr>";
				  	foreach($arr as $val)
				  	{
				  		$ResultSet .= "<td>" . $val . "&nbsp;</td>";
				  	}
			  		$ResultSet .= "</tr>\n";
			  	}
			  	
			  	$ResultSet .= "</table>\n";
				
				$Affected .= $v . $LANG['LANG_query_acc'] . $db->numRows($rslt) . '<br>' . $ResultSet . '<hr>';
		  	}
		  	else
		  	{
			  	$Affected .= $v . $LANG['LANG_query_acc'] . $db->affectedRows($rslt) . '<hr>';
		  	}
		 }
	}
	
	include template('input_query.html');;
}
?>