<?php
if(!defined('XIHU_DEFINED')) exit('Done');
require_once 'admin/sources/chklogin.php';

if(empty($in['event'])){
	
	include template('list_replace.html');
}
else if($in['event'] == 'add'){
	if(empty($in['postFlag']))
	{
		$ButtonCaption = $LANG['LANG_add'];
		include template('input_replace.html');
	}
	else
	{
		$Replaces = new Common_Logic(DBTABLE_REPLACE);
		
		if(empty($in['Old'])) $this->halt('δ'. $LANG['LANG_err_notnull']);
		if(empty($in['New'])) $this->halt('滻'. $LANG['LANG_err_notnull']);

		$Replaces->Add(
							array(
									'Old'				=> $in['Old'],
									'New'				=> $in['New'],
									'Auditing'			=> 1,
								 )
						 );
		
		$List = $Replaces->getList('Auditing=1');
		writeReplaceCache($List);				 
		autoBack($CURRENT_MODULE);
	}
}
else if($in['event'] == 'modify'){

	$Replaces = new Common_Logic(DBTABLE_REPLACE);
	
	$Replace	= $Replaces->getItem('ID', (int)$in['ids']);
	
	if(empty($in['ids']) || !$Replace || $Replace['ID'] != $in['ids'])
	{
		$this->halt($LANG['LANG_item_notexists']);
	}	
	if(empty($in['postFlag']))
	{
		$ButtonCaption = $LANG['LANG_modify'];
		include template('input_replace.html');
	}
	else
	{
		if(empty($in['Old'])) $this->halt('δ'. $LANG['LANG_err_notnull']);
		if(empty($in['New'])) $this->halt('滻'. $LANG['LANG_err_notnull']);

		$inputArray = array(
							'Old'				=> $in['Old'],
							'New'				=> $in['New'],
						   );

		//call logic's method submit data to database,
		$Replaces->Modify(
								$in['ids'],
								$inputArray
							);	
							
		$List = $Replaces->getList('Auditing=1');
		writeReplaceCache($List);				 
		autoBack($CURRENT_MODULE);	
	}
}
else if($in['event'] == 'auditing'){

	$Replaces = new Common_Logic(DBTABLE_REPLACE);
	
	if(!is_array($in['ids'])) $in['ids'] = array($in['ids']);
	
	$term = 'ID in (' . implode(',', $in['ids']) . ')';
	
	$Replaces->modifyByCondition($term, array(
											'Auditing'		=> 'not Auditing',
										  )
							 );
	
	$List = $Replaces->getList('Auditing=1');
	writeReplaceCache($List);				 
	autoBack($CURRENT_MODULE);
}
else if($in['event'] == 'delete'){

	$Replaces = new Common_Logic(DBTABLE_REPLACE);
	
	if(!is_array($in['ids'])) $in['ids'] = array($in['ids']);
	
	$term = DBTABLE_REPLACE . '.ID in (' . implode(',', $in['ids']) . ')';
	
	$Replaces->deleteByCondition($term);
	$List = $Replaces->getList('Auditing=1');
	writeReplaceCache($List);				 
	
	autoBack($CURRENT_MODULE);	
}


function writeReplaceCache($arr)
{
	$fp = fopen('cache/cache.replace.php', 'w');
	
	flock($fp, LOCK_EX);
	
	fwrite($fp, '<' . '?php' . CRLF);
	fwrite($fp, '$ROLD = array();' . CRLF);
	fwrite($fp, '$RNEW = array();' . CRLF);
	for($i = 0, $cnt = count($arr); $i < $cnt; $i++)
	{
		$old = str_replace(array('<' . '?','?' . '>'), array('\<\?','\?\>'), $arr[$i]['Old']);
		$new = str_replace(array('<' . '?','?' . '>'), array('\<\?','\?\>'), $arr[$i]['New']);
		
		fwrite($fp, '$ROLD[]= "' . $old . '";' . CRLF);
		fwrite($fp, '$RNEW[]= "' . $new . '";' . CRLF);
	}
	
	fwrite($fp, '?' . '>' . CRLF);
	fflush($fp);
	flock($fp, LOCK_UN);
	fclose($fp);
}

?>