<?php
if (!defined('DBDRIVERS_DIR'))
	define('DBDRIVERS_DIR', dirname(__FILE__));

define('LEFT_JOIN',		1);
define('RIGHT_JOIN',	2);
define('INNER_JOIN',	3);

define('SUFFIX_NUM',	1);
define('SUFFIX_ASSOC',	2);

define('ASC',		1);
define('DESC',		2);

function db($dbtype = 'mysql', $host, $user, $pass, $dbname = '', $persistent=DB_CONNECT_TYPE){
	include_once DBDRIVERS_DIR . '/drivers/class.' . $dbtype . '.php';
	
	$module = $dbtype;
	
	$object = new $module($host, $user, $pass, $dbname, $persistent);
	
	if(!$object->linkId) return false;
	return $object;
}

class GzDB{
	
	var $orderField		= '';
	var $orderMode		= '';
	
	var $tablename 		= '';
	var $group			= '';
	var $condition		= '';
	var $jointype		= LEFT_JOIN;
	var $field			= '*';
	
	var $suffix			= SUFFIX_ASSOC;
	
	var $lastResult		= '';
	
	var $allFields		= array();
		
	function &GetOne($term = '', $orderfield = '',$ordermode=DESC, $fields = '*'){
		$this->setCondition($term);
		$this->setOrder($orderfield, $ordermode);
		$this->setFields($fields);
		
		$result = $this->select(0,1);
		$list = array();
		
		while($tmp = $this->fetchArray($result))
		{
			$list[] = $tmp;
		}
		
		return $list[0];
	}
	
	function &GetAll($term = '', $start = -1, $num = -1, $orderfield = '',$ordermode=DESC, $fields = '*'){
		$this->setCondition($term);
		$this->setOrder($orderfield, $ordermode);
		$this->setFields($fields);
		
		$result = $this->select($start,$num);
		$list = array();
		
		while($tmp = $this->fetchArray($result))
		{
			$list[] = $tmp;
		}
		
		return $list;
	}
	
	function select($start = -1, $num = -1)
	{
		$tables		= $this->fieldQuoteChar . $this->tableName . $this->fieldQuoteChar;
		$condition	= $this->condition ? $this->condition : '1=1';
		
		if(!isset($start)) $start = -1;
		if(!isset($num)) $num = -1;
		
		if($this->jointype == INNER_JOIN)
		{
			for($i = 0, $cnt = count($this->relateTables); $i < $cnt; $i++)
			{
				$relTable = $this->relateTables[$i];
				
				if(strpos(strToLower($this->primaryFields[$relTable]['table']), ' as ') !== false)
				{
					$tmp = explode(' ', $this->primaryFields[$relTable]['table']);
					
					$relTableAlias = array_pop($tmp);
				}
				else
				{
					$relTableAlias = $relTable;
				}

				$tables	.= ','  . $relTable;
				
				$pr = '';
				$jo = '';
				
				if($this->autoAddPrefix)
				{
					$pr .= $this->fieldQuoteChar . $relTableAlias . $this->fieldQuoteChar  . '.';
					$jo .= $this->fieldQuoteChar . $this->joinFields[$relTable]['table'] . $this->fieldQuoteChar . '.';
				}
				
				$pr .= $this->fieldQuoteChar . $this->primaryFields[$relTable]['field'] . $this->fieldQuoteChar ;
	
				$jo .= $this->fieldQuoteChar . $this->joinFields[$relTable]['field'] . $this->fieldQuoteChar ;
				
				$condition .= ' and ' . $pr . '=' . $jo;
			}
		}
		else
		{
			$joinStr = $this->jointype == RIGHT_JOIN ? ' right join ' : ' left join ';
			
			$joinTableStr = '';
			
			if($this->relateTables)
			{
				for($i = 0, $cnt = Count($this->relateTables); $i < $cnt; $i++)
				{
					$relTable = $this->relateTables[$i];
					
					if(strpos(strToLower($this->primaryFields[$relTable]['table']), ' as ') !== false)
					{
						$tmp = explode(' ', $this->primaryFields[$relTable]['table']);
						
						$relTableAlias = array_pop($tmp);
					}
					else
					{
						$relTableAlias = $relTable;
					}

					if(empty($relTable)) continue;
					
					$pr = '';
					$jo = '';
					
					if($this->autoAddPrefix)
					{
						$pr .= $this->fieldQuoteChar . $relTableAlias . $this->fieldQuoteChar  . '.';
						$jo .= $this->fieldQuoteChar . $this->joinFields[$relTable]['table'] . $this->fieldQuoteChar  . '.';
					}
					
					$pr .= $this->fieldQuoteChar . $this->primaryFields[$relTable]['field'] . $this->fieldQuoteChar ;
					$jo .= $this->fieldQuoteChar . $this->joinFields[$relTable]['field'] . $this->fieldQuoteChar ;
					
					if(strpos(strToLower($relTable), ' as ') !== false)
					{
						$tmp = explode(' ', $relTable);
						
						$relTable = $this->fieldQuoteChar . $tmp[0] . $this->fieldQuoteChar . ' as ' . $this->fieldQuoteChar . array_pop($tmp) . $this->fieldQuoteChar;
					}
					
					$joinTableStr .= $joinStr . $relTable
										. ' on (' . $pr . '=' . $jo . ') ';
				}
				
				$tables .= ' ' . $joinTableStr;
			}
		}
		
		$fieldStr = '';
		$comma = '';
		
		$tmpFieldArr = array();
		
		for($i = 0, $cnt = count($this->allFields); $i < $cnt; $i++)
		{
			$tmpFieldArr[] = $this->allFields[$i]['name'];
		}
		
		$fieldTmp = '';
		
		for($i = 0, $cnt = Count($this->fields); $i < $cnt; $i++)
		{
			if($this->autoAddPrefix && $this->relateTables)
			{
				if(!in_array($this->fields[$i], $tmpFieldArr)) $fieldTmp = $this->fields[$i];
				else $fieldTmp = $this->fieldQuoteChar . $this->fields[$i] . $this->fieldQuoteChar;

				$fieldStr .= $comma . $this->fieldQuoteChar . $this->tableName . $this->fieldQuoteChar  . '.' . $fieldTmp;
			}
			else
			{
				if(!in_array($this->fields[$i], $tmpFieldArr)) $fieldTmp = $this->fields[$i];
				else $fieldTmp = $this->fieldQuoteChar . $this->fields[$i] . $this->fieldQuoteChar;

				$fieldStr .= $comma . $fieldTmp;
			}
			
			$comma = ',';
		}
		
		for($i = 0, $cnt = Count($this->relateTables); $i < $cnt; $i++)
		{
			$relTable = $this->relateTables[$i];
			
			if(strpos(strToLower($relTable), ' as ') !== false)
			{
				$tmp = explode(' ', $relTable);
				
				$relTableAlias = array_pop($tmp);
			}
			else $relTableAlias = $relTable;
			
			for($j = 0, $s_cnt = Count($this->relateFields[$relTable]); $j < $s_cnt; $j++)
			{
				$fieldName = $this->relateFields[$relTable][$j];
				
				if($this->autoAddPrefix && in_array($fieldName, $tmpFieldArr))
				{
					$fieldName = $this->fieldQuoteChar . $relTableAlias . $this->fieldQuoteChar  . '.' . $this->fieldQuoteChar . $fieldName. $this->fieldQuoteChar ;
				}
				else
				{
					$fieldName = $relTableAlias . '.' . $fieldName;
				}
				
				$fieldStr .= ',' . $fieldName;
			}
		}
		
		if(count($this->fields) < 1) $fieldStr[0] = '';
		
		$limit = ($start != -1) && ($num != -1);
		
		$orderStr = '';
	
		if(!empty($this->orderField))
		{
			$orderStr = ' order by ';
			
			for($i = 0, $cnt = Count($this->orderField); $i < $cnt; $i++)
			{
				$orderStr .= $this->orderField[$i] . ' ' . $this->orderMode[$i];
				
				if($i < $cnt - 1) $orderStr .= ',';
			}
		}
		
		if(DB_LIMIT)
		{
			$qrStr = 'select ' . $this->prefix . ' ' . $fieldStr . ' from ' . $tables
						. ('where' == 'where' ? ' where ' . $condition : '')
						. ($this->group ? ' group by ' . $this->group : '')
						//. ($this->conditionUse == 'having' ? ' having ' . $condition : '')
						. $orderStr
						. ($limit ? ' limit ' . $start . ', ' . $num : '');
			
			$this->lastResult = $iCode = $this->query($qrStr);
			
			return $iCode;
		}
		else
		{
			$qrStr = 'select ' . ($limit ? ' top ' . ($start + $num) : '') . ' ' . $this->prefix . $fieldStr . ' from ' . $tables
						. ($this->group ? ' group by ' . $this->group : '')
						. ($this->group ? ' having ' : ' where ')
						. $condition
						. $orderStr;
			
			$this->lastResult = $iCode = $this->query($qrStr);
			
			if($iCode && $limit)
				if($start > 0)
					$this->dataSeek($iCode, $start);
			
			$this->lastResult = $iCode;
			
			return $iCode;
		}
	}
	
	function insert($arr)
	{
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		if(!is_array($argv[0])) $arr = &$argv;
		else $arr = &$argv[0];
		
		if($this->suffix == SUFFIX_NUM)
		{
			$arr = array_values($arr);
		}
		
		if($this->autoEscapeValue)
		{
			foreach($arr as $k => $v)
			{
				$arr[$k] = $this->escapeString($v);
			}
		}

		if($this->suffix == SUFFIX_ASSOC)
		{
			$fields = array_keys($arr);
			
			$values	= array_values($arr);
		}
		else
		{
			$fields	= array();
			$values	= array();
			
			for($i = 0, $cnt = Count($this->fields); $i < $cnt; $i++)
			{
				$fields[$i] = $this->fields[$i];
				$values[$i] = $arr[$i];
			}
			
			if(count($fields) != count($arr))
			{
				return false;
			}
		}
		
		for($i = 0, $cnt = Count($fields); $i < $cnt; $i++)
		{
			// quote field value if it need and user enabled quote
			if($this->autoQuoteField && $this->fieldNeedQuote($fields[$i]))
			{
				$values[$i] = $this->valueQuoteChar . $values[$i] . $this->valueQuoteChar;
			}
			else
			{
				if(!$values[$i]) $values[$i] = '0';
			}
		}
		
		$qrStr = 'insert into '
					. $this->fieldQuoteChar . $this->tableName . $this->fieldQuoteChar
					. ' (' . implode(',', $fields) . ') values('
					. implode(',', $values) . ')';
		//die($qrStr);
		$rtCode = $this->query($qrStr);
		
		return $rtCode;
	}
	
	function delete()
	{
		$tables		= $this->tableName;
		
		$condition	= $this->condition ? $this->condition : '1=1';
		
		$qrStr = 'delete from ' . $this->fieldQuoteChar . $tables . $this->fieldQuoteChar . ' where ' . $condition;
		
		return $this->query($qrStr);
	}
				
	function update($arr){
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		$tables		= $this->tableName;
		
		$condition	= $this->condition ? $this->condition : '1=1';
		
		if(!is_array($argv[0])) $arr = &$argv;
		else $arr = &$argv[0];
		
		if($this->suffix == SUFFIX_NUM)
		{
			$arr = array_values($arr);
		}
		
		if($this->autoEscapeValue)
		{
			foreach($arr as $k => $v)
			{
				$arr[$k] = $this->escapeString($v);
			}
		}
		
		if($this->suffix == SUFFIX_ASSOC)
		{
			$fields = array_keys($arr);
			
			$values	= array_values($arr);
		}
		else
		{
			$fields	= array();
			$values	= array();
			
			for($i = 0, $cnt = Count($this->fields); $i < $cnt; $i++)
			{
				$fields[$i] = $this->fields[$i];
				$values[$i] = $arr[$i];
			}	
	
			if(count($fields) != count($arr))
			{
				return false;
			}
		}
	
		$fieldStr = '';
		
		$comma = '';
		
		for($i = 0, $cnt = Count($fields); $i < $cnt; $i++)
		{
			// quote field value if it need and user enabled quote
			if($this->autoQuoteField && $this->fieldNeedQuote($fields[$i]))
			{
				$values[$i] = $this->valueQuoteChar . $values[$i] . $this->valueQuoteChar;
			}
			else
			{
				if(!$values[$i]) $values[$i] = '0';
			}
				
			$fieldStr	.= $comma . $this->fieldQuoteChar . $fields[$i]. $this->fieldQuoteChar . '=' . $values[$i];
			$comma		= ',';
		}
		
		$qrStr = 'update '
					. $this->fieldQuoteChar . $tables . $this->fieldQuoteChar
					. ' set '
					. $fieldStr
					. ' where '
					. $condition;
		
		return $this->query($qrStr);
	}
	
	function getCount($field = '*', $distinct = false)
	{
		$tables = $this->tableName;
		$condition = '1=1';
		
		if($this->condition) $condition = $this->condition;
		
		if($this->jointype == INNER_JOIN)
		{
			for($i = 0, $cnt = count($this->relateTables); $i < $cnt; $i++)
			{
				$tables	.= ',' . $this->fieldQuoteChar . $this->relateTables[$i] . $this->fieldQuoteChar;
				
				$pr = '';
				$jo = '';
				
				if($this->autoAddPrefix)
				{
					$pr .= $this->fieldQuoteChar . $this->primaryFields[$this->relateTables[$i]]['table'] . $this->fieldQuoteChar  . '.';
					$jo .= $this->fieldQuoteChar . $this->joinFields[$this->relateTables[$i]]['table'] . $this->fieldQuoteChar  . '.';
				}
				
				$pr .= $this->fieldQuoteChar . $this->primaryFields[$this->relateTables[$i]]['field'] . $this->fieldQuoteChar;
				$jo .= $this->fieldQuoteChar . $this->joinFields[$this->relateTables[$i]]['field'] . $this->fieldQuoteChar;
				
				$condition .= ' and ' . $pr . '=' . $jo;
			}
		}
	
		$qrStr = 'select count'
					. ($distinct ? 'distinct' : '')
					. '(' . $field
					. ') as RsltCount from '
					. $tables
					. ' where '
					. $condition;
		
		$rslt	= $this->query($qrStr);
		$arr	= $this->fetchArray($rslt);
		
		return $arr['RsltCount'];
	}
	
	//--------------------------------------------------------------------------
	// this function will overload two times
	// one of the modality like:
	//
	//		mapResult(Resource $rslt)
	//
	//
	// another modality is:
	//
	//		mapResult(int $start, int $num)
	//
	//
	// result like array(
	//						 0	=> array(
	//										$field1_name => $field1_value,
	//										.....,
	//									 ),
	//									  ..., 
	//						 $n => array(
	//										$fieldn_name => $fieldn_value,
	//										.....,
	//									)
	//					 );
	//--------------------------------------------------------------------------
	function mapResult()
	{
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		if($argc == 0)
		{
			$this->select(-1, -1);
			
			$rslt = $this->lastResult;
		}
		else if($argc == 1)
		{
			$rslt	= $argv[0];
		}
		else if($argc == 2)
		{
			$this->select($argv[0], $argv[1]);
			
			$rslt	= $this->lastResult;
		}
		else
		{	
			return false;
		}
	
		$list = array();
		
		while($arr = $this->fetchArray($rslt))
		{
			$list[] = $arr;
		}
		
		return $list;
	}
	
	function fetchNext($rslt = null, $mode = VDA_FETCH_ASSOC)
	{
		if(!$rslt) $rslt = $this->fetchArray($this->lastResult);
		
		$arr = $this->fetcharray($rslt, $mode);
		
		return $arr;	
	}
	
	//--------------------------------------------------------------------------
	// this function will overload two times
	// one of the modality like:
	//
	//	mapResultOnKey(Resource $rslt, String $field, bool $generateArray)
	//
	//
	// another modality is:
	//
	//	mapOneColumn(int $start, int $num, String $field, bool $generateArray)
	//
	//
	// result like
	//	 array(
	//			 $row1['field']	=> array($field_name1 => $field_value1, ..),
	//			 $row2['field'] => array($field_name1 => $field_value2, ..),
	//			 ....
	//		  );
	//--------------------------------------------------------------------------
	function mapResultOnKey()
	{
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		if($argc == 2)
		{
			$this->select(-1, -1);
			
			$rslt	= $this->lastResult;
			$field	= $argv[0];
			
			$genarr = $argv[1];
		}
		else if($argc == 3 && is_resource($argv[0]))
		{
			$rslt	= $argv[0];
			$field	= $argv[1];
			$genarr	= $argv[2];
		}
		else if($argc == 4)
		{
			$this->select($argv[0], $argv[1]);
			
			$rslt	= $this->lastResult;
			$field	= $argv[2];
			$genarr	= $argv[3];
		}
		else
		{
			return false;
		}
	
		$list = array();
		
		while($arr = $this->fetchArray($rslt))
		{
			if($genarr) $list[$arr[$field]][] = $arr;
			else $list[$arr[$field]] = $arr;
		}
		
		return $list;
	}
	
	//map one record
	function mapOneRow($rslt = null)
	{
		if(!$rslt)
		{
			$this->select(0, 1);
			$rslt = $this->lastResult;
		}
		
		$arr = $this->fetchArray($rslt);
		
		return $arr;
	}
	
	//--------------------------------------------------------------------------
	// this function will overload two times
	// one of the modality like:
	//
	//		mapOneColumn(Resource $rslt, String $field)
	//
	//
	// another modality is:
	//
	//		mapOneColumn(int $start, int $num, String $field)
	//
	//
	// result like array($row1['field'], $row2['field'], ... , $rown['field']);
	//--------------------------------------------------------------------------
	function mapOneColumn()
	{
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		if($argc == 1)
		{
			$this->select(-1, -1);
			
			$rslt = $this->lastResult;
			$field	= $argv[0];
		}
		else if($argc == 2)
		{
			$rslt	= $argv[0];
			$field	= $argv[1];
		}
		else if($argc == 3)
		{
			$this->select($argv[0], $argv[1]);
			
			$rslt	= $this->lastResult;
			
			$field	= $argv[2];
		}
		else
		{	
			return false;
		}
		
		$arr = array();
		
		while($tmp = $this->fetchArray($rslt))
		{
			$arr[] = $tmp[$field];
		}
	
		return $arr;
	}
	
	//--------------------------------------------------------------------------
	// this function will overload two times
	// one of the modality like:
	//
	//		mapHashTable(Resource $rslt, String $key, String $val)
	//
	//
	// another modality is:
	//
	//		mapHashTable(int $start, int $num, String $key, String $val)
	//
	//
	// result like
	//   array($row1['key'] => $row1['val'], ..., $rown['key'] => $rown['val'])
	//--------------------------------------------------------------------------
	function mapHashTable()
	{
		$argc	= func_num_args();
		$argv	= func_get_args();

		if($argc == 2)
		{
			$this->select(-1, -1);

			$rslt = $this->lastResult;

			$key = $argv[0];
			$val = $argv[1];
		}
		else if($argc == 3)
		{
			$rslt	= $argv[0];
			$key	= $argv[1];
			$val	= $argv[2];
		}
		else if($argc == 4)
		{
			$this->select($argv[0], $argv[1]);
	
			$rslt	= $this->lastResult;
			
			$key	= $argv[2];
			$val	= $argv[3];
		}
		else
		{
			return false;
		}
		
		$list = array();
		
		while($arr = $this->fetchArray($rslt))
		{
			$list[$arr[$key]] = $arr[$val];
		}
	
		return $list;
	}

	function getDatabaseSize($tablePrefix)
	{
		return $this->getsize($tablePrefix);
	}
	
	function setTableName($tableName, $fields = '*'){
		$this->tableName = $tableName;
		
		$this->relateTables	= array();

		$this->suffix		= SUFFIX_ASSOC;
		$this->condition	= '';
		$this->group		= '';
		$this->prefix		= '';
		$this->lastResult	= null;
		$this->orderField	= '';
		$this->allFields	= array();
		$this->fields		= array();
		
		$this->getAllFields();
		$this->setFields($fields);
	}

	function setRelateTables()
	{
		$argc	= func_num_args();
		$argv	= func_get_args();
		
		if($argc < 1)
		{
			$this->relateTables = array();
			
			return;
		}
		
		if(is_array($argv[0]))
		{
			$this->relateTables		= $argv[0];
		}
		else $this->relateTables	= $argv;
	}
	
	function setRelateFields($table, $returnFields, $primaryField, $joinField){
		
		$this->relateFields[$table] = $returnFields;
		if(!is_array($primaryField)) $arr = array(
												'table'	=> $table,
												'field'	=> $primaryField
											);
		else
		{
			$arr = array(
							'table'	=> $primaryField[0],
							'field'	=> $primaryField[1],
						);
		}
		
		$this->primaryFields[$table] = $arr;
		
		if(!is_array($joinField)) $arr = array(
												'table'	=> $this->tableName,
												'field'	=> $joinField
											);
		else
		{
			$arr = array(
							'table'	=> $joinField[0],
							'field'	=> $joinField[1],
						);
		}
		
		$this->joinFields[$table] = $arr;		
	}
	
	function setCondition($condition){
		$this->condition = $condition;
	}
	
	function setGroup($field){
		$this->group = $field;
	}
	
	//private
	function getAllFields()
	{
		$rslt = $this->listFields($this->tableName);
		
		for($i = 0, $cnt = $this->numFields($rslt); $i < $cnt; $i++)
		{
			$obj = $this->fetchField($rslt, $i);
			
			$this->allFields[$i]['name']	= $obj->name;
			$this->allFields[$i]['type']	= $obj->type;
			$this->allFields[$i]['numeric']	= $obj->numeric;
			$this->allFields[$i]['notnull']	= $obj->not_null;
		}
	}
	
	function setFields($fields)
	{
		if(!$fields || $fields == '*' || $fields[0] == '*')
		{
			for($i = 0, $cnt = count($this->allFields); $i < $cnt; $i++)
			{
				$this->fields[$i] = $this->allFields[$i]['name'];
			}
			
			return;
		}
		
		$this->fields = $fields;
	}
		
	function setOrder($orderField, $orderMode = ASC)
	{
		if(empty($orderField)) $tmpOrderField = array();
		else
		{
			if(!is_array($orderField))
			{
				$tmpOrderField	= array($orderField);
				$tmpOrderMode	= array($orderMode == 'DESC' ? 'DESC' : 'ASC');
			}
			else
			{
				$tmpOrderField	= $orderField;
				
				for($i  = 0, $cnt = Count($orderMode); $i < $cnt; $i++)
				{
					$tmpOrderMode[$i]	= $orderMode[$i] == 'DESC' ? 'DESC' : 'ASC';
				}
			}			

			$this->orderMode  = $tmpOrderMode;
		}
		
		$this->orderField = $tmpOrderField;		
	}
		
	function fieldNeedQuote($field)
	{
		$field = strToLower($field);
		
		for($i = 0, $cnt = Count($this->allFields); $i < $cnt; $i++)
		{
			if(strToLower($this->allFields[$i]['name']) == $field)
			{
				return $this->allFields[$i]['numeric'] ? false : true;
			}
		}//end for
		
		return false;
	}//end function	
}
?>