<?php
/******************************************************************************
 * @application: MYSQLݿ							                 *
 *																			 *
 * @Author:		QQ: 40903680 Email:smartunix@126.com	MSN:xzwlove@msn.com	 *
 * @File:		class.mysql.php												 *
 * @Copyright 	www.php.com.cn		 									 	 *
 * @Create time: 2008-7-31 20:48										 	 *
 * @LastModify:	2008-7-31 20:48											 	 *
 ******************************************************************************/

define('FETCH_ASSOC',	MYSQL_ASSOC);
define('FETCH_NUM',		MYSQL_NUM);
define('FETCH_BOTH',	MYSQL_BOTH);
define('DB_LIMIT',		1);

class mysql extends GzDB{
	var $doDebug 		= false;
	var $linkId;
	var $bugMsg 		= array();
	
	var $valueQuoteChar	= '"';
	var $fieldQuoteChar	= '`';
	
	var $autoQuoteField	= true;
	var $autoQuoteValue	= true;
	var $autoAddPrefix	= true;
	var $autoEscapeValue= false;
		
	function __constructor($host, $username, $password, $database='', $persistent=DB_CONNECT_TYPE){
		$this->mysql($host, $username, $password, $database, $persistent);	
	}	
	
	function mysql($host, $username, $password, $database='', $persistent=DB_CONNECT_TYPE){
		$this->doDebug = @DEBUG ? true : false;

		$this->host = $host;
		$this->username = $username;
		$this->password = $password;
		$this->database = $database;		
		$this->persistent = $persistent;
		
		$this->linkId	= $this->connect($host, $username, $password, $persistent);
		
		if(!$this->linkId){
			return false;
		}

		if(!empty($this->database)){
			if(!$this->selectdb($this->database)){return false;}
		}
	}
	
	function connect($host, $user, $pass, $type){
		if($type == 1)
			$conn	= mysql_pconnect($host, $user, $pass);
		else $conn	= mysql_connect($host, $user, $pass);
		
		return $conn;
	}
	
	function selectDB($dbname){
		
		$rst = mysql_select_db($dbname, $this->linkId);
		
		if($rst === false){return false;}
		
		$this->database = $dbname;
		
		if($this->version() >= '4.1'){
			$this->query("set names ".CHARSET);
		}
		
		return true;
	}
		
	function getMicTime(){
		$tmp = explode(' ', microtime());
		
		return (double)$tmp[1] + (double)$tmp[0];
	}
	
	function ErrorMsg(){
		return (($this->linkId === false) ? @mysql_error() : @mysql_error($this->linkId));
	}

	function ErrorNo(){
		return (($this->linkId === false) ? @mysql_errno() : @mysql_errno($this->linkId));
	}
	
	function createDB($dbName){
	  	return $this->query("create database " . $dbName);
	}	
	
	function dropDB($dbName){
		return $this->query("drop database if exists " . $dbName);
	}
		
	function query($query, $offset=-1, $nrows=-1){
		if(!trim($query)) return false;
		
		$limit = '';
		if ($offset >= 0 || $nrows >= 0)
		{
			$offset = ($offset >= 0) ? $offset . "," : '';
			$nrows = ($nrows >= 0) ? $nrows : '18446744073709551615';
 			$limit = ' LIMIT ' . $offset . ' ' . $nrows;
		}
		
		$query = $query . $limit;
			
		if($this->doDebug)
		{
			$startTime = $this->getMicTime();
		}
		
		$rst = mysql_query($query, $this->linkId);
		
		if($this->doDebug)
		{
			preg_match('/\s*([a-zA-Z]+).*/i', $query, $tmp);
			
			$tmp = strToLower($tmp[1]);
			
			$item['Type']		= 'Query';
			$item['Sentence']	= $query;
			$item['Result']		= $tmp == 'select'
									? $this->numRows($rst)
									: $this->affectedRows();
									
			$item['Error']		= $this->ErrorNo();
			$item['ProcessTime']= $this->getMicTime() - $startTime;
	
			$this->bugMsg[] = $item;
		}
		
		if($rst === false){
			return false;	//die("ݿ");
		}
		
		return $rst;
	}	

	function affectedRows(){
		return @mysql_affected_rows($this->linkId);
	}
	
	function insertId(){
		return @mysql_insert_id($this->linkId);
	}

	function close(){
		@mysql_close($this->linkId);
		$this->linkId = false;
	}

	function version(){
		return mysql_get_server_info($this->linkId);
	}	
		
	function fetchArray($result, $result_type = MYSQL_ASSOC){
		return mysql_fetch_array($result, $result_type);
	}

	function fetchObject($rslt){
		return mysql_fetch_object($rslt);
	}
	
	function fetchAssoc($query){
		return $this->fetchArray($query, MYSQL_ASSOC);
	}

	function fetchRow($query){
		$query = mysql_fetch_row($query);
		return $query;
	}
	
	function fetchField($rslt, $field_offset){
		return mysql_fetch_field($rslt, $field_offset);
	}
	
	function fieldName($rslt, $field_offset){
		return mysql_field_name($rslt, $field_offset);
	}
	
	function fieldType($rslt, $field_offset){
		return mysql_field_type($rslt, $field_offset);
	}
	
	function fieldLen($rslt, $field_offset){
		return mysql_field_len($rslt, $field_offset);
	}
	
	function fieldSeek($rslt, $field_offset){
		return mysql_field_seek($rslt, $field_offset);
	}
	
	function fieldTable($rslt, $field_offset){
		return mysql_field_table($rslt, $field_offset);
	}
	
	function result($query, $row){
		$query = @mysql_result($query, $row);
		return $query;
	}

	function escapeString($str){
		if(function_exists('mysql_real_escape_string'))
			return mysql_real_escape_string($str, $this->linkId);
		
		return mysql_escape_string($str);
	}
	
	function dataSeek($rslt, $row){
		return mysql_data_seek($rtlt, $row);
	}

	function dbName($rslt, $row){
		return mysql_db_name($rslt, $row);
	}
	
	function listFields($tableName){
		return mysql_list_fields($this->database, $tableName, $this->linkId);
	}

	function listDbs(){
		return mysql_list_dbs($this->linkId);
	}
		
	function listTables($dbName){
		return mysql_list_tables($dbName, $this->linkId);
	}

	function numRows($query){
		$query = mysql_num_rows($query);
		return $query;
	}

	function numFields($rslt){
		return mysql_num_fields($rslt);
	}

	function getSize($tablePrefix){
		$qrStr = "show table status like '$tablePrefix%'";
	
		$result = $this->query($qrStr);
		
		if(!$result || $this->numRows($result) < 1){ return 0;}
	
		$size = 0;
	
		while($obj = $this->fetchObject($result)){
			$size += $obj->Data_length + $obj->Index_length;
		}
	
		return $size;
	}
		
	function generateSql($dbName, $tables = ''){
		
		if(empty($tables)){
			$tables	= Array();
			
			$rslt	= $this->listTables($dbName, $this->linkId);
			
			for($i = 0, $cnt = $this->numRows($rslt); $i < $cnt; $i++){
				$tables[] = $this->tableName($rslt, $i);
			}
		}
		
		$dumpStr = '';
		
		for($i = 0, $cnt = Count($tables); $i < $cnt; $i++){
			$dumpStr	.= "DROP TABLE IF EXISTS {$tables[$i]};\n";
			
			$rslt		= $this->query("SHOW CREATE TABLE {$tables[$i]}", $this->linkId);
			
			$arr		= $this->fetchArray($rslt);
			
			$dumpStr	.= $arr['Create Table'] . ";\n\n";
			
			$rslt		= $this->query("SELECT * FROM {$tables[$i]}", $this->linkId);
			
			$numFields = $this->numFields($rslt);
			
			$startTime = time();
		
			while($row = $this->fetchArray($rslt, FETCH_NUM)){
				$comma = "";
				$dumpStr .= "INSERT INTO {$tables[$i]} VALUES(";
		
				for($j = 0, $s_cnt = $this->numFields($rslt); $j < $s_cnt; $j++){
					$dumpStr	.= $comma . "'" . $this->escapeString($row[$j]) . "'";
		
					$comma		= " ,";
				}
				
				$dumpStr .= ");\n";
				
				if(!((time() - $startTime) % 30)) Header("Noop-Header: noop");
			}
		}
		
		return $dumpStr;
	}
		
	function debug()
	{
		$totalProcessTime = 0;
		$totalSQL = 0;
		
		$Str = "
		<table id=debugtable width=100% border=0 cellspacing=1 style='background:#828284;word-break: break-all'>";
	
		$Str .= "<tr style='background:Darkred;height:30;Color:White'>
					<th width=80>Type</th>
					<th>Query</th>
					<th width=100>Result</th>
					<th width=50>Error</th>
					<th width=100>ProcessTime</th>
				 </tr>\n";
		
		for($i = 0, $cnt = Count($this->bugMsg); $i < $cnt; $i++)
		{
			$Str .= "<tr style='background:#EEEEEE;Height:25;Text-Align:center'>
						<td>".$this->bugMsg[$i]["Type"]."</td>
						<td align=left>".HtmlSpecialChars($this->bugMsg[$i]["Sentence"])."</td>
						<td>" . $this->bugMsg[$i]["Result"]."</td>
						<td>".$this->bugMsg[$i]["Error"]."</td>
						<td><font color='#ff0000'>".sprintf("%.4f",$this->bugMsg[$i]["ProcessTime"])."</font></td>
					 </tr>\n";
			$totalProcessTime += (double)$this->bugMsg[$i]["ProcessTime"];
			$totalSQL++;
		}
		
		$Str .= "<tr style='background:#EEEEEE;Height:30;text-align:center'>
					<td colspan=5>
						Total execute queries: <font color='#990000'>". $totalSQL 
							. "</font>&nbsp;Total ProcessTime:<font color='#ff0000'>" 
							. sprintf('%.4f',$totalProcessTime) 
							. "</font>s</td>
				 </tr>\n";
		
		$Str .= "<tr style='background:#EEEEEE;Height:30;text-align:center'>
					<td colspan=5>
					Process Time: <font color='#ff0000'>" . sprintf('%.4f', getMicTime() - SYS_START_TIME) . "</font>s</td>
				 </tr>\n";
		
		$Str .= "</table>";
		
		return $Str;
	}
}
?>