<?php
/******************************************************************************
 * @application: MYSQLݿ							                 *
 *																			 *
 * @Author:		QQ: 40903680 Email:smartunix@126.com	MSN:xzwlove@msn.com	 *
 * @File:		class.mysql.php												 *
 * @Copyright 	www.php.com.cn		 									 	 *
 * @Create time: 2008-7-31 20:48										 	 *
 * @LastModify:	2008-7-31 20:48											 	 *
 ******************************************************************************/

define('FETCH_ASSOC',	PGSQL_ASSOC);
define('FETCH_NUM',		PGSQL_NUM);
define('FETCH_BOTH',	PGSQL_BOTH);
define('DB_LIMIT',		1);

class pgsql extends DbConnect{
	var $doDebug 		= false;
	var $linkId;
	var $bugMsg 		= array();
	
	var $valueQuoteChar	= '"';
	var $fieldQuoteChar	= '';
	
	var $autoQuoteField	= true;
	var $autoQuoteValue	= true;
	var $autoAddPrefix	= true;
	var $autoEscapeValue= false;
		
	function __constructor($host, $username, $password, $database='', $persistent=DB_CONNECT_TYPE){
		$this->pgsql($host, $username, $password, $database, $persistent);	
	}	
	
	function pgsql($host, $username, $password, $database='', $persistent=DB_CONNECT_TYPE){
		$this->doDebug = @DEBUG ? true : false;

		$this->host = $host;
		$this->username = $username;
		$this->password = $password;
		$this->database = $database;		
		$this->persistent = $persistent;
		
		$this->linkId	= $this->connect($host, $username, $password, $persistent);
		
		if(!$this->linkId){
			return false;
		}

		if(!empty($this->database)){
			if(!$this->selectdb($this->database)){return false;}
		}
	}
	
	function connect($host, $user, $pass, $type){
		$connectionString = "host=".$host." port=5432 user=".$user." password=".$pass;
		if($type == 1)
			$conn	= pg_pconnect($connectionString);
		else $conn	= pg_connect($connectionString);
		
		return $conn;
	}
	
	function selectDB($dbname){
		
		$rst = pg_select($this->linkId, $dbname,$_POST);
		
		if($rst === false){return false;}
		
		$this->database = $dbname;

		return true;
	}
		
	function getMicTime(){
		$tmp = explode(' ', microtime());
		
		return (double)$tmp[1] + (double)$tmp[0];
	}
	
	function ErrorMsg(){
		return (($this->linkId === false) ? @pg_last_error() : @pg_last_error($this->linkId));
	}

	function ErrorNo(){
		return (($this->linkId === false) ? @pg_last_notice() : @pg_last_notice($this->linkId));
	}
	
	function createDB($dbName){
	  	return $this->query("create database " . $dbName);
	}	
	
	function dropDB($dbName){
		return $this->query("drop database if exists " . $dbName);
	}
		
	function query($query, $offset=-1, $nrows=-1){
		if(!trim($query)) return false;
		
		$limit = '';
		if ($offset >= 0 || $nrows >= 0)
		{
			$offset = ($offset >= 0) ? $offset . "," : '';
			$nrows = ($nrows >= 0) ? $nrows : '18446744073709551615';
 			$limit = ' offset ' . $offset . ' limit ' . $nrows;
		}
		
		$query = $query . $limit;
			
		if($this->doDebug)
		{
			$startTime = $this->getMicTime();
		}
		
		$rst = pg_query($this->linkId, $query);
		
		if($this->doDebug)
		{
			preg_match('/\s*([a-zA-Z]+).*/i', $query, $tmp);
			
			$tmp = strToLower($tmp[1]);
			
			$item['Type']		= 'Query';
			$item['Sentence']	= $query;
			$item['Result']		= $tmp == 'select'
									? $this->numRows($rst)
									: $this->affectedRows();
									
			$item['Error']		= $this->ErrorNo();
			$item['ProcessTime']= $this->getMicTime() - $startTime;
	
			$this->bugMsg[] = $item;
		}
		
		if($rst === false){
			return false;	//die("ݿ");
		}
		
		return $rst;
	}	

	function affectedRows(){
		return @pg_affected_rows($this->linkId);
	}
	
	function insertId(){
		return @pg_last_oid($this->linkId);
	}

	function close(){
		@pg_close($this->linkId);
		$this->linkId = false;
	}

	function version(){
		return pg_version($this->linkId);
	}	
		
	function fetchArray($result, $result_type = PGSQL_ASSOC){
		return pg_fetch_array($result, $result_type);
	}

	function fetchObject($rslt){
		return pg_fetch_object($rslt);
	}
	
	function fetchAssoc($query){
		return $this->fetchArray($query, PGSQL_ASSOC);
	}

	function fetchRow($query){
		$query = pg_fetch_row($query);
		return $query;
	}
	
	function fetchField($rslt, $field_offset){
		return pg_fetch_field($rslt, $field_offset);
	}
	
	function fieldName($rslt, $field_offset){
		return pg_field_name($rslt, $field_offset);
	}
	
	function fieldType($rslt, $field_offset){
		return pg_field_type($rslt, $field_offset);
	}
	
	function fieldLen($rslt, $field_offset){
		return pg_field_len($rslt, $field_offset);
	}
	
	function fieldSeek($rslt, $field_offset){
		return pg_field_seek($rslt, $field_offset);
	}
	
	function fieldTable($rslt, $field_offset){
		return pg_field_table($rslt, $field_offset);
	}
	
	function result($query, $row){
		$query = @pg_result($query, $row);
		return $query;
	}

	function escapeString($str){
		if(function_exists('pg_real_escape_string'))
			return pg_real_escape_string($str, $this->linkId);
		
		return pg_escape_string($str);
	}
	
	function dataSeek($rslt, $row){
		return pg_result_seek($rtlt, $row);
	}

	function dbName($rslt, $row){
		return mysql_db_name($rslt, $row);
	}
	
	function listFields($tableName){
		return mysql_list_fields($this->database, $tableName, $this->linkId);
	}

	function listDbs(){
		return mysql_list_dbs($this->linkId);
	}
		
	function listTables($dbName){
		return mysql_list_tables($dbName, $this->linkId);
	}

	function numRows($query){
		$query = pg_num_rows($query);
		return $query;
	}

	function numFields($rslt){
		return pg_num_fields($rslt);
	}

	function getSize($tablePrefix){
		$qrStr = "show table status like '$tablePrefix%'";
	
		$result = $this->query($qrStr);
		
		if(!$result || $this->numRows($result) < 1){ return 0;}
	
		$size = 0;
	
		while($obj = $this->fetchObject($result)){
			$size += $obj->Data_length + $obj->Index_length;
		}
	
		return $size;
	}
		
	function generateSql($dbName, $tables = ''){
		
		if(empty($tables)){
			$tables	= Array();
			
			$rslt	= $this->listTables($dbName, $this->linkId);
			
			for($i = 0, $cnt = $this->numRows($rslt); $i < $cnt; $i++){
				$tables[] = $this->tableName($rslt, $i);
			}
		}
		
		$dumpStr = '';
		
		for($i = 0, $cnt = Count($tables); $i < $cnt; $i++){
			$dumpStr	.= "DROP TABLE IF EXISTS {$tables[$i]};\n";
			
			$rslt		= $this->query("SHOW CREATE TABLE {$tables[$i]}", $this->linkId);
			
			$arr		= $this->fetchArray($rslt);
			
			$dumpStr	.= $arr['Create Table'] . ";\n\n";
			
			$rslt		= $this->query("SELECT * FROM {$tables[$i]}", $this->linkId);
			
			$numFields = $this->numFields($rslt);
			
			$startTime = time();
		
			while($row = $this->fetchArray($rslt, FETCH_NUM)){
				$comma = "";
				$dumpStr .= "INSERT INTO {$tables[$i]} VALUES(";
		
				for($j = 0, $s_cnt = $this->numFields($rslt); $j < $s_cnt; $j++){
					$dumpStr	.= $comma . "'" . $this->escapeString($row[$j]) . "'";
		
					$comma		= " ,";
				}
				
				$dumpStr .= ");\n";
				
				if(!((time() - $startTime) % 30)) Header("Noop-Header: noop");
			}
		}
		
		return $dumpStr;
	}
		
	function debug()
	{
		$totalProcessTime = 0;
		$totalSQL = 0;
		
		$Str = "
		<table id=debugtable width=100% border=0 cellspacing=1 style='background:#828284;word-break: break-all'>";
	
		$Str .= "<tr style='background:Darkred;height:30;Color:White'>
					<th width=80>Type</th>
					<th>Query</th>
					<th width=100>Result</th>
					<th width=50>Error</th>
					<th width=100>ProcessTime</th>
				 </tr>\n";
		
		for($i = 0, $cnt = Count($this->bugMsg); $i < $cnt; $i++)
		{
			$Str .= "<tr style='background:#EEEEEE;Height:25;Text-Align:center'>
						<td>".$this->bugMsg[$i]["Type"]."</td>
						<td align=left>".HtmlSpecialChars($this->bugMsg[$i]["Sentence"])."</td>
						<td>" . $this->bugMsg[$i]["Result"]."</td>
						<td>".$this->bugMsg[$i]["Error"]."</td>
						<td><font color='#ff0000'>".sprintf("%.4f",$this->bugMsg[$i]["ProcessTime"])."</font></td>
					 </tr>\n";
			$totalProcessTime += (double)$this->bugMsg[$i]["ProcessTime"];
			$totalSQL++;
		}
		
		$Str .= "<tr style='background:#EEEEEE;Height:30;text-align:center'>
					<td colspan=5>
						Total execute queries: <font color='#990000'>". $totalSQL 
							. "</font>&nbsp;Total ProcessTime:<font color='#ff0000'>" 
							. sprintf('%.4f',$totalProcessTime) 
							. "</font>s</td>
				 </tr>\n";
		
		$Str .= "<tr style='background:#EEEEEE;Height:30;text-align:center'>
					<td colspan=5>
					Process Time: <font color='#ff0000'>" . sprintf('%.4f', getMicTime() - SYS_START_TIME) . "</font>s</td>
				 </tr>\n";
		
		$Str .= "</table>";
		
		return $Str;
	}
}
?>