<?php

function parTime($sec){
	$day	= (int)($sec / 86400);
	$hour	= (int)(($sec - $day * 86400) / 3600);
	$minute	= (int)(($sec - $day * 86400 - $hour * 3600) / 60);
	$s	= $sec - $day * 86400 - $hour * 3600 - $minute * 60;

	return sprintf("%d%dСʱ%d", $day, $hour, $minute, $s);
}

function sprintfT2F($value){
	return sprintf('%.2f', $value);
}

function setOrderBy($string){
	$tmp = explode('|', $string);
	
	for($i = 0, $cnt = count($tmp); $i < $cnt; $i++){
		$tmp2 = explode(':', $tmp[$i]);
		$tmp3[] = @$tmp2[0];
		$tmp4[] = @$tmp2[1];
		$op = ',';
	}
	
	return array($tmp3,$tmp4);
}
	
function CurrentCategoryFunc(&$arr, $isEnd = false){
	global $GLS;
	if(empty($GLS['isHtml'])){
		$Iurl = SCRIPT_DIR.'?do=list&classid='.$arr['ID'];
	}
	else
	{
		$Iurl = SCRIPT_DIR.'?do=list&classid='.$arr['ID'];
	}
	return " <a href=".$Iurl." >" . $arr['CategoryName'] . "</a> " . ($isEnd ? '' : ' > ');
}

function getSelect($Fields, $serial, $default = '', $split = ',', $view = false){
	
	$name = $Fields['name'][$serial];
	$len = $Fields['len'][$serial];
	$suffix = $Fields['suffix'][$serial];
	$int = $Fields['int'][$serial];
	$notnull = $Fields['notnull'][$serial];
	$float = $Fields['float'][$serial];
	$options = $Fields['options'][$serial];

	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($options))
	{
		$tmp = explode($split, $options);
	}
	else $tmp = $options;
	
	if($view){
		$rtStr = '';
		for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
		{
			$tmp[$i] = trim($tmp[$i]);
		
			$rtStr .= (in_array(($i+1), $default) ? $tmp[$i].($suffix ? ' '.$suffix : '') : '');
		}
	}
	else{
		$rtStr = '<select name="cfield['.$serial.']" size="'.($len ? $len : '').'" detail="'.($name ? $name : '').'"'.($int ? ' isnumeric=true' : '').($float ? ' isfloat=true' : '').($notnull ? ' notnull=true' : '').'>';
		
		for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
		{
			$tmp[$i] = trim($tmp[$i]);
		
			$rtStr .= "<option value=\"".($i+1)."\" " . (in_array(($i+1), $default) ? 'selected' : '') . ">{$tmp[$i]}</option>";
		}
		$rtStr .= '<select>'. ($suffix ? $suffix : '');
	}
	return $rtStr;
}

function getSelectList($str, $serial, $default = '', $split = ','){
	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($str))
	{
		$tmp = explode($split, $str);
	}
	else $tmp = $str;
	
	$rtStr = '';
	$span = '';
	for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
	{
		$tmp[$i] = trim($tmp[$i]);
		if(in_array(($i+1), $default)){
			$rtStr .= $span . $tmp[$i];
			$span = ',';
		}
	}
	
	return $rtStr;
}

function getCheckBox($Fields, $serial, $default = '', $split = ',', $view = false){
	
	$name = $Fields['name'][$serial];
	$len = $Fields['len'][$serial];
	$suffix = $Fields['suffix'][$serial];
	$int = $Fields['int'][$serial];
	$notnull = $Fields['notnull'][$serial];
	$float = $Fields['float'][$serial];
	$options = $Fields['options'][$serial];

	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($options))
	{
		$tmp = explode($split, $options);
	}
	else $tmp = $options;
	
	$rtStr = '';
	
	for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
	{
		$tmp[$i] = trim($tmp[$i]);
		if($view) $rtStr .= (in_array(($i+1), $default) ? '<img src="'.DEFAULT_TEMPLATE.'/images/checkbox-on.gif">' : '<img src="'.DEFAULT_TEMPLATE.'/images/checkbox-off.gif">').' '.$tmp[$i].' ';
		else $rtStr .= '<input type="checkbox" name="cfield['.$serial.'][]" value="'.($i+1).'"'. (in_array(($i+1), $default) ? 'checked' : '') .' />'.$tmp[$i];
	}
	
	return $rtStr;
}

function getCheckBoxList($str, $serial, $default = '', $split = ','){
	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($str))
	{
		$tmp = explode($split, $str);
	}
	else $tmp = $str;
	
	$rtStr = '';
	$span = '';
	for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
	{
		$tmp[$i] = trim($tmp[$i]);
		if(in_array(($i+1), $default)){
			$rtStr .= $span . $tmp[$i];
			$span = ',';
		}
	}
		
	return $rtStr;
}

function getRadio($Fields, $serial, $default = '', $split = ',', $view = false){
	
	$name = $Fields['name'][$serial];
	$len = $Fields['len'][$serial];
	$suffix = $Fields['suffix'][$serial];
	$int = $Fields['int'][$serial];
	$notnull = $Fields['notnull'][$serial];
	$float = $Fields['float'][$serial];
	$options = $Fields['options'][$serial];

	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($options))
	{
		$tmp = explode($split, $options);
	}
	else $tmp = $options;
	
	$rtStr = '';
	
	for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
	{
		$tmp[$i] = trim($tmp[$i]);
		if($view) $rtStr .= (in_array(($i+1), $default) ? '<img src="'.DEFAULT_TEMPLATE.'/images/radio-on.gif">' : '<img src="'.DEFAULT_TEMPLATE.'/images/radio-off.gif">').' '.$tmp[$i].' ';
		else $rtStr .= '<input type="radio" name="cfield['.$serial.']" value="'.($i+1).'"'. (in_array(($i+1), $default) ? 'checked' : '') .' />'.$tmp[$i].' ';
	}
	
	return $rtStr;
}

function getRadioList($str, $serial, $default = '', $split = ','){
	if(!is_array($default))
	{
		$default = explode($split, $default);
	}
	
	if(!is_array($str))
	{
		$tmp = explode($split, $str);
	}
	else $tmp = $str;
	
	$rtStr = '';
	$span = '';
	for($i = 0, $cnt = Count($tmp); $i < $cnt; $i++)
	{
		$tmp[$i] = trim($tmp[$i]);
		if(in_array(($i+1), $default)){
			$rtStr .= $span . $tmp[$i];
			$span = ',';
		}
	}
	
	return $rtStr;
}

function getTextField($Fields, $serial, $default = '', $split = ',', $view = false){
	$name = $Fields['name'][$serial];
	$len = $Fields['len'][$serial];
	$suffix = $Fields['suffix'][$serial];
	$int = $Fields['int'][$serial];
	$notnull = $Fields['notnull'][$serial];
	$float = $Fields['float'][$serial];
	$rtStr = '';
	if($view) $rtStr = $default . ($suffix ? ' '.$suffix : '');
	else $rtStr = '<input type="text" name="cfield['.$serial.']" value="'.$default.'" size="'.($len ? $len : '').'" detail="'.($name ? $name : '').'"'.($int ? ' isnumeric=true' : '').($float ? ' isfloat=true' : '').($notnull ? ' notnull=true' : '').' />'. ($suffix ? $suffix : '');
	return $rtStr;
}

function getTextList($str, $serial, $default = '', $split = ','){
	$rtStr = '';
	$rtStr .= $str;
	return $rtStr;
}

function parseFields($param,$value = array()){
	$Fields = unserialize($param);
	//print_r($Fields);
	$returnField = array();
	$cnt = count($Fields['name']);
	$i  = 0;
	$j	= -1;
	do{
		if(empty($Fields['parent'][$i])){
			$j=$i;
			$returnField[$j]['name'] = $Fields['name'][$i];
			
			switch($Fields['type'][$i]){
				case 1:
					$returnField[$j]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',');
					break;
				case 2:
				case 3:
					$returnField[$j]['value'] = @getSelect($Fields, $i,$value['field_'.$i],',');
					break;
				case 4:
				case 5:
					$returnField[$j]['value'] = @getRadio($Fields, $i,$value['field_'.$i],',');
					break;
				case 6:
					$returnField[$j]['value'] = @getCheckBox($Fields, $i,$value['field_'.$i],',');
					break;
				default:
					$returnField[$j]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',');
			}
		}
		else{
			if(!empty($Fields['parent'][$j]))
			$j++;
			
			switch($Fields['type'][$i]){
				case 1:
					$returnField[$j]['value'] .= @getTextField($Fields, $i,$value['field_'.$i],',');
					break;
				case 2:
				case 3:
					$returnField[$j]['value'] .= @getSelect($Fields, $i,$value['field_'.$i],',');
					break;
				case 4:
				case 5:
					$returnField[$j]['value'] .= @getRadio($Fields, $i,$value['field_'.$i],',');
					break;
				case 6:
					$returnField[$j]['value'] .= @getCheckBox($Fields, $i,$value['field_'.$i],',');
					break;
				default:
					$returnField[$j]['value'] .= @getTextField($Fields, $i,$value['field_'.$i],',');
			}
		}

		$i++;
	}while($i < $cnt);
	/*
	for($i = 0, $cnt = count($Fields['name']); $i < $cnt; $i++){
		$returnField[$i]['name'] = $Fields['name'][$i];
		
		switch($Fields['type'][$i]){
			case 1:
				$returnField[$i]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',');
				break;
			case 2:
			case 3:
				$returnField[$i]['value'] = @getSelect($Fields, $i,$value['field_'.$i],',');
				break;
			case 4:
			case 5:
				$returnField[$i]['value'] = @getRadio($Fields, $i,$value['field_'.$i],',');
				break;
			case 6:
				$returnField[$i]['value'] = @getCheckBox($Fields, $i,$value['field_'.$i],',');
				break;
			default:
				$returnField[$i]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',');
		}
	}
	*/
	
	return array_values($returnField);
}

function parseListFields($param,$value = array()){
	$Fields = @unserialize($param);
	
	$returnField = array();
	for($i = 0, $cnt = count($Fields['name']); $i < $cnt; $i++){
		$name = $Fields['name'][$i];
		$returnField[$name]['name'] = $name;
		
		switch($Fields['type'][$i]){
			case 1:
				$returnField[$name]['value'] = @getTextList($Fields['options'][$i], $i,$value['field_'.$i],',');
				break;
			case 2:
			case 3:
				$returnField[$name]['value'] = @getSelectList($Fields['options'][$i], $i,$value['field_'.$i],',');
				break;
			case 4:
			case 5:
				$returnField[$name]['value'] = @getRadioList($Fields['options'][$i], $i,$value['field_'.$i],',');
				break;
			case 6:
				$returnField[$name]['value'] = @getCheckBoxList($Fields['options'][$i], $i,$value['field_'.$i],',');
				break;
			default:
				$returnField[$name]['value'] = @getTextList($Fields['options'][$i], $i,$value['field_'.$i],',');
		}
	}
	
	return $returnField;
}

function parseViewFields($param,$value = array()){
	$Fields = @unserialize($param);
	//print_r($Fields);
	$returnField = array();
	$cnt = count($Fields['name']);
	$i  = 0;
	$j	= 0;
	do{
		if(empty($Fields['parent'][$i])){
			$j=$i;
			$returnField[$j]['name'] = $Fields['name'][$i];
			
			switch($Fields['type'][$i]){
				case 1:
					$returnField[$j]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 2:
				case 3:
					$returnField[$j]['value'] = @getSelect($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 4:
				case 5:
					$returnField[$j]['value'] = @getRadio($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 6:
					$returnField[$j]['value'] = @getCheckBox($Fields, $i,$value['field_'.$i],',',true);
					break;
				default:
					$returnField[$j]['value'] = @getTextField($Fields, $i,$value['field_'.$i],',',true);
			}
		}
		else{
			if(!empty($Fields['parent'][$j]))
			$j++;
			
			switch($Fields['type'][$i]){
				case 1:
					$returnField[$j]['value'] .= @getTextField($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 2:
				case 3:
					$returnField[$j]['value'] .= @getSelect($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 4:
				case 5:
					$returnField[$j]['value'] .= @getRadio($Fields, $i,$value['field_'.$i],',',true);
					break;
				case 6:
					$returnField[$j]['value'] .= @getCheckBox($Fields, $i,$value['field_'.$i],',',true);
					break;
				default:
					$returnField[$j]['value'] .= @getTextField($Fields, $i,$value['field_'.$i],',',true);
			}
		}

		$i++;
	}while($i < $cnt);
	
	return array_values($returnField);
}

function loadBlock($blockAtt){
	$CMSCONF['blockcachetime'] = 0;
	$cachefile = md5($blockAtt).'.php';
	if(!empty($CMSCONF['blockcachetime']) && @filemtime($cachefile) >= (time() - $CMSCONF['blockcachetime'])) {
		
	}
	else{
		$a = preg_replace("/[\n\r\t ]+/is", "...", trim($blockAtt));
		$a = explode('...', $a);
	}
}

function remarkList($page, $pageCount, $recordCount, $pageSize){
	$Pages = '';
	
//	$Pages .= '<span class=pageNumber>' . $pageCount . '</span>ҳ ';
	
//	$Pages .= 'ǰ<span class=pageNumber>' . $page . '</span>ҳ ';
	//'<div class="viciao"><span class="disabled"> <  Prev</span><span class="current">1</span><a href="#?page=2">2</a><a href="#?page=3">3</a><a href="#?page=4">4</a><a href="#?page=5">5</a><a href="#?page=6">6</a><a href="#?page=7">7</a>...<a href="#?page=199">199</a><a href="#?page=200">200</a><a href="#?page=2">Next  > </a></div>'
	$Pages .= "<a title=ҳ href='javascript:jcyhm(0)'><span class=pageCn><FONT face=webdings>9</FONT></span></a>  ";

	if($page != 1) $Pages .= "<a href='javascript:jcyhm(".($page - 1).")'><span class=pageCn><FONT face=webdings>7</FONT></span></a>  ";			
	
	if($page % 10 == 0)
	$tmp = 10;
	else $tmp = $page % 10;
	
//	if($page > 10) $Pages .= "<a title=ʮҳ href='" . preg_replace($Mask, '&page=' . ($page - $tmp), $BaseUrl) . "'><span class=pageCn><FONT face=webdings>7</FONT></span></a>  ";
	
	$Pages .= "<b>";
	
	if($page % 10 == 0)
	{
	$tmp1 = $page - $page % 10 - 10;
    }
	else $tmp1 = $page - $page % 10;
	
	for($i = $tmp1 + 1; $i < $tmp1 + 11; $i++)
	{
		if($i > $pageCount) continue;
		if($i == $page) $Pages .= "<a href='javascript:jcyhm(".$i.")'><span class=currentPage>" . $i . "</span></a> "; 	
		else $Pages .= "<a href='javascript:jcyhm(".$i.")'><span class=numberList>" . $i . "</span></a> "; 	
	} 
	
	$Pages .= "</b>";
	
	$tmp2 = $pageCount - $pageCount % 10;
	
	if($page % 10 == 0)
	$tmp = 1;
	else $tmp = 11 - $page % 10;
	
//	if($tmp1 < $tmp2) $Pages .= "<a title=ʮҳ href='" . preg_replace($Mask, '&page=' . $page + $tmp, $BaseUrl) . "'><span class=pageCn><FONT face=webdings>8</FONT></span></a>  ";
	
	if($page != $pageCount) $Pages .= " <a href='javascript:jcyhm(".($page + 1).")'><span class=pageCn><FONT face=webdings>8</FONT></span></a>";			

	$Pages .= " <a title=βҳ href='javascript:jcyhm(". $pageCount.")'><span class=pageCn><FONT face=webdings>:</FONT></span></a>  ";
    
	return $Pages;
}

?>