<?php


	class Ad_Logic extends Common_Logic
	{
		function Ad_Logic()
		{
			parent::Common_Logic(DBTABLE_AD);
		}
		
		function __constructor()
		{
			$this->Ad_Logic();
		}

		function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = 'ASC', $fields = '')
		{ 
			$tblObj = &$this->db;


			$tblObj->jointype = LEFT_JOIN;
			
			$tblObj->setCondition($term);
			$tblObj->setOrder($orderField, $orderMode);
			if($fields) $tblObj->setFields($fields);
			
			$tblObj->setRelateTables(array(DBTABLE_ADCATEGORY));
			$tblObj->setRelateFields(DBTABLE_ADCATEGORY, array('CategoryName'), 'ID', 'CategoryID');
			
			return $tblObj->mapResult($start, $num);
		}

		function getCount($term = '')
		{
			$tblObj = &$this->db;

			$tblObj->jointype = INNER_JOIN;
			
			$tblObj->setRelateTables(array(DBTABLE_ADCATEGORY));
			$tblObj->setRelateFields(DBTABLE_ADCATEGORY, array('CategoryName'), 'ID', 'CategoryID');			

			$tblObj->setCondition($term);
			
			return $tblObj->getCount();
		}

		function delete($ids, $id = 'ID')
		{ 
			if(is_array($ids))
			{
				for($i = 0, $cnt = Count($ids); $i < $cnt; $i++)
				{
					$ids[$i]	= (int)$ids[$i];
				}
			}
			else $ids = array((int)$ids);
			
			$tblObj = &$this->db;
			
			$tblObj->setCondition($id . ' in (' . implode(',', $ids) . ')');
			
			return $tblObj->delete();
		}
	}

?>