<?php
	

	class AdCategory_Logic extends Common_Logic
	{
		function AdCategory_Logic()
		{
			parent::Common_Logic(DBTABLE_ADCATEGORY);
		}
		
		function __constructor()
		{
			$this->AdCategory_Logic();
		}

		function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = 'ASC', $fields = '')
		{ 
			$tblObj = &$this->db;
			
			$tblObj->setCondition($term);
			$tblObj->setOrder($orderField, $orderMode);
			if($fields) $tblObj->setFields($fields);
			
			return $tblObj->mapResult($start, $num);
		}

		function getCount($term = '')
		{ 
			$this->db->setCondition($term);
			
			return $this->db->getCount();
		}

		function delete($ids, $id = 'ID')
		{ 
			if(is_array($ids))
			{
				for($i = 0, $cnt = Count($ids); $i < $cnt; $i++)
				{
					$ids[$i]	= (int)$ids[$i];
				}
			}
			else $ids = array((int)$ids);
			
			$tblObj = &$this->db;
			
			$tblObj->setCondition($id . ' in (' . implode(',', $ids) . ')');
			
			return $tblObj->delete();
		}
		
		function getADGroup($adID)
		{
				
			$AD = $this->getItem('ID', $adID);
			
			$Ads = new Common_Logic(DBTABLE_AD);
			
			$term = sprintf('Disabled = 0 and CategoryID=' . (int)$adID);

			$list = $Ads->getList($term, -1, -1, 'ID', 'DESC');	
			
			$tmpTag = '';
			$AD['links'] = '';
			$AD['texts'] = '';
			$AD['pics'] = '';
			for($i = 0, $cnt = count($list); $i < $cnt; $i++){
				$list[$i]['Url'] = '?do=adclick&id='.$list[$i]['ID'];
				$AD['links'] .= $tmpTag.$list[$i]['Url'];
				$AD['pics'] .= $tmpTag.UPLOAD_DIR.$list[$i]['FileName'];
				$AD['texts'] .= $tmpTag.$list[$i]['Alt'];
				
				$tmpTag = '|';
			}	
			
			return $AD;	
		}	
		
		function getView($adID)
		{			
			$str = '';
				
			$AD = $this->getItem('ID', $adID);
			
			$Ads = new Common_Logic(DBTABLE_AD);
			
			$term = sprintf('Disabled = 0 and CategoryID=' . (int)$adID);

			$AdItem = $Ads->getListItem($term, 'rand()');
			
			if($adID == 111) $left = " align=left hspace=8 vspace=8";
			else $left = '';
			
			if($AdItem)
			{
				$ext = getFileExt($AdItem['FileName']);
				
				if($ext == '.swf')
				{
					$str = <<<EOT
<object $left classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000'          codebase='http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0' width='{$AdItem['Width']}' height='{$AdItem['Height']}'>              <param name='movie' value='{UPLOAD_URL}/{$AdItem['FileName']}'>              <param name='quality' value='high'>            	 <param name='wmode' value='transparent'>                <embed src='{UPLOAD_URL}/{$AdItem['FileName']}' width='{$AdItem['Width']}' height='{$AdItem['Height']}'></embed>               </embed>             </object>
EOT;
					
					//"<button style='width:{$AdItem['Width']};height:{$AdItem['Height']}' onclick='alert(1)'><embed src='upload/{$AdItem['FileName']}' width='{$AdItem['Width']}' height='{$AdItem['Height']}'></embed></button>";
				}
				else
				{
					$AdItem['Url'] = '?do=adclick&id='.$AdItem['ID'];
					if($AdItem['Url']) $str = "<a href='{$AdItem['Url']}' target=_blank>";
					$str .= "<img $left src='" . UPLOAD_URL . $AdItem['FileName'] . "' border=0 ";
					
					If($AdItem['Width']) $str .= ' Width=' . (int)$AdItem['Width'];
					If($AdItem['Height']) $str .= ' Height=' . (int)$AdItem['Height'];
					
					$str .= ">";
			  		
					if($AdItem['Url']) $str .= '</a>';
				}
			}
			
			return $str;
		}
	}

?>