<?php

	class Category_Logic extends Common_Logic
	{
		function Category_Logic()
		{
			parent::Common_Logic(DBTABLE_CATEGORY);
		}
		
		function __constructor()
		{
			$this->Category_Logic();
		}
		
		function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = 'ASC', $fields = '')
		{ 
			$tblObj = &$this->db;
			
			$tblObj->setCondition($term);
			$tblObj->setOrder($orderField, $orderMode);
			if($fields) $tblObj->setFields($fields);
			
			$tblObj->setRelateTables(array(DBTABLE_FIELD));
			$tblObj->setRelateFields(DBTABLE_FIELD, array('param','theme'), 'fieldid', 'fieldid');
			
			return $tblObj->mapResult($start, $num);
		}	

		function GetNodeData($Data, $RootID = 0)
		{
			$Output		= Array();
	
			$i = 0;
	
			$len = Count($Data);
	
			if($RootID)
			{
				while(!empty($Data[$i]['ParentID']) && $Data[$i]['ParentID'] != $RootID && $i < $len) $i++;
			}
	
			$UpID	= $RootID;		//ϸڵָķุID
	
			for($cnt = Count($Data); $i < $cnt;)	//
			{
				$j = 0;		//ʼ˴ηӷݼ
	
				if ($UpID == $RootID)	//ڵһѭʱһౣ浽$Output
				{
					while(isset($Data[$i]) && $Data[$i]['ParentID'] == $UpID && $i < $len)	//жһڵǷΪֵܽڵ
					{
						$Output[$j] = $Data[$i];				//ýڵ㵽Output
	
						$tmp[$Data[$i]['ID']] = &$Output[$j];	//ҽýڵIDOutputеλ
																//.
	
						$i++;
						$j++;
					}
				}
				else
				{
					while(isset($Data[$i]) && $Data[$i]['ParentID'] == $UpID && $i < $len)
					{
						if(isset($tmp[$UpID]))
						{
							$tmp[$UpID]['Child'][$j] = $Data[$i];
							$tmp[$Data[$i]['ID']] = &$tmp[$UpID]['Child'][$j];	//ýڵIDOutputеλ
						}
	
						$i++;
						$j++;
					}
				}
	
				if(isset($Data[$i])) $UpID = $Data[$i]['ParentID'];
				else $UpID = -1;
			}
	
			return $Output;
		}
	
		function SetCategoryID($CategoryID)
		{
			$db = &$this->db;

			if($CategoryID <= 0)
			{
				$this->_SelfData	= null;
				$this->CategoryID	= 0;
				return;
			}
	
			//$Item = new pfcRecord($this->KernelRef->db, DBTABLE_CATEGORY, 'ID', $CategoryID);
			
			$db->setTableName(DBTABLE_CATEGORY);
			
			$db->setCondition('ID=' . (int)$CategoryID);
			
			$this->_SelfData = $db->MapOneRow();
			
			$this->CategoryID = $CategoryID;
		}
			
		function GetRootID()
		{
			return $this->_SelfData['RootID'];
		}
		
		function GetParentID()
		{
			return $this->_SelfData['ParentID'];
		}
		
		function DumpTypeDataToTree($condition = '1=1',$Fields = '*', $RootID = 0)
		{
			$db = &$this->db;
			
			if($Fields != '*')
			{
				$db->SetFields($Fields);
			}
	
			$db->SetCondition($condition);
			
			$db->setOrder('ParentID', ASC);
			
			$List = $db->MapResult(-1, -1);

			return $this->GetNodeData($List, $RootID);
		}
		
		function GenerateTypeTreeView($Data, $ProcessFunc, $floor = 0)
		{
			$Str = '';
			foreach($Data as $v)
			{
				if(!empty($this->CategoryID) && $this->CategoryID == $v['ID'])
				{
					$Str .= "<option thefieldid='{$v['fieldid']}' value='{$v['ID']}' selected>" . str_repeat("&nbsp;", $floor * 3) . '|-';
					
					if(function_exists($ProcessFunc)) $Str .= $ProcessFunc($v);
					else $Str .= $v['CategoryName'];
					
					$Str .= "</option>\n";
				}
				else
				{
					$Str .= "<option thefieldid='{$v['fieldid']}' value='{$v['ID']}'>" . str_repeat("&nbsp;", $floor * 3) . '|-';
					
					if(function_exists($ProcessFunc)) $Str .= $ProcessFunc($v);
					else $Str .= $v['CategoryName'];
					
					$Str .= "</option>\n";
				}
				
				if(!empty($v['Child'])) $Str .= $this->GenerateTypeTreeView($v['Child'], $ProcessFunc, $floor + 1);
			}
			
			return $Str;
		}
		
		function GenerateTypeTreeList($Data, $ProcessFunc = '')
		{
			$Str = '<ul style="Line-Height:250%">';
	
			foreach($Data as $v)
			{
				$Str .= '<li>' . '|-' ;
				//if(empty($v['Disabled'])) $Str .= "<img src='{BASE_PREFIX}/images/btn_deny.gif' border=0> ";
				$Str .= $ProcessFunc($v) . '</li>' . "\n";
				
				if(!empty($v['Child'])) $Str .= $this->GenerateTypeTreeList($v['Child'], $ProcessFunc);
			}
	
			$Str .= '</ul>';
			
			return $Str;
		}
		
		function PrintCurrentLevel($ProcessFunc = '')
		{
			if(empty($this->CategoryID)) return '';
			
			if($this->_SelfData['RootID'] == 0)
			{
				if($ProcessFunc) return $ProcessFunc($this->_SelfData, true);
				else return $this->_SelfData['CategoryName'];
			}
			
			$arr = explode(',', $this->_SelfData['Level']);
			
			if($arr[0]) $arr[] = $this->CategoryID;
			else $arr = array($this->CategoryID);
			
			$this->db->SetCondition('ID in (' . implode(',', $arr) . ')');
			
			$this->db->setFields(array('ID', 'RootID', 'ParentID', 'CategoryName'));
	
			$Data = $this->db->MapResultOnKey(-1, -1, 'ID', false);
	
			$str = '';
			
			for($i = 0, $cnt = Count($arr); $i < $cnt; $i++)
			{
				if($ProcessFunc) $str .= $ProcessFunc($Data[$arr[$i]], $i == $cnt - 1);
				else $str .= $Data[$arr[$i]]['CategoryName'] . ($i < $cnt - 1 ? ' -> ' : '');
			}
	
			return $str;
		}
		
		function PrintCurrentLevelReverse($ProcessFunc = '')
		{
			if(empty($this->CategoryID)) return '';
			
			if($this->_SelfData['RootID'] == 0)
			{
				if($ProcessFunc) return $ProcessFunc($this->_SelfData, true);
				else return $this->_SelfData['CategoryName'];
			}
			
			$arr = explode(',', $this->_SelfData['Level']);
			
			if($arr[0]) $arr[] = $this->CategoryID;
			else $arr = array($this->CategoryID);
			
			$this->db->SetCondition('ID in (' . implode(',', $arr) . ')');
			
			$this->db->setFields(array('ID', 'RootID', 'ParentID', 'CategoryName'));
	
			$Data = $this->db->MapResultOnKey(-1, -1, 'ID', false);
	
			$str = '';
			
			for($cnt = Count($arr), $i = $cnt - 1; $i >= 0; $i--)
			{
				if($ProcessFunc) $str .= $ProcessFunc($Data[$arr[$i]], $i == $cnt - 1);
				else $str = $Data[$arr[$i]]['CategoryName'] . ($i == 0 ? ' -> ' : '') . $str;
			}
	
			return $str;
		}
		
		function Modify($ID, $arr)
		{
			$this->db->SetCondition('ID = ' . (int)$ID); 
			
			return $this->db->Update($arr);
		}
		
		function GetCategory($ID)
		{
			$this->db->setFields('*');
			return $this->getItem('ID', $ID);
		}
	
		function GetLevelData($IncludeSelf = false)
		{
			if(empty($this->CategoryID)) return '';
	
			$Level = $this->_SelfData['Level'];
			
			if(!empty($Level)) $arr = explode(',', $Level);
			else $arr = Array();
	
			if($IncludeSelf) $arr[] = $this->CategoryID;
	
			if(!$arr) return Array();
	
			$this->db->SetCondition('ID in (' . implode(',', $arr) . ')');
			$this->db->SetFields('*');
	
			return $this->db->MapResult(-1, -1);
		}
	
		function GenerateRootTypeView($ProcessFunc)
		{
			$this->db->SetCondition('RootID = 0');
	
			$Data = $this->db->MapResult($this->db->Select());
			$this->db->SetFields('*');
	
			$Str = '';
			for($i = 0, $cnt = Count($Data); $i < $cnt; $i++)
			{
				if($this->CategoryID == $Data[$i]['ID'])
				{
					$Str .= "<option value={$Data[$i]['ID']} selected>" . $ProcessFunc($Data[$i]) . "</option>\n";
				}
				else
				{
					$Str .= "<option value={$Data[$i]['ID']}>" . $ProcessFunc($Data[$i]) . "</option>\n";
				}
			}
			
			return $Str;
		}
		
		function getAllParentID($IncludeSelf = false)
		{
			if(empty($this->CategoryID)) return '';
	
			$Level = $this->_SelfData['Level'];
			
			if(!empty($Level)) $arr = explode(',', $Level);
			else $arr = Array();
	
			if($IncludeSelf) $arr[] = $this->CategoryID;
	
			return $arr;			
		}
		
		function GetSubCategoryByParents($IDS)
		{
			if(!is_array($IDS)) $IDS = array($IDS);
			
			$db		= &$this->db;
			
			$db->setCondition('ParentID in (' . implode(',', $IDS) . ')');
			
			return $db->MapResultOnKey(-1, -1, 'ParentID', true);
		}
		
		function GetSubCategory($ParentID = 0, $IncludeSelf = false)
		{
			$arr = $this->_GetSubCategory($this->DumpTypeDataToTree('1=1',array('ID', 'ParentID', 'RootID'), (int)$ParentID));
			
			if($IncludeSelf) $arr[] = $ParentID;
			
			return $arr;
		}
		
		function _GetSubCategory($Data)
		{
			$sub	= array();
			
			for($i = 0, $cnt = Count($Data); $i < $cnt; $i++)
			{
				$sub[] = $Data[$i]['ID'];
				
				if(!empty($Data[$i]['Child']))
				{
					$sub = array_merge($sub, $this->_GetSubCategory($Data[$i]['Child']));
				}
			}
			
			return $sub;
		}
		
		function GetCategoryByID($ID)
	  	{
			return $this->getItem('ID', $ID);
	  	}
	  	
		function GetCategoryByName($Name)
	  	{
			return $this->getItem('CategoryName', $Name);
	  	}
	  	
		function StripHidden(&$Data)
		{
			for($i = 0, $cnt = Count($Data); $i < $cnt; $i++)
			{
				if($Data[$i]['Flag'] == 1 || $Data[$i]['Hidden']) unset($Data[$i]);
				else if(!empty($Data[$i]['Child'])) $this->StripHidden($Data[$i]['Child']);
			}
		}	
		
	  	function ShowList($term)
	  	{
	  		if(!is_array($Selected))
	  		{
	  			$Selected = array($Selected);
	  		}
	  		
	  		$Data = $this->getList($term, -1, -1, 'ID', ASC);
	
			$str = '';
			for($i = 0, $cnt = Count($Data); $i < $cnt; $i++)
			{
				$str .= "<option value='{$Data[$i]['ID']}' ";
	
				if (in_array($Data[$i]['ID'], $Selected))
				{
					$str .= 'selected';
				}
	
				$str .= ">{$Data[$i]['CategoryName']}</option>\n";
			}
	
			return $str;
	  	}
	  		
	  	function Hidden($ID)
	  	{
	  		$db = &$this->db;
	  		
	  		$db->setCondition('ID=' . (int)$ID);
	  		
	  		return $db->Update(array('Hidden' => 'not Hidden'));
	  	}
	}

?>