<?php
class Common_Logic {
	
	function __constructor($table)
	{
		$this->Common_Logic($table);
	}
	
	function Common_Logic($table)
	{
		global $db;
		
		$this->db		= &$db;
		
		$this->db->setTableName($table);
	}
	
	function add($arr)
	{
		return $this->db->insert($arr);
	}
	
	function modify($ID, $arr)
	{
		$db = &$this->db;
		
		$db->setCondition('ID=' . (int)$ID);
		
		return $db->Update($arr);
	}
	
	function modifyByCondition($term, $arr)
	{
		$db = &$this->db;
		
		$db->setCondition($term);

		return $db->Update($arr);
	}
	
	function delete($ids, $id = 'ID')
	{ 
		if(is_array($ids))
		{
			for($i = 0, $cnt = Count($ids); $i < $cnt; $i++)
			{
				$ids[$i]	= (int)$ids[$i];
			}
		}
		else $ids = array((int)$ids);
		
		$db = &$this->db;
		
		$db->setCondition($id . ' in (' . implode(',', $ids) . ')');
		
		return $db->delete();
	}
	
	function deleteByCondition($term)
	{ 
		$db = &$this->db;
		
		$db->setCondition($term);
		
		return $db->delete();
	}
	
	function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = ASC, $fields = '')
	{ 
		$db = &$this->db;
		
		$db->setCondition($term);
		$db->setOrder($orderField, $orderMode);
		if($fields) $db->setFields($fields);
		
		return $db->MapResult($start, $num);
	}
	
	function getCount($term = '')
	{ 
		$this->db->setCondition($term);
		
		return $this->db->getCount();
	}
	
	function getItem($field, $val)
	{
		$db = $this->db;
		
		$db->setCondition($db->tableName . '.' . $field . " = '" . $val . "'");
		$db->setFields('*');
		
		$arr = $db->MapOneRow();
		
		return $arr;
	}
	
	function getListItem($term, $orderField = '', $orderMode = ASC, $fields = '*')
	{
		$List = $this->getList($term, 0, 1, $orderField, $orderMode, $fields);
		
		return @$List[0];
	}

	function insertId()
	{
		return $this->db->insertId();
	}  		
}
?>