<?php


	class Info_Logic extends Common_Logic
	{
		function Info_Logic()
		{
			parent::Common_Logic(DBTABLE_INFO);
		}
		
		function __constructor()
		{
			$this->Info_Logic();
		}

		function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = 'ASC', $fields = '')
		{ 
			$tblObj = &$this->db;
			
			$tblObj->setCondition($term);
			$tblObj->setOrder($orderField, $orderMode);
			if($fields) $tblObj->setFields($fields);
			
			$tblObj->jointype = LEFT_JOIN;
			
			$tblObj->setRelateTables(array(DBTABLE_CATEGORY,DBTABLE_USER,DBTABLE_AREA,DBTABLE_INFOFIELD,DBTABLE_FIELD));
			$tblObj->setRelateFields(DBTABLE_CATEGORY, array('CategoryName','fieldid','isscore'), 'ID', 'CategoryID');
			$tblObj->setRelateFields(DBTABLE_USER, array('UserName'), 'ID', 'UserID');
			$tblObj->setRelateFields(DBTABLE_AREA, array('AreaName'), 'ID', 'AreaID');
			$tblObj->setRelateFields(DBTABLE_INFOFIELD, array('content AS Content','*'), 'infoid', 'ID');
			$tblObj->setRelateFields(DBTABLE_FIELD, array('param'), 'fieldid', array(DBTABLE_CATEGORY,'fieldid'));
			
			return $tblObj->mapResult($start, $num);
		}
		
		function getCount($term = '')
		{ 
			$tblObj = &$this->db;
			
			$tblObj->jointype = INNER_JOIN;
			
			$tblObj->setCondition($term);
			
			$tblObj->setRelateTables(array(DBTABLE_CATEGORY,DBTABLE_USER,DBTABLE_INFOFIELD));
			$tblObj->setRelateFields(DBTABLE_CATEGORY, array('CategoryName','fieldid'), 'ID', 'CategoryID');
			$tblObj->setRelateFields(DBTABLE_USER, array('UserName'), 'ID', 'UserID');
			$tblObj->setRelateFields(DBTABLE_INFOFIELD, array('content AS Content','*'), 'infoid', 'ID');
			//$tblObj->setRelateFields(DBTABLE_FIELD, array('param'), 'fieldid', array(DBTABLE_CATEGORY,'fieldid'));
			
			return $tblObj->getCount();
		}
		
		function getCount3($term = '')
		{ 
			$tblObj = &$this->db;
			
			$tblObj->setCondition($term);
			
			return $tblObj->getCount();
		}

		function delete($ids, $id = 'ID')
		{ 
			if(is_array($ids))
			{
				for($i = 0, $cnt = Count($ids); $i < $cnt; $i++)
				{
					$ids[$i]	= (int)$ids[$i];
				}
			}
			else $ids = array((int)$ids);
			
			$tblObj = &$this->db;
			
			$tblObj->setCondition($id . ' in (' . implode(',', $ids) . ')');
			
			return $tblObj->delete();
		}
	}

?>