<?php


	class News_Logic extends Common_Logic
	{
		function News_Logic()
		{
			parent::Common_Logic(DBTABLE_NEWS);
		}
		
		function __constructor()
		{
			$this->News_Logic();
		}

		function getList($term = '', $start = -1, $num = -1, $orderField = '', $orderMode = ORDER_ASC, $fields = '')
		{ 
			$tblObj = &$this->tblObj;
			
			$tblObj->setCondition($term);
			$tblObj->setOrder($orderField, $orderMode);
			if($fields) $tblObj->setFields($fields);
			
	  		$tblObj->setRelateTables(array(DBTABLE_NEWSCATEGORY, ));

			
	  		$tblObj->setRelateFields(DBTABLE_NEWSCATEGORY, array('CategoryName'));
	  		
	  		$tblObj->setPrimaryField(DBTABLE_NEWSCATEGORY, 'ID');
	  		$tblObj->setJoinField(DBTABLE_NEWSCATEGORY, 'CategoryID');
			
			
			if($this->autoTransData) $tblObj->setTranslateFunc('transData', $this);
			
			return $tblObj->mapResult($start, $num);
		}

		function getCount($term = '')
		{ 
			$this->tblObj->setCondition($term);
			
			return $this->tblObj->getCount();
		}

		function delete($ids, $id = 'ID')
		{ 
			if(is_array($ids))
			{
				for($i = 0, $cnt = Count($ids); $i < $cnt; $i++)
				{
					$ids[$i]	= (int)$ids[$i];
				}
			}
			else $ids = array((int)$ids);
			
			$tblObj = &$this->tblObj;
			
			$tblObj->setCondition($id . ' in (' . implode(',', $ids) . ')');
			
			return $tblObj->delete();
		}
	}

?>