<?php 
class Acl_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->acl			=	new Auth_Acl_Model();
		$this->group		=	new Auth_Group_Model();
		$this->membergroup	=	new Member_Group_Model();
	}
	function index(){
		$acl					=	$this->acl->getAclList();
		$tree					=	new Tree($acl->result_array(false));
		$tree->set_array_colum(array("id"=>"acl_id","parent_id"=>"acl_parent_id","name"=>"acl_name"));
		$this->view				=	new View("admin/acl/index");
		$this->view->aclTree	=	$tree->get_tree(0,"\$spacer\$acl_name");
		$this->main->is_validator=	true;
		$this->display();
	}
	function add(){
		if($this->input->post()){
			$acl	=	$this->filtrPost('acl');
			$this->acl->addAcl($acl);
			$this->main->message		='添加资源成功';
			$this->main->message_type	='success';
			$this->index();
			//缓存资源:后台管理
			$this->acl->cache();
			//缓存资源：会员管理
			$this->membergroup->cache();
			
		}
	}
	function delete($acl_id=false){
		if($this->input->post()){
			$aclid		=	$this->input->post('select_id');
		}
		else{
			$aclid[]	=	$acl_id;
		}
		$this->acl->deleteAcl($aclid);
		$this->main->message		=	"删除资源成功";
		$this->main->message_type	=	'success';
		//缓存资源
		$this->acl->cache();
		$this->index();
	}
	function edit($acl_id=false){
		if($this->input->post()){
			$acl	=	$this->filtrPost('acl');
			$acl_id	=	$this->input->post('acl_id');
			//取得指定ID的子资源
			$childrenAcl	=	$this->acl->childrenAcl($acl_id);
			if(count($childrenAcl)==0){
				$childrenAcl	=	array(0=>array());
			}
			if($acl_id!=$acl['acl_parent_id']&&!in_array($acl['acl_parent_id'],$childrenAcl[0])){
				$this->acl->updateAcl($acl,$acl_id);
				$this->main->message		=	'修改资源成功';
				$this->main->message_type	=	'success';
			}
			else{
				$this->main->message='不能选择自己作为父资源,并且不能选择自已的己资源作为父资源';
				$this->main->message_type='error';
			}
			//缓存资源:后台管理
			$this->acl->cache();
			//缓存资源：会员管理
			$this->membergroup->cache();
			$this->index();
		}
		else{
			$acl					=	$this->acl->getAclList();
			$tree					=	new Tree($acl->result_array(false));
			$this->view	=	new View("admin/acl/edit");
			$tree->set_array_colum(array("id"=>"acl_id","parent_id"=>"acl_parent_id","name"=>"acl_name"));
			$this->view->aclTree	=	$tree->get_tree(0,"\$spacer\$acl_name");
			$this->view->aclData	=	$this->acl->getAclList($acl_id)->current();
			$this->main->formAction	=	"acl/edit";
			$this->display();
		}
	}
	function assign($group_id=false){
		if($this->input->post()){
			//取得用户组ID
			$groupId	=	$this->input->post('userGroup');
			//取得资源ID
			$aclId		=	$this->input->post('acl_id');
			//删除以前的关系
			$this->acl->delete_acl_group($groupId);
			//插入新关系
			foreach ($groupId as $tmpid){
				foreach ($aclId as $tmpAclId){
					$this->acl->insert_acl_group(array('acl_id'=>$tmpAclId,'group_id'=>$tmpid));
				}
			}
			//缓存资源
			$this->acl->cache();
			$this->main->message='已经为此用户组授权成功';
			$this->main->message_type='success';
			$this->grouplist();
		}
		else{
			//取得该用户组的所有资源
			$tmpAclId				=	$this->acl->getGroupAcl($group_id);
			foreach ($tmpAclId as $tmp){
				$inAclId[]			=	$tmp->acl_id;
			}
			$userGroup				=	$this->group->grouplist()->result_array();
			$this->view				=	new View("admin/acl/assign");
			$this->view->userGroup	=	$userGroup;
			$acls					=	$this->acl->childrenAcl(0,"acl_id,acl_name,acl_value",'obj');
			foreach ($acls as $tmp){
				$aclII[$tmp->acl_id]	=	$this->acl->childrenAcl($tmp->acl_id,"acl_id,acl_name,acl_value",'obj');
				foreach ($aclII[$tmp->acl_id] as $tmpIII){
					$aclII[$tmpIII->acl_id]	=	$this->acl->childrenAcl($tmpIII->acl_id,"acl_id,acl_name,acl_value",'obj');
				}
			}
			$this->view->acl			=	$acls;
			$this->main->formAction		=	"acl/assign";
			$this->view->aclII			=	$aclII;
			$this->view->inAclId		=	@$inAclId?$inAclId:array();
			$this->view->group_id		=	$group_id;
			$this->display();
		}
	}
	function grouplist(){
		$userGroup				=	$this->group->grouplist()->result_array(false);
		$this->view				=	new View("admin/acl/grouplist");
		$this->view->groups		=	$userGroup;
		$this->display();
	}

}