<?php defined('SYSPATH') or die('No direct script access.');
/**
 * Handles loading of site resources (CSS, JS, images) using Views.
 * By default it is assumed that your media files will be stored in
 * `application/views/media`.
 *
 * Usage:
 *  `http://example.com/index.php/media/css/styles.css` 
 *
 * $Id: media.php 2545 2008-04-20 23:39:42Z JAAulde $
 *
 * @package	   Media Module
 * @author	   Greg MacLellan
 * @copyright  (c) 2007-2008 Kohana Team
 * @license	   http://kohanaphp.com/license.html 
 */
class Group_Controller extends Base_Controller {
function __construct(){ 
			parent::__construct();  
			$this->group = new Auth_Group_Model();    
			$this->tree = new Tree_Model(); 
	}

	function index($level=0){  
		$group=$this->group->grouplist($level)->result_array(false);
		$this->view 			= 	new View('admin/group/list'); 
		$this->view->groups		=	$group;
		$this->view->level		=	$level;
		$this->main->formAction	=	"group/delete";
		$this->display();
	}
	
	function add(){ 
		if($_POST){
			$add=$this->input->post('form', TRUE);
			if(!$this->group->checklist($add['group_name'],$add['group_value'])->result_array(false)){
				if($this->group->add($add)){
					$this->main->message='新增用户组成功！';
					$this->main->message_type='success';
				}else{
					$this->main->message='新增用户组失败！';
					$this->main->message_type='error';
				}
			}else{
					$this->main->message='名称或标识已存！';
					$this->main->message_type='warning';
			}
			$this->index();
		}else{
			$this->main ->formAction="group/add";
			$this->view = new View('admin/group/add'); 
			$this->main ->is_validator = "TRUE";
			
			$this->display();
		}
	}
	
	function edit($id=0){
		if($_POST){
			$edit=$this->input->post('form', TRUE);
			$check=$this->input->post('check', TRUE);
			if($this->group->checklist($edit['group_name'],$edit['group_value'])->count()<=1){
				if($this->group->edit($edit)){
					$this->main->message='成功！';
					$this->main->message_type='success';
				}else{
					$this->main->message='失败！';
					$this->main->message_type='error';
				}
			}else{
					
					$this->main->message='名称或标识已存！';
				$this->main->message_type='warning';
					
				}
				$this->index();
		}else{
			$countent=$this->group->getone($id)->current();
			$this->main ->formAction="group/edit";
			$this->view = new View('admin/group/edit'); 
			$this->view ->countent = $countent;
			$this->main ->is_validator = "TRUE";
			$this->display();
		}
	}
	function delete($level=0,$id=0){
		if(@$_POST){
			$group_id	=	$this->input->post('select_id', TRUE);
			$level=$this->input->post('level', TRUE);
		}
		else{
			$group_id[]	=	$id;
		}
		if(is_array($group_id)){
			foreach ($group_id as $id){
				$id_list['group_id']	=	$id;
				if($this->group->delete($id_list)){
					
					$this->main->message='成功！';
					$this->main->message_type='success';
				}else{
					$this->main->message='失败！';
					$this->main->message_type='error';
					
				}
			}
		}
		$this->index($level);
	
	}

}

	