<?php 
class File_Upload_Controller extends Public_Controller {
	function __construct(){
		parent::__construct();
		$this->channel	=	new Model_Channel_Model();
	}
	function index ($channelid){
		$this->view				=	new View("upload/upload");
		$this->view->uploadtype	=	Kohana::config("upload.allfile");
		$this->view->filesize	=	Kohana::config("upload.filesize");
		$this->view->limitfiles	=	Kohana::config("upload.limitfiles");
		$this->view->channel	=	$this->channel->getchannel($channelid);
		$this->view->render(true);
	}
	function upload($url=false){
		parse_str(str_replace("&amp;","&",$url),$result);
		extract($result);
		if(@$currentPath!=''){
			$targPath=$currentPath;
		}
		else{
			$targPath='upload/tmp';
		}
		if($this->input->post()){
			$_FILES = Validation::factory($_FILES)
			->add_rules('uploadfile', 'upload::valid', 'upload::type[gif,jpg,png,rar,zip,jpeg,doc,txt]', 'upload::size[10M]');
			if ($_FILES->validate()){
				// Temporary file name
				$filename = upload::save('uploadfile',null,$targPath);
				//检查是能生成缩略图
				if(in_array(strtolower(pathinfo($filename,PATHINFO_EXTENSION)),array("jpg","jpeg","png","gif"))){
					list($org_width,$org_height)	=	getimagesize($filename);
					if($org_width>$org_height){ $resizeType	=	Image::HEIGHT;}else{	$resizeType	=	Image::WIDTH;	}

					if(@$is_thumb){
						list($x,$y)						=	explode("|",THUMB_WAY);
						list($org_width,$org_height)	=	getimagesize($filename);
						if($org_width>$org_height){ $resizeType	=	Image::HEIGHT;}else{	$resizeType	=	Image::WIDTH;	}
						if($x==1&&$y==1){	$resizeType	=	Image::AUTO;	}
						$image	=	new Image($filename);
						$image->resize($width,$height,$resizeType);
						if($x!=1&&$y!=1){
							$image->crop($width,$height,$x,$y);
						}
						$image->save(path::getThumb($filename));
					}
					if(WATERMARK_ENABLE){
						Image::factory($filename)
						->makewater($water=array('type'=>WATERMARK_TYPE,'transparence'=>WATERMARK_TRANSPARENCE,'margin'=>20,'position'=>WATERMARK_POS),$font=array("color"=>"#FFFFFF","text"=>WATERMARK_TEXT,"size"=>24,"font"=>"public/share/font/ariblk.ttf","is_zh"=>true),$water_image=array('src'=>WATERMARK_PATH))
						->save($filename);
					}

				}
				$result['result']	=	"success";
				$result['temppath']	=	$filename;
				$result['size']		=	"上传成功";
				echo json_encode($result);
			}
			else{
				$result['result']	=	"error";
				$result['error']	=	"文件格式错误";
				echo json_encode($result);
			}
		}
	}
	function alone(){
		$this->view	=	new View("upload/upload");
		$this->view->uploadtype	=	$this->uploadtype;
		$this->view->filesize	=	Kohana::config("upload.filesize");
		$this->view->limitfiles	=	Kohana::config("upload.limitfiles");
		$this->view->render(true);
	}
	function image($inputid=false){
		if($this->input->post()){
			extract($_POST);
			$_FILES = Validation::factory($_FILES)
			->add_rules('uploadfile', 'upload::valid', 'upload::type[gif,jpg,png,jpeg,doc]', 'upload::size[2M]');
			if($_FILES->validate()){
				// Temporary file name
				$filename 				= 	upload::save('uploadfile',null,"upload/tmp");
				$this->view				=	new View("upload/image");
				$this->view->post		=	true;
				$this->view->inputid	=	$inputid;
				$this->view->path		=	$filename;
				$this->view->imagepath	=	$filename;
				$this->view->render(true);
			}
			else{
				die("上传文件失败，图片格式或者图片大小错误''");
			}
		}
		else{
			$this->view				=	new View("upload/image");
			$this->view->inputid	=	$inputid;
			$this->view->post		=	false;
			$this->view->render(true);
		}
	}
	function batch_image(){
		$this->view				=	new View("upload/upload");
		$this->view->uploadtype	=	"'Images(*.jpg,*.png,*.gif,*.bmp)':'*.jpg;*.png;*.gif;*.bmp'";
		$this->view->filesize	=	Kohana::config("upload.filesize");
		$this->view->limitfiles	=	Kohana::config("upload.limitfiles");
		$this->view->render(true);
	}
	function batch_app(){
		$this->view	=	new View("upload/upload");
		$this->view->uploadtype	=	"'文件(*.zip,*.rar,*.doc,*.txt)':'*.zip;*.rar;*.doc;*.txt'";
		$this->view->filesize	=	Kohana::config("upload.filesize");
		$this->view->limitfiles	=	Kohana::config("upload.limitfiles");
		$this->view->render(true);
	}
	/**
	 * 上传缩略图
	 * $thumbpath	返回值指定INPUT ID;
	 */
	function normal($channelid=false,$inputid=false){
		if($this->input->post()){
			extract($_POST);
			$_FILES = Validation::factory($_FILES)
			->add_rules('uploadfile', 'upload::valid', 'upload::type[gif,jpg,png,rar,zip,jpeg,doc,txt]', 'upload::size[10M]');
			if($_FILES->validate()){
				// Temporary file name
				$filename 				= 	upload::save('uploadfile',null,path::uploadattachment());
				//后缀
				$ext					=	pathinfo($filename,PATHINFO_EXTENSION);
				$thumb					=	path::getThumb($filename);
				if(IS_THUMB){
					if(in_array($ext,Kohana::config('upload.imagetype'))){
						list($x,$y)						=	explode("|",THUMB_WAY);
						list($org_width,$org_height)	=	getimagesize($filename);
						if($org_width>$org_height){ $resizeType	=	Image::HEIGHT;}else{	$resizeType	=	Image::WIDTH;	}
						$image	=	new Image($filename);
						$image->resize($width,$height,$resizeType);
						if($x!=1&&$y!=1){
							$image->crop($width,$height,$x,$y);
						}
						$image->save($thumb);
					}
				}
				if(in_array($ext,Kohana::config('upload.imagetype'))){
					if(WATERMARK_ENABLE){
						Image::factory($filename)
						->makewater($water=array('type'=>WATERMARK_TYPE,'transparence'=>WATERMARK_TRANSPARENCE,'margin'=>20,'position'=>WATERMARK_POS),$font=array("color"=>"#FFFFFF","text"=>WATERMARK_TEXT,"size"=>24,"font"=>"public/share/font/ariblk.ttf","is_zh"=>true),$water_image=array('src'=>WATERMARK_PATH))
						->save($filename);
					}
				}
				$this->view				=	new View("upload/normal");
				$this->view->post		=	true;
				$this->view->inputid	=	$inputid;
				$this->view->path		=	$filename;
				$this->view->imagepath	=	$thumb;
				$this->view->render(true);
			}
			else{
				
				url::redirect(BASEURI.'front/report/upload_type/'.base64_encode("file_upload/normal/$channel_id")."/true");
			}
		}
		else{
			$this->view				=	new View("upload/normal");
			$this->view->channel	=	$this->channel->getchannel($channelid);
			$this->view->inputid	=	$inputid;
			$this->view->channel_id	=	$channelid;
			$this->view->post		=	false;
			$this->view->render(true);
		}
	}
}