<?php 
class Index_Controller extends Front_Controller{
	
	function __construct(){
		parent::__construct();
		$this->index	=	new Index_Model();
		$this->html		=	new Html_Model();
		$this->channel	=	new Model_Channel_Model();
		$this->content	=	new Model_content_Model();
		$this->modelhtml=	new Model_html_Model();
		$this->cat		=	new Model_category_Model();
		
	}
	
	function index(){
		if(file_exists("index.html")){
			header("location:".BASEURL."index.html");
		}
		else{
			$this->lmtpl->content->title			=	SITE_TITLE;
			$this->lmtpl->content->keywords			=	SITE_KEYWORDS;
			$this->lmtpl->content->description		=	SITE_DESCRIPTION;
			$this->lmtpl->save(INDEX_TEMPLATE,"index".SITE_HTML_SUFFIX);
			header("location:".BASEURL."index".SITE_HTML_SUFFIX);
		}
	}
	
	function click($channelid,$contentid){
		$this->index->addClick($channelid,$contentid);
	}
	
	//统计安装站点
	function installsite($status=0,$url=''){
		if($status==0){
			remote::status("http://picphp.cn/index.php/index/installsite/1/".rawurlencode($_SERVER['HTTP_HOST']));
		}
		else{
		$domain			=	rawurldecode($url);
		//查找站点是否存在除localhost
		$count			=	$this->index->countInstallSite($domain);
		if($count>=1){
			$site		=	$this->index->getSite($domain);
			$data		=	array(
				"laster_time"	=>	time(),						  
				"login_times"	=>	$site->login_times+1,						  
			);
			$this->index->updateInstallSite($domain,$data);
		}
		else{
			$data	=	array(
				"web_domain"	=>	$domain,						  
				"limit_time"	=>	'',						  
				"licence_key"	=>	'',						  
				"create_time"	=>	time(),						  
				"laster_time"	=>	time(),						  
				"login_times"	=>	1,						  
			);
			$this->index->addInstallSite($data);
		}	
		}
	}
}