<?php 
class Html_Model extends Model{
	function __construct(){
		parent::__construct();
		$this->db	=	new Database();
		$this->category	=	new Model_Category_Model();
	}
	//通过站点查询到文章
	function channel_article_get($model_value,$channel_id,$page_no=false,$showline=30){
		$this->db->join($model_value."_channel_article as c_a","c_a.content_id=a.content_id");
		$this->db->where("c_a.channel_id",$channel_id);
		if($page_no){
			$this->db->limit($showline,$page_no);
		}
		$this->db->orderby("a.article_create_time DESC");
		return	$this->db->get($model_value."_article as a");
	}
	//取得内容附件
	function getannexs($model_value,$content_id,$annexid=0){
		$this->db->where('content_id',$content_id);
		if($annexid>0){
			$this->db->where("annex_id",$annexid);
		}
		return $this->db->get($model_value."_annex");
	}
	//取得提定文章ID的文章所有数据
	function get_content_id($model_value,$content_id=false){
		$this->db->where("con.content_id",$content_id);
		$this->db->join($model_value."_category as cat","cat.cat_id","con.cat_id","left");
		return $this->db->get($model_value.'_content as con')->current();
	}
	//网址
	function url($channelid,$catid=0,$contentid=0,$catpage=1,$contentpage=0,$urltype='url',$attachid=0){
		if(@$GLOBALS['channel'][$channelid]){
			$channel	=	$GLOBALS['channel'][$channelid];
		}else{
			$channel	=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current();
			$GLOBALS['channel'][$channelid]	=	$channel;
		}
		if($catid>0){
			if(@$GLOBALS['cat'][$channelid][$catid]){
				$cat	=	$GLOBALS['cat'][$channelid][$catid];
			}
			else{
				$cat	=	$this->db->where("cat_id",$catid)->get($channel->model_value."_category")->current();
				$GLOBALS['cat'][$channelid][$catid]	=	$cat;
			}
			if($contentid>0){
				if($attachid>0){
					$url	=	BASEURI."attachment/download/$channelid/$contentid/$attachid";
				}
				elseif($contentpage>0){
					$url	=	$cat->cat_dir."/".$contentid."_".$contentpage. SITE_HTML_SUFFIX;
				}
				else{
					$url	=	$cat->cat_dir."/".$contentid. SITE_HTML_SUFFIX;
				}
			}
			else{
				if($catpage==1){	$url	=	$cat->cat_dir."/index". SITE_HTML_SUFFIX;	}
				else{	$url	=	$cat->cat_dir."/list_".$catpage. SITE_HTML_SUFFIX;	}
			}
		}
		else{
			if($contentid>0){
				if($attachid>0){	$url	=	$channel->channel_html_dir.$contentid.$attachid. SITE_HTML_SUFFIX;		}
				else{	$url	=	$channel->channel_html_dir.$contentid. SITE_HTML_SUFFIX;	}
			}
			else{
				//站点列表分页
				if($catpage>1){
					$url	=	$channel->channel_html_dir."/list_".$catpage. SITE_HTML_SUFFIX;
				}
				else{
					$url	=	$channel->channel_html_dir."index". SITE_HTML_SUFFIX;
				}
			}
		}
		if($urltype!="dir"){
			if($channel->channel_dns!=''&&preg_match("#http:#i",$channel->channel_dns)){
				$url	=	preg_replace("#^://#i","/",$channel->channel_dns."/".$url);
			}
			else{
				$url	=	BASEURL.$url;
			}
		}
		return $url;
	}
	//分类列表
	function catlist($argument=array()){
		extract($argument);
		if(empty($imgwidth)){	$imgwidth	=	120;	}
		if(empty($imgheight)){	$imgheight	=	120;	}
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
		}
		elseif(empty($row)){	$row=8;	$limitStrat		=	0;}
		else{$limitStrat	=	0;}
		if(empty($orderby)){	$orderby	=	"list_order";	}
		if(empty($orderway)){	$orderway	=	"DESC";	}
		if(@$GLOBALS['channel_id'])	if(empty($channelid)){	$channelid	=	$GLOBALS['channel_id'];	}
		if(@$GLOBALS['catid']){	if(!isset($catid)){	$parentid	=	$GLOBALS['catid']; 	}else{	$parentid	=	$catid;	}		}
		else{	if(empty($catid)){	$parentid	=	0;	}	else{	$parentid	=	$catid;	}		}
		$model_value		=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current()->model_value;

		$this->db->where("parentid",$parentid);
		$this->db->where("channel_id",$channelid);
		$this->db->orderby($orderby,$orderway);
		$this->db->limit($row,$limitStrat);
		$cats	=	$this->db->get($model_value."_category")->result_array();
		$catlist	=	array();
		foreach ($cats as $cat){
			list($newwidth,$newheight,$cat->thumb)	=	self::imgsize($cat->thumb,$imgwidth,$imgheight);
			//标题长度为真是
			if(!empty($titlelen)){	$cat->cat_name	=	text::limit_chars($cat->cat_name,$titlelen);	}
			if(!empty($inforlen)){	$cat->description	=	text::limit_chars($cat->description,$inforlen);	}
			$cat->url		=	self::url($channelid,$cat->cat_id);
			$cat->textlink	=	"<a href='".$cat->url."' target='_blank'>".$cat->cat_name."</a>";
			$cat->thumb		=	path::getImgUrl($cat->thumb);
			$cat->imglink	=	"<a href='".$cat->url."'><img src=\"".$cat->thumb."\" width=\"$newwidth\" height=\"$newheight\" border=0></a>";

			$catlist[]	=	$cat;
		}
		return $catlist;
	}
	/**
	 * 内容列表
	 *
	 */
	function conlist($argument=array()){
		extract($argument);
		if(empty($imgwidth)){	$imgwidth	=	120;	}
		if(empty($imgheight)){	$imgheight	=	120;	}
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
		}
		elseif(empty($row)){	$row=8;	$limitStrat		=	0;}
		else{ $limitStrat	=	0;	}
		if(empty($orderby)){	$orderby	=	"publish_date";	}
		if(empty($orderway)){	$orderway	=	"DESC";	}
		if(@$GLOBALS['channel_id'])	if(empty($channelid)){	$channelid	=	$GLOBALS['channel_id'];	}
		if(@$GLOBALS['catid']){	if(empty($catid)){	$catid	=	$GLOBALS['catid'];	}	}
		$model_value		=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current()->model_value;
		if(@$catid>0){
			$sortlist			=	$this->category->getCatAllChild($model_value,$channelid,$catid);
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');
			if(count($sortlist)>=1){
				foreach ($sortlist as $value){
					$category_id[]	=	$value->cat_id;
				}
				$this->db->in("cat.cat_id",$category_id);
			}
		}
		else{
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');
		}
		$this->db->select("con.*");
		$this->db->from($model_value."_content as con");
		$this->db->where("con.channel_id",$channelid);
		$this->db->where("con.status",1);
		//根据属性查找
		if(!empty($attr)){	$this->db->where("con.attr",$attr);	}
		if(!empty($contentid)){	$this->db->where("content_id",$contentid);	}
		if(!empty($type)){	$this->db->where("con.thumb!=",'');	}
		//查询多少天以内的文档
		if(!empty($subday)){
			$today	=	time();	$seltime	=	$today-$subday*86400;
			$this->db->where("con.publish_date >",$seltime);
		}
		$this->db->limit($row,$limitStrat);
		$this->db->orderby($orderby,$orderway);
		$cons	=	$this->db->get()->result_array();
		$conlist=	array();
		foreach($cons as $con){
			list($newwidth,$newheight,$con->thumb)	=	self::imgsize($con->thumb,$imgwidth,$imgheight);
			//标题长度为真是
			if(!empty($titlelen)){	$con->title	=	text::limit_chars($con->title,$titlelen);	}
			if(!empty($inforlen)){	$con->description	=	text::limit_chars($con->description,$inforlen);	}
			$con->url		=	self::url($channelid,$con->cat_id,$con->content_id);
			$con->textlink	=	"<a href='".$con->url."' target='_blank'>".$con->title."</a>";
			$con->thumb		=	path::getImgUrl($con->thumb);
			$con->imglink	=	"<a href='".$con->url."'><img src=\"".$con->thumb."\" width=\"$newwidth\" height=\"$newheight\" border=0></a>";
			if(strpos($con->tags,",")){
				$tags	=	explode(",",$con->tags);
				$con->tags	=	"";
				foreach ($tags as $value) {
					$con->tags	.=	"<a href='".BASEURI."search/index/".rawurlencode($value)."'>".$value."</a>";
				}
			}
			elseif($con->tags!=''){
				$con->tags	=	"<a href='".BASEURI."search/index/".rawurlencode($con->tags)."'>".$con->tags."</a>";
			}
			$conlist[]	=	$con;
		}
		return $conlist;
	}
	function lists($argument=array()){
		extract($argument);
		if(empty($page)){		$page		=	$GLOBALS['page'];		}
		if(empty($pagesize)){	$pagesize	=	30;		}
		if(empty($imgwidth)){	$imgwidth	=	120;	}
		if(empty($imgheight)){	$imgheight	=	120;	}
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
			$limitStrat		=	$pagesize*$page-$pagesize+$limitStrat;
		}
		else{	$row	=	$pagesize	;	$limitStrat	=	$pagesize*$page-$pagesize;	}
		if(empty($orderby)){	$orderby	=	"publish_date";	}
		if(empty($orderway)){	$orderway	=	"DESC";	}
		if(@$GLOBALS['channel_id'])	if(empty($channelid)){	$channelid	=	$GLOBALS['channel_id'];	}
		if(@$GLOBALS['catid']){	if(empty($catid)){	$catid	=	$GLOBALS['catid'];	}	}
		$model_value		=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current()->model_value;
		if(@$catid>0){
			$sortlist			=	$this->category->getCatAllChild($model_value,$channelid,$catid);
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');
			if(count($sortlist)>=1){
				foreach ($sortlist as $value){
					$category_id[]	=	$value->cat_id;
				}
				$this->db->in("cat.cat_id",$category_id);
			}
		}
		else{
			$this->db->select("cat.*");
			$this->db->join($model_value."_category as cat","cat.cat_id",'con.cat_id','LEFT');
		}
		$this->db->select("con.*");
		$this->db->from($model_value."_content as con");
		$this->db->where("con.channel_id",$channelid);
		$this->db->where("con.status",1);
		//根据属性查找
		if(!empty($attr)){	$this->db->where("con.attr",$attr);	}
		if(!empty($type)){	$this->db->where("thumb!=",'');	}
		
		$this->db->limit($row,$limitStrat);
		$this->db->orderby($orderby,$orderway);
		$cons	=	$this->db->get()->result_array();
		$conlist=	array();
		foreach($cons as $con){
			list($newwidth,$newheight,$con->thumb)	=	self::imgsize($con->thumb,$imgwidth,$imgheight);
			//标题长度为真是
			if(!empty($titlelen)){	$con->title	=	text::limit_chars($con->title,$titlelen);	}
			if(!empty($inforlen)){	$con->description	=	text::limit_chars($con->description,$inforlen);	}
			$con->url		=	self::url($channelid,$con->cat_id,$con->content_id);
			$con->textlink	=	"<a href='".$con->url."'>".$con->title."</a>";
			$con->thumb		=	path::getImgUrl($con->thumb);
			$con->imglink	=	"<a href='".$con->url."'><img src=\"".$con->thumb."\" width=\"$newwidth\" height=\"$newheight\" border=0></a>";

			$conlist[]	=	$con;
		}
		return $conlist;
	}
	/**
	 * 站点列表
	 *
	 * @param unknown_type $argument=array(
	 * 	limitid=>'1,2,3,4,5'    取得站点ID的搂据
	 *  row=>5					限制结果集
	 *  orderby=''				排序字段
	 *  orderway=''				排序方式"DESC","ASC"
	 * );
	 */
	function channel($argument=array()){
		extract($argument);
		if(isset($limitid)){ $channelid	=	explode(",",$limitid);	}
		if(empty($row)){ $row=8; }
		if(empty($orderby)){ $orderby	=	"channel_order";	}
		if(empty($orderway)){$orderway	=	"DESC";				}
		if(@$channelid){	$this->db->in("channel_id",$channelid);		}
		$this->db->orderby($orderby,$orderway);
		$this->db->limit($row,0);
		$channel	=	$this->db->select("channel_name,channel_id,channel_html_dir,channel_dns")->get("channel")->result_array();
		$rech		=	array();
		foreach($channel as $ch){
			$ch->url		=	$ch->channel_dns==''?self::url($ch->channel_id):$ch->channel_dns;
			$ch->textlink	=	"<a href='".$ch->url."'>".$ch->channel_name."</a>";
			$rech[]			=	$ch;
		}
		return $rech;
	}
	/**
	 *	热门关键字
	 */
	function hottags($argument=array()){
		extract($argument);
		if(empty($row)){	$row=8;	}
		if(empty($orderby)){	$orderby="times";	}
		if(empty($orderway)){	$orderway="DESC";	}
		$this->db->orderby($orderby,$orderway);
		$this->db->limit($row,1);
		$tags	=	$this->db->get("hot_tags")->result_array();
		foreach ($tags as $tag){
			$tag->textlink	=	"<a href='".BASEURI."search/index/".rawurlencode($tag->keywords)."'>".$tag->keywords."</a>";
			$tag->url		=	BASEURI."search/index/".rawurlencode($tag->keywords);
			$resTag[]		=	$tag;
		}
		return @$resTag?$resTag:array();
	}
	/**
	 * 搜索
	 * argument	=	array(
	 * title=''
	 * row	=''
	 * limit=''
	 * orderby=''
	 * imgwidth=''
	 * imgheight=''
	 * orderway=''
	 * );
	 */
	function search($argument=array()){
		extract($argument);
		if(empty($page)){		$page		=	@$GLOBALS['page'];		}
		if(empty($page)){		$page		=	1;		}
		if(empty($pagesize)){	$pagesize	=	30;		}
		if(empty($imgwidth)){	$imgwidth	=	120;	}
		if(empty($imgheight)){	$imgheight	=	120;	}
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
			$limitStrat		=	$pagesize*$page-$pagesize+$limitStrat;
		}
		elseif(empty($row)){	$row	=	$pagesize	;	$limitStrat	=	$pagesize*$page-$pagesize;	}
		else{$pagesize	=	$row;	$limitStrat	=	$pagesize*$page-$pagesize;}
		if(empty($orderby)){	$orderby	=	"publish_date";	}
		if(empty($orderway)){	$orderway	=	"DESC";	}
		if(@!empty($GLOBALS['search'])){
			$tmpsearch	=	$GLOBALS['search'];
			foreach($tmpsearch as $key=>$value){
				if($key=='title'){
					$keywords	=	$value	;
					$this->db->like("title",$keywords);
				}else{
					if($key=="channel_id"){
						if($value<=0){ continue;}
						$sea[$key]	=	$vlaue;
					}
					else{
						$sea[$key]	=	$value;
					}
				}
			}
		}

		if(!empty($channelid)&&$channelid>0){
			$channelid	=	explode(",",$channelid);
			$this->db->in("channel_id",$channelid);
		}
		if(!empty($catid)){
			$catid	=	explode(",",$catid);
			$this->db->in("cat_id",$catid);
		}
		if(!empty($sea)){
			$this->db->where($sea);
		}
		$this->db->in("status",1);
		//根据属性查找
		if(!empty($attr)){	$this->db->where("attr",$attr);	}
		if(!empty($type)){ $this->db->where("thumb!=","");	}
		$this->db->limit($row,$limitStrat);
		$this->db->orderby($orderby,$orderway);
		$searchResult	=	$this->db->get("search_cache")->result_array();
		if(count($searchResult)>0){
			foreach($searchResult as $search){
				//取得分类
				$model_value		=	$this->db->where("channel_id",$search->channel_id)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current()->model_value;
				$this->db->where("channel_id",$search->channel_id);
				if($search->cat_id>0){	$this->db->where("cat_id",$search->cat_id);	}
				$cat	=	$this->db->get($model_value."_category");
				list($newwidth,$newheight,$search->thumb)	=	self::imgsize($search->thumb,$imgwidth,$imgheight);
				//标题长度为真是
				if(!empty($titlelen)){	$search->title			=	text::limit_chars($search->title,$titlelen);	}
				if(!empty($inforlen)){	$search->description	=	text::limit_chars($search->description,$inforlen);	}
				$search->url		=	self::url($search->channel_id,$search->cat_id,$search->content_id);
				$search->textlink	=	"<a href='".$search->url."' target='_blank'>".$search->title."</a>";
				$search->thumb		=	path::getImgUrl($search->thumb);
				$search->imglink	=	"<a href='".$search->url."' target='_blank'><img src=\"".$search->thumb."\" width=\"$newwidth\" height=\"$newheight\" border=0></a>";

				$searchlist[]	=	$search;
			}
		}
		else{
			$searchlist	=	array();
		}
		return $searchlist;
	}
	/**
	* 	type='' 
	*	channelid='' 
	*	row='' 
	*	limit='' 
	*	orderby='' 
	*	orderway=''
	**/
	function imgdemo($argument=array()){
		extract($argument);
		if(!empty($limit)){	$limit			=	explode(",",$limit); $limitStrat		=	intval($limit[0]);	$limitEnd		=	intval($limit[1]); $row=$limitEnd-$limitStrat;	}
		elseif(empty($row)){	$row=4;	$limitStrat		=	0;	}
		else{	$limitStrat		=	0;	$limitEnd		=	$row;	}
		if(empty($orderby)){ $orderby	=	"time";	}
		if(empty($orderway)){$orderway	=	"DESC";				}
		if(@$GLOBALS['channel_id']){if(empty($channelid)){	$channelid	=	@$GLOBALS['channel_id'];	}}
		if(!empty($channelid)){
			$channelid	=	explode(",",$channelid);
			$this->db->in("i.channel_id",$channelid);
		}
		$this->db->select("i.*");
		$this->db->from("imgdemo as i");
		$this->db->join("imgdemo_type as t","t.type_id","i.type_id");
		if(@$type){	$this->db->where("t.name",$type);	}
		$this->db->orderby("i.".$orderby,$orderway);
		$this->db->limit($row,$limitStrat);
		$demos	=	$this->db->get()->result_array();
		$re		=	array();
		foreach($demos as $dmeo){
			if(@$titlelen){	$dmeo->title	=	text::limit_chars($dmeo->title,$titlelen);	}
			$dmeo->img_url	=	path::getImgUrl($dmeo->img_url);
			$dmeo->textlink	=	"<a href='".$dmeo->link."' target='_blank'>".$dmeo->title."</a>";
			$dmeo->imglink	=	"<a href='".$dmeo->link."' target='_blank'><img src='".$dmeo->img_url."' border=0></a>";
			$re[]			=	$dmeo;
		}
		return $re;
	}
	function flink($argument=array()){
		extract($argument);
		if(empty($orderby)){ $orderby	=	"order";	}
		if(empty($orderway)){$orderway	=	"DESC";	}
		if(empty($row)){	$row=20;	}
		if(!empty($type)){
			$this->db->where("type",$type);
		}
		$this->db->orderby($orderby,$orderway);
		$this->db->limit($row,0);
		$flinks	=	$this->db->get("flink")->result_array();
		$result	=	array();
		foreach($flinks as $flink){
			if(@$titlelen){	$flink->webname	=	text::limit_chars($flink->webname,$titlelen);	}
			$flink->textlink	=	"<a href='".$flink->url."' target='_blank'>".$flink->webname."</a>";
			$flink->imglink		=	"<a href='".$flink->url."' target='_blank'><img src='".$flink->logo."' border='0'></a>";
			$result[]			=	$flink;
		}
		return $result;
	}
	function pagelist($argument=array()){
		extract($argument);
		if(empty($type)){			$type	=	"digg";}
		$pagecfg['total_items']			=	$GLOBALS['sum'];
		$pagecfg['current_page']		=	$GLOBALS['page'];
		$pagecfg['items_per_page']		=	$GLOBALS['pagesize'];
		$pagecfg['base_url']			=	$GLOBALS['dir'];
		if(isset($GLOBALS['uri_segment'])){
			if($GLOBALS['uri_segment']!='')		$pagecfg['uri_segment']		=	$GLOBALS['uri_segment']	;
		}
		else{
			$pagecfg['uri_segment']			=	"list_";
		}
		if(@$GLOBALS['is_html']===false){
			$pagecfg['is_html']				=	false;
		}
		else{
			$pagecfg['is_html']				=	true;
		}
		$pagination						=	new Pagination($pagecfg);
		$pagination->render($type);
	}
	//自定义函数
	function getdate($argument=array()){
		extract($argument);
		if(preg_match("#^[0-9]+$#i",$time)){
			return date($format,$time);
		}
		else{
			die("错误的时间戳：$time");
		}
	}
	//当前位置
	function position($argument=array()){
		extract($argument);
		if(@$GLOBALS['channel_id']){	if(empty($channelid)){	$channelid	=	$GLOBALS['channel_id'];	}	}
		if(@$GLOBALS['catid']){	if(empty($catid)){	$catid	=	$GLOBALS['catid'];	}	}
		$channel		=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current();
		$this->cats			=	array();
		if(@$catid>0){
			$cats				=	$this->positionParentCat($channel->model_value,$catid);
			foreach ($cats as $cat){
				$cathtml[]		=	"<a href='".$this->url($channelid,$cat->cat_id)."'>".$cat->cat_name."</a>";
			}
		}
		$cathtml[]			=	"<a href='".$this->url($channelid)."'>首页</a>";
		//$cathtml[]			=	"<a href='".BASEURL."'>首页</a>";
		return implode("》",array_reverse($cathtml));
	}
	public $cats			=	array();
	function positionParentCat($model,$catid){
		$this->cats[]	=	$cat	=	$this->db->where("cat_id",$catid)->get($model."_category")->current();
		if($cat->parentid!=0){
			self::positionParentCat($model,$cat->parentid);
		}
		if($cat->parentid==0){
			return $this->cats;
		}
		return $this->cats;
	}
	function attachments($argument=array()){
		extract($argument);
		if(@$GLOBALS['content_id']){	if(empty($contentid)){	$contentid	=	$GLOBALS['content_id'];	}	}
		if(@$GLOBALS['channel_id']){	if(empty($channelid)){	$channelid	=	$GLOBALS['channel_id'];	}	}
		if(@$GLOBALS['catid']){	if(empty($catid)){	$catid	=	$GLOBALS['catid'];	}	}
		if(@$GLOBALS['page']){		$page		=	$GLOBALS['page'];		}
		if(empty($pagesize)){	$pagesize	=	30;		}
		if(empty($imgwidth)){	$imgwidth	=	120;	}
		if(empty($imgheight)){	$imgheight	=	120;	}
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
			$limitStrat		=	$pagesize*$page-$pagesize+$limitStrat;
		}
		elseif(@$page){	$row	=	$pagesize	;	$limitStrat	=	$pagesize*$page-$pagesize;	}

		$channel		=	$this->db->where("channel_id",$channelid)->join("model as m","ch.model_id=m.model_id")->get("channel as ch")->current();
		$this->db->where("content_id",$contentid);
		if(@$type=="image"){
			$this->db->where("is_image",1);
		}
		elseif(@$type=="other"){
			$this->db->where("is_image!=",1);
		}
		if(@$page){
			$this->db->limit($row,$limitStrat);
		}
		$result	=	$this->db->get($channel->model_value."_annex")->result_array();
		$retrun	=	array();
		foreach ($result as $annex){
			list($newwidth,$newheight,$annex->thumbs_path)	=	self::imgsize($annex->thumbs_path,$imgwidth,$imgheight);
			if($annex->is_image){
				$url				=	BASEURI."attachment/image/$channelid/$catid/$contentid/".$annex->annex_id;
				$annex->imglink		=	"<a href='".$url."' target='_blank'><img src='".path::getImgUrl($annex->thumbs_path)."' width=$newwidth height=$newheight border=0></a>";
				$annex->thumbs_path	=	path::getImgUrl($annex->thumbs_path);
				$annex->textlink	=	"<a href='".$url."' target='_blank'>".($annex->description==""?"图片":$annex->description)."</a>";
			}
			else{
				$url				=	BASEURI."attachment/download/$channelid/$catid/$contentid/".$annex->annex_id;
				$annex->textlink	=	"<a href='".$url."' target='_blank'>".($annex->description==""?"附件":$annex->description)."</a>";
			}
			$annex->url				=	$url;
			$retrun[]				=	$annex;
		}
		return $retrun;
	}

	function conPrev($model_value,$content_id,$channel_id){
		$this->db->select("con.*,cat.cat_id,cat.cat_dir,cat.cat_name,m.user_id,m.user_name");
		$this->db->where("con.content_id<",$content_id);
		$this->db->join($model_value."_category as cat","cat.cat_id","con.cat_id","left");
		$this->db->join("member as m","m.user_id","con.memberid","left");
		$reg	= $this->db->get($model_value.'_content as con')->current();
		if(is_object($reg)){
			if(strpos($reg->tags,",")){
				$tags		=	explode(",",$reg->tags);
				$reg->tags	=	"";
				foreach ($tags as $value){
					$reg->tags	.=	"<a href='".BASEURI."search/index/".rawurlencode($value)."'>".$value."</a>";
				}
			}
			elseif($reg->tags!=''){
				$reg->tags	=	"<a href='".BASEURI."search/index/".rawurlencode($reg->tags)."'>".$reg->tags."</a>";
			}
			$reg->big_img	=	$reg->big_img;
			$reg->downurl	=	BASEURI."attachment/download/".$reg->channel_id."/".$reg->cat_id."/".$reg->content_id;
		}
		return $reg;
	}
	function conNext($model_value,$content_id,$channel_id){
		$this->db->select("con.*,cat.cat_id,cat.cat_dir,cat.cat_name,m.user_id,m.user_name");
		$this->db->where("con.content_id>",$content_id);
		$this->db->join($model_value."_category as cat","cat.cat_id","con.cat_id","left");
		$this->db->join("member as m","m.user_id","con.memberid","left");
		$reg	=	$this->db->get($model_value.'_content as con')->current();
		if(is_object($reg)){
			if(strpos($reg->tags,",")){
				$tags		=	explode(",",$reg->tags);
				$reg->tags	=	"";
				foreach ($tags as $value){
					$reg->tags	.=	"<a href='".BASEURI."search/index/".rawurlencode($value)."'>".$value."</a>";
				}
			}
			elseif($reg->tags!=''){
				$reg->tags	=	"<a href='".BASEURI."search/index/".rawurlencode($reg->tags)."'>".$reg->tags."</a>";
			}
			$reg->big_img	=	$reg->big_img;
			$reg->downurl	=	BASEURI."attachment/download/".$reg->channel_id."/".$reg->cat_id."/".$reg->content_id;
		}
		return $reg;
	}
	function conCurr($model_value,$content_id,$channel_id){
		$this->db->select("con.*,cat.cat_id,cat.cat_dir,cat.cat_name,m.user_id,m.user_name");
		$this->db->where("con.content_id",$content_id);
		$this->db->join($model_value."_category as cat","cat.cat_id","con.cat_id","left");
		$this->db->join("member as m","m.user_id","con.memberid","left");
		$reg			=	$this->db->get($model_value.'_content as con')->current();
		if(is_object($reg)){
			if(strpos($reg->tags,",")){
				$tags		=	explode(",",$reg->tags);
				$reg->tags	=	"";
				foreach ($tags as $value){
					$reg->tags	.=	"<a href='".BASEURI."search/index/".rawurlencode($value)."'>".$value."</a>";
				}
			}
			elseif($reg->tags!=''){
				$reg->tags	=	"<a href='".BASEURI."search/index/".rawurlencode($reg->tags)."'>".$reg->tags."</a>";
			}
			$reg->big_img	=	$reg->big_img;
			$reg->downurl	=	BASEURI."attachment/download/".$reg->channel_id."/".$reg->cat_id."/".$reg->content_id;
		}
		return $reg;
	}
	function imgsize($path,$imgwidth,$imgheight){
		if(file_exists($path)){
			//取得源图尺寸
			list($width,$height)	=	getimagesize($path);
			if($width<$height){
				$newwidth			=	(int)$imgheight/$height*$width;
				$newheight			=	$imgheight;
			}
			elseif($width>$height){
				$newwidth			=	$imgwidth;
				$newheight			=	$imgwidth/$width*$height;
			}
			else{
				$newwidth			=	$width;
				$newheight			=	$height;
			}
		}
		else{
			$path			=	"public/share/nopic.png";
			//取得源图尺寸
			list($width,$height)	=	getimagesize($path);
			if($width<$height&&$imgheight>$height&&$imgwidth>$width){
				$newwidth	=	(int)$imgheight/$height*$width;
				$newheight	=	$imgheight;
			}
			elseif($width>$height&&$imgheight>$height&&$imgwidth>$width){
				$newwidth	=	$imgwidth;
				$newheight	=	$imgwidth/$width*$height;
			}
			else{
				$newwidth	=	$imgwidth;
				$newheight	=	$imgheight;
			}
		}
		return array($newwidth,$newheight,$path);
	}
	//自定义导航栏目
	function navbar($argument=array()){
		extract($argument);
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
		}
		else{
			$limitStrat		=	0;
		}
		$this->db->select("name,url,is_target");
		if(!empty($type)){	$this->db->where("position",$type);	}
		$this->db->where("enabled",1);
		if(!empty($row)){	$this->db->limit($row,$limitStrat);	}
		$this->db->orderby("order","DESC");
		$navbars			=	$this->db->get("navbar")->result_array();
		$arr				=	array();
		foreach($navbars as $navbar){
			$navbar->textlink	=	"<a href='".$navbar->url."'".($navbar->is_target==1?"target='_blank'":"").">".$navbar->name."</a>";
			$arr[]				=	$navbar;
		}
		return $arr;
	}
	//单页面列表
	function alonepage($argument=array()){
		extract($argument);
		if(@isset($limit)){
			$limit			=	explode(",",$limit);
			$limitStrat		=	intval($limit[0]);
			$limitEnd		=	intval($limit[1]);
			$row			=	$limitEnd-$limitStrat;
		}
		else{
			$limitStrat		=	0;
		}
		$this->db->select("title,content,filename,description,time,savepath");
		if(!empty($row)){	$this->db->limit($row,$limitStrat);	}
		if(!empty($pageid)){$this->db->where("id",$pageid);	}
		$pages				=	$this->db->get("pageweb")->result_array();
		$arr				=	array();
		foreach($pages as $page){
			$page->url		=	BASEURL.$page->savepath;
			$page->textlink	=	"<a href='".$page->url."'>".$page->title."</a>";
			$arr[]			=	$page;
		}
		return $arr;
	}
}
