<?php 
class Member_Controller extends Front_Controller {
	function __construct(){
		parent::__construct();
		$this->member		=	new Member_Model();
		$this->group 		= 	new Auth_Group_Model();
		$this->user 		= 	new Auth_User_Model();
		$this->lmtpl->user	=	@$_SESSION['user'];
	}
	function index(){
		$this->lmtpl->title			=	"会员中心";
		$this->lmtpl->keywords		=	'';
		$this->lmtpl->description	=	'';
		$this->lmtpl->render(self::tplpath("member_index"));
	}
	function login($login_message=''){
		if($this->input->post()){
			//检查验证码
			$login				=	$this->input->post('login');
			if(IS_VALID_NUMBER){
				if(strtoupper($_SESSION["valid_number"])!=strtoupper($login['valid_number'])){
					$this->Report("验证码错误","member/login");
				}
			}
			$login['password']	=	md5($login['password']);
			unset($login['valid_number']);
			$loginResult		=	$this->member->validLogin($login);
			$user				=	$loginResult->current();
			if($loginResult->count()==1){
				if($user->status==1){
					$auth	=	new Memberauth();
					//设置SESSION
					$auth->setUserSession($user->user_id);
					url::redirect(BASEURI."member/index");
				}
				else{
					$this->Report("帐号还未通过审核","member/login");
				}

			}
			else{
				$this->Report("用户名或密码错误","member/login");
			}
		}
		else{
			$this->lmtpl->title	=	"会员登录";
			$this->lmtpl->keywords='';
			$this->lmtpl->description	=	'';
			$this->lmtpl->render($this->tplmodel->path("member_login"));
		}
	}
	function revise(){
		if($this->input->post()){
			$user_id	=	$_SESSION['user']->user_id;
			$user		=	$this->input->post('form');
			if($_FILES['uploadphoto']['tmp_name']!=''){
				$_FILES = Validation::factory($_FILES)
				->add_rules('uploadphoto', 'upload::valid', 'upload::type[jpg,gif,png]', 'upload::size[2M]');
				if ($_FILES->validate()){
					//检查目录
					$dir	=	path::uploadattachment();
					if(!file_exists($dir)){
						file::create_dir_path($dir,true);
					}
					$filename = upload::save('uploadphoto',null,$dir);
					list($org_width,$org_height)	=	getimagesize($filename);
					if($org_width>$org_height){ $resizeType	=	Image::HEIGHT;}else{	$resizeType	=	Image::WIDTH;	}
					list($x,$y)						=	explode("|",THUMB_WAY);
					list($org_width,$org_height)	=	getimagesize($filename);
					if($org_width>$org_height){ $resizeType	=	Image::HEIGHT;}else{	$resizeType	=	Image::WIDTH;	}
					if($x==1&&$y==1){	$resizeType	=	Image::AUTO;	}
					$image	=	new Image($filename);
					$image->resize(120,120,$resizeType);
					if($x!=1&&$y!=1){
						$image->crop(120,120,$x,$y);
					}
					$image->save($filename);
					$user['photo']	=	$filename;
					@unlink($_SESSION['user']->photo);
				}
				else{
					$this->Report("头像上传失败","member/revise");
				}
			}
			if($this->member->updateUserData($user,$user_id)){
				$this->Report("修改资料成功","member/revise");
			}
		}
		else{
			$this->lmtpl->user	=	$_SESSION['user'];
			$this->lmtpl->title	=	"修改资料";
			$this->lmtpl->keywords='';
			$this->lmtpl->description	=	'';
			$this->lmtpl->render($this->tplpath("member_revise"));
		}
	}
	function editpwd(){
		if($this->input->post()){
			$user_id	=	$_SESSION['user']->user_id;
			$pwd		=	$this->input->post('pwd');
			$oldpwd		=	md5($pwd['old_pwd']);
			$pwd		=	md5($pwd['new_pwd']);
			if($this->member->validOldPwd($oldpwd,$user_id)){
				$this->member->updateUserPwd($pwd,$user_id);
				$this->Report("修改密码成功","member/index");
			}
			else{
				$this->Report("输入的旧密码错误","member/editpwd");
			}
		}
		else{
			$this->lmtpl->title	=	"修改密码";
			$this->lmtpl->keywords='';
			$this->lmtpl->description	=	'';
			$this->lmtpl->render(self::tplpath('member_editpwd'));
		}
	}
	function loginout($position="member"){
		$this->session  = Session::instance();
		unset($_SESSION['user']);
		url::redirect(BASEURI."member/login");
	}
	function register(){
		if($this->input->post()){
			//检查验证码
			$reg	=	$this->input->post('reg');
			if(IS_VALID_NUMBER){
				if(strtoupper($_SESSION["valid_number"])!=strtoupper($reg['validn'])){
					$this->Report("验证码错误","member/register");
				}
				unset($reg['validn']);
			}
			//建立注册关系
			$reg['group_id']	=	15;		//待验证会员
			$reg['status']		=	1;		//通过管理员验证
			$reg['regtime']		=	time();	//注册时间
			//验证会员名称是否存在
			if(!$this->member->validMembername($reg['user_name'])){
				$reg['password']	=	md5($reg['password']);
				$userid				=	$this->member->addMember($reg);
				$memberauth			=	new Memberauth();
				$memberauth->setUserSession($userid);
				$this->Report("恭喜你，注册成功","member/index");
			}
			else{
				$this->Report("会员名称已经存","member/register");
			}
		}
		else{
			$this->lmtpl->title			=	"会员注册";
			$this->lmtpl->keywords		=	'';
			$this->lmtpl->description	=	'';
			$this->lmtpl->render(self::tplpath('member_register'));
		}
	}
	function loginafter(){
		if(@$_SESSION['user']){
			$this->lmtpl->user	=	$_SESSION['user'];
			$this->lmtpl->loginStatus=true;
			$this->lmtpl->render(self::tplpath('member_loginafter'));
		}
		else{
			$this->lmtpl->loginStatus=false;
			$this->lmtpl->render(self::tplpath('member_loginafter'));
		}
	
	}
}