<?php defined('SYSPATH') or die('No direct script access.');
class Member_group_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->group 	= 	new Member_Group_Model();
		$this->acl		=	new Auth_Acl_Model();
		$this->tree = new Tree_Model();
	}

	function index($level=0){
		$group=$this->group->grouplist($level)->result_array(false);
		$this->view 			= 	new View('admin/group/list');
		$this->view->groups		=	$group;
		$this->view->level		=	$level;
		$this->main->formAction	=	"group/delete";
		$this->display();
	}

	function add(){
		if($_POST){
			$add=$this->input->post('form', TRUE);
			if($this->group->checklist($add['group_name'])->count()<=0){
				if($this->group->add($add)){
					$this->main->message='新增用户组成功！';
					$this->main->message_type='success';
				}else{
					$this->main->message='新增用户组失败！';
					$this->main->message_type='error';
				}
			}else{
				$this->main->message='名称或标识已存！';
				$this->main->message_type='warning';
			}
			$this->index();
		}else{
			$this->main ->formAction="member_group/add";
			$this->view = new View('admin/group/add');
			$this->main ->is_validator = "TRUE";

			$this->display();
		}
	}

	function edit($id=0){
		if($_POST){
			$edit=$this->input->post('form', TRUE);
			$check=$this->input->post('check', TRUE);
			if($this->group->checklist($edit['group_name'],$edit['group_value'])->count()<=1){
				if($this->group->edit($edit)){
					$this->main->message='操作成功！';
					$this->main->message_type='success';
				}else{
					$this->main->message='操作失败！';
					$this->main->message_type='error';
				}
			}else{

				$this->main->message='名称或标识已存！';
				$this->main->message_type='warning';

			}
			$this->index();
		}else{
			$countent=$this->group->getone($id)->current();
			$this->main ->formAction="member_group/edit";
			$this->view = new View('admin/group/edit');
			$this->view ->countent = $countent;
			$this->main ->is_validator = "TRUE";
			$this->display();
		}
	}
	function delete($id=0){
		if($this->input->post()){
			$group_id	=	$this->input->post('select_id', TRUE);
			$level		=	$this->input->post('level', TRUE);
		}
		else{
			$group_id[]	=	$id;
		}
		if(is_array($group_id)){
			if($this->group->delete($group_id)){
				$this->main->message='操作成功！';
				$this->main->message_type='success';
			}else{
				$this->main->message='操作失败！';
				$this->main->message_type='error';

			}
		}
		$this->index();

	}
	function assign($group_id=false){
		if($this->input->post()){
			//取得用户组ID
			$groupId	=	$this->input->post('userGroup');
			//取得资源ID
			$aclId		=	$this->input->post('acl_id')?$this->input->post('acl_id'):array();
			//删除以前的关系
			$this->group->delete_acl_group($groupId);
			//插入新关系
			foreach ($groupId as $tmpid){
				foreach ($aclId as $tmpAclId){
					$this->group->insert_acl_group(array('acl_id'=>$tmpAclId,'group_id'=>$tmpid));
				}
			}
			//缓存资源
			$this->group->cache();
			$this->main->message='已经为此用户组授权成功';
			$this->main->message_type='success';
			$this->index();
		}
		else{
			//取得该用户组的所有资源
			$tmpAclId				=	$this->group->getGroupAcl($group_id);
			foreach ($tmpAclId as $tmp){	$inAclId[]			=	$tmp->acl_id;	}
			$userGroup				=	$this->group->grouplist()->result_array();
			$this->view				=	new View("admin/group/assign");
			$this->view->userGroup	=	$userGroup;
			$acls					=	$this->acl->childrenAcl(0,"acl_id,acl_name,acl_value",'obj');
			foreach ($acls as $tmp){
				$aclII[$tmp->acl_id]	=	$this->acl->childrenAcl($tmp->acl_id,"acl_id,acl_name,acl_value",'obj');
				foreach ($aclII[$tmp->acl_id] as $tmpIII){
					$aclII[$tmpIII->acl_id]	=	$this->acl->childrenAcl($tmpIII->acl_id,"acl_id,acl_name,acl_value",'obj');
				}
			}
			$this->view->acl			=	$acls;
			$this->main->formAction		=	"member_group/assign";
			$this->view->aclII			=	$aclII;
			$this->view->inAclId		=	@$inAclId?$inAclId:array();
			$this->view->group_id		=	$group_id;
			$this->display();
		}
	}

}

