<?php 
class member_vip_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->vip	=	new Member_vip_Model();
	}
	function index($page=1,$showlines=30){
		$count	=	$this->vip->getVipNumber()->count();
		$list	=	$this->vip->getVipNumber($page,$showlines)->result_array();
		$this->pagination = new Pagination(Kohana::config("pagination.config"));
		$this->pagination->initialize(array('total_items' => $count,"items_per_page"=>$showlines,"base_url"=>"member_vip/index"));
		$this->view			=	new View("admin/vip/list");
		$this->view->status	=	array('0'=>'已生成',1=>'已制卡',3=>'已激活');
		$this->view->list	=	$list;
		$this->display();
	}
	function add(){
		if($this->input->post()){
			$vip	=	(object)$this->input->post('vip');
			//取得当前时间戳。
			$time	=	time();
			for($i=$vip->startNumber;$i<$vip->endNumber;$i++){
				$addVip	=	array(
					"vip_number"		=>	$vip->customString.$this-> re0($i,$vip->Bit),
					"vip_number_pwd"	=>	md5("123456"),
					"vip_number_status"	=>	"0",
					"vip_number_time"	=>	date("Y-m-d",time()),
					"vip_start_time"	=>	$vip->vip_start_time,
					"vip_end_time"		=>	$vip->vip_end_time,
				);
				$this->vip->insertVipNumber($addVip);
			}
			$this->index();
		}
		else{
			$this->view 			=	new View("admin/vip/add");
			$this->main->formAction	=	"member_vip/add";
			$this->main->is_date	=	true;
			$this->display();
		}
	}
	
	function delete($vip_id=false){
		if($this->input->post('select_id')){
			$arrid=$this->input->post('select_id');
		}
		else{
			$arrid[]=$vip_id;
		}
		$this->vip->deleteVip($arrid);
		$this->main->message="删除卡号成功";
		$this->main->message_type="success";
		$this->index();
	}
	//编号补零
	function re0($n,$w=6){
		$strle	=	strlen($n);
		return str_repeat("0",$w-$strle).$n;
	}
	function makecard(){
		if($this->input->post('select_id')){
			$arrid=$this->input->post('select_id');
		}
		else{
			$arrid[]=$vip_id;
		}
		$this->vip->makeCard($arrid);
		$this->main->message="操作成功";
		$this->main->message_type="success";
		$this->index();
	}
	function truncate(){
		$this->vip->truncate();
		$this->main->message="操作成功";
		$this->main->message_type="success";
		$this->index();
	}
}