<?php 
class Member_manager_Model extends Model{
	function  __construct(){
		parent::__construct();
	}
	/**
	 * 添加会员时检查是否存在同名
	 *
	 * @param unknown_type $member
	 * @return unknown
	 */
	function checkSameName($member,$user_id=false){
		if($user_id){
			$this->db->where("user_id!=",$user_id);
		}
		$this->db->where("user_name",$member['user_name']);
		return $this->db->get("member")->count();
	}
	function insertMember($member){
		if(!$this->checkSameName($member)){
			$member['regtime']	=	date("Y-m-d H:i:s",time());
			return $this->db->insert("member",$member);
		}
		else{
			return false;
		}
	}
	function updateMember($member,$member_id){
		if($this->checkSameName($member,$member_id)<1){
			
			return $this->db->where("user_id",$member_id)->update("member",$member);
		}
		else{
			return false;
		}
	}
	/**
	 * 查询会员
	 *
	 * @param unknown_type $page
	 * @param unknown_type $showlines
	 * @param unknown_type $search
	 * @param unknown_type $_order
	 * @return unknown
	 */
	function getMemberList($page=1,$showlines=30,$search=false,$_order=array("regtime"=>"DESC")){
		$this->db->select("m.*,g.group_name")
		->from("member as m")
		->join("member_group as g","g.group_id","m.group_id");
		$this->db->orderby($_order);
		if($page){
			$this->db->limit($showlines,$page*$showlines-$showlines);
		}
		return $this->db->get();
	}
	function getMember($user_id=false){
		return $this->db->where("user_id",$user_id)->get("member")->current();
	}
	function deleteUser($user_id=false){
		return $this->db->in("user_id",$user_id)->delete("member");
	}
	function reviewUser($userid=false,$status=0){
		$this->db->in("user_id",$userid)->where("group_id",15)->update("member",array("status"=>$status,"group_id"=>14));
		return $this->db->in("user_id",$userid)->update("member",array("status"=>$status));
	}
}