<?php defined('SYSPATH') or die('No direct script access.');
/**
 * Handles loading of site resources (CSS, JS, images) using Views.
 * By default it is assumed that your media files will be stored in
 * `application/views/media`.
 *
 * Usage:
 *  `http://example.com/index.php/media/css/styles.css` 
 *
 * $Id: media.php 2545 2008-04-20 23:39:42Z JAAulde $
 *
 * @package	   Media Module
 * @author	   Greg MacLellan
 * @copyright  (c) 2007-2008 Kohana Team
 * @license	   http://kohanaphp.com/license.html
 */
class Menu_Controller extends Base_Controller {
function __construct(){ 
			parent::__construct(); 
			$this->menu = new Menu_Menu_Model(); 
			$this->group = new Auth_Group_Model(); 
			//$this->tree = new Tree_Model(); 
	}

	function index(){  
		//echo Site_Controller::$_container;
		$menu=$this->menu->menulist()->result_array(false);
		$this->tree =	new Tree($menu);
		$this->tree->set_array_colum(array("id"=>"id","parent_id"=>"parent_id","name"=>"menu_name"));
		$menu=$this->tree->get_tree(0,"\$spacer\$menu_name");
		$this->view = new View('admin/list'); 
		$this->view ->menu=$menu;
		$this->view ->mainurl=BASEURI."menu/index";
		$this->main ->formAction="menu/delete";
		$this->main->is_validator=true;
		$this->display();
	}
	
	function add(){ 
		if($_POST){
			$add=$this->input->post('form', TRUE);
			$roles=$this->input->post('menu_roles', TRUE);
			
			if($this->menu->add($add,$roles)){
				//更新菜单缓存
				$this->menu->cache();
				
			}
			$this->index();
		}else{
			
		$menu=$this->menu->menulist()->result_array(false);
		$group=$this->group->grouplist("admin")->result_array(false);
		$this->tree =	new Tree($menu);
		$this->tree->set_array_colum(array("id"=>"id","parent_id"=>"parent_id","name"=>"menu_name"));
		$menu=$this->tree->get_tree(0,"\$spacer\$menu_name");
		$this->main ->formAction="menu/add";
		$this->view = new View('admin/add'); 
		$this->main ->is_validator = "TRUE";
		$this->view ->group=$group;
		$this->view ->menu = $menu;
		$this->display();
		}
	}
	
	function edit($id=0){
		if($_POST){
			$edit=$this->input->post('form', TRUE);
			$roles=$this->input->post('menu_roles', TRUE);
			$children=$this->menu->childrenlist($edit['id'])->result_array(false);
			if(count($children)==0){
				$childrenid=array();
			}
			else{
				foreach($children as $t){
					$childrenid[]	=	$t['id'];
				}
			}
			if($edit['id']!=$edit['parent_id']&&!in_array($edit['parent_id'],$childrenid)){
			if($this->menu->edit($edit,$roles)){
				//更新菜单缓存
				$this->menu->cache();
				$this->main->message='成功！';
				$this->main->message_type='success';
			}
			}else{
				$this->main->message='父级菜单不能为菜单本身或子级菜单！';
					$this->main->message_type='warning';
			}
			$this->index();
		}else{
		$group=$this->group->grouplist("admin")->result_array(false);
		$menu=$this->menu->menulist()->result_array(false);
		
		$this->tree =	new Tree($menu);
		$this->tree->set_array_colum(array("id"=>"id","parent_id"=>"parent_id","name"=>"menu_name"));
		$menu=$this->tree->get_tree(0,"\$spacer\$menu_name");
		$countent=$this->menu->getone($id)->current();
		$getroles=$this->menu->getroles($id);
		$this->main ->formAction="menu/edit";
		$this->view = new View('admin/edit'); 
		$this->view ->menu = $menu;
		$this->main ->is_validator = "TRUE";
		$this->view ->group=$group;
		$this->view ->getroles=$getroles;
		$this->view ->countent = $countent;
		$this->display();
		}
	
	}
	
	function delete($id=0){
		if(@$_POST){
		
			$menu_id	=	$this->input->post('select_id', TRUE);
			
		}
		else{
			$menu_id[]	=	$id;
		}
		if(is_array($menu_id)){
			foreach ($menu_id as $id){
				$id_list['id']	=	$id;
				if(!$this->menu->delete($id_list)){
					$this->main->message='删除失败！';
					$this->main->message_type='error';
				}else{
					$this->main->message='删除成功！';
					$this->main->message_type='success';
					
				}
			}
		}
		//更新菜单缓存
		$this->menu->cache();
		$this->index();
	
	}
	
	function menu($id=0){
		if($_POST){
			$groupId	=	$this->input->post('group_id');
			$menuId		=	$this->input->post('menu_id');
			if($this->menu->editgroup($menuId,$groupId)){
				
			}
			//更新菜单缓存
			$this->menu->cache();
			$this->main->message='已经配置成功';
			$this->main->message_type='success';
			$id=$groupId;
		}
		
		$groupids=$this->menu->grouplist($id)->result_array();
		foreach($groupids as $groupid){
			$group[]=$groupid->menu_id;
		}
		if(!is_array(@$group)){
			$group=array();
		}
		$menullist=$this->menu->menulist()->result_array();
		$menu =	$this->menu->childrenlist(0)->result_array();
		foreach ($menu as $menuI){
				$menuII[$menuI->id]	=	$this->menu->childrenlist($menuI->id)->result_array();
				foreach ($menuII[$menuI->id] as $menuIII){
				//print_r($menuIII);
					$menuII[$menuIII->id]	=	$this->menu->childrenlist($menuIII->id)->result_array();
				}
			}
		$this->main->formAction		=	"menu/menu";
		$this->view	 =	new View("admin/menu");
		$this->view->menuII		=	$menuII;
		$this->view->menu		=	$menu;
		$this->view->id		=	$id;
		$this->view->group		=	$group;
		$this->display();
		
	}
	function order(){
		if($this->input->post()){
			$menuId	=	$this->input->post('menuid');
			$orders	=	$this->input->post('orders');
			$i=0;
			foreach($orders as $order){
				
				$this->menu->order($menuId[$i++],$order);
			}
			//更新菜单缓存
			$this->menu->cache();
			$this->index();
		}
	}
	
}

	