--
-- 表的结构 `annex`
--

DROP TABLE IF EXISTS `annex`;
CREATE TABLE IF NOT EXISTS `annex` (
  `annex_id` int(11) NOT NULL auto_increment COMMENT '附件ID',
  `name` varchar(128) NOT NULL COMMENT '文件名称',
  `path` varchar(128) NOT NULL COMMENT '附件存放路径',
  `type` varchar(128) NULL COMMENT '附件存类型',
  `description` varchar(128) NOT NULL COMMENT '描述',
  `file_type` varchar(10) NOT NULL COMMENT '附件文件格式',
  `thumbs_path` varchar(128) NOT NULL COMMENT '附件缩略图路径',
  `channel_id` int(11) NOT NULL COMMENT '频道ID',
  `content_id` int(11) NOT NULL COMMENT '内容id',
  `file_size` int(11) NOT NULL COMMENT '附件大小(KB)',
  `upload_time` datetime NOT NULL COMMENT '上传时间',
  `read_pointer` int(11) NOT NULL COMMENT '阅读积分',
  `read_money` int(11) NOT NULL COMMENT '阅读金钱',
  `is_image` int(11) NOT NULL COMMENT '是否是图片',
  `download_times` int(11) NOT NULL default '0' COMMENT '下载次数',
  `is_thumbs` int(11) NOT NULL COMMENT '缩略图',
  PRIMARY KEY  (`annex_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
-- --------------------------------------------------------

