<?php
class Channel_Controller extends Base_Controller {
	function __construct(){
		parent::__construct();
		$this->channel	=	new Model_Channel_Model();
		$this->manager	=	new Model_Manager_Model();
		$this->content	=	new Model_Content_Model();
		$this->category	=	new Model_Category_Model();
		$this->group	=	new Auth_Group_Model();
		$this->group	=	new Member_Group_Model();
	}
	function add(){
		if($this->input->post()){
			$insert_channel							=	$this->input->post("channel");
			$insert_channel['channel_html_dir']		=	$insert_channel['channel_html_dir']."/";
			$insert_channel['channel_create_time']	=	date("Y-m-d");
			/**
			 * 检查频道名称是否存在
			 */
			if(!$this->channel->check_channel_name($this->input->post('channel_name'))){
				/**
				 * 检查目是否存在
				 */
				if(true){
					if($this->channel->addchannel($insert_channel)){
						$this->main->message_type		=	"message";
						$this->main->message			=	Kohana::lang("channel_lang.channel_add_success");
					}
					else{
						$this->main->message_type		=	"error";
						$this->main->message	=	Kohana::lang('channel_lang.channel_add_fail');
					}
				}
				else{
					$this->main->message_type	=	"notice";
					$this->main->message	=	Kohana::lang('channel_lang.channel_dir_already');
				}
			}
			else{
				$this->main->message_type	=	"notice";
				$this->main->message	=	Kohana::lang('channel_lang.channel_name_already');
			}
			$this->index();
		}
		else{
			$this->view				=	new View("channel/add");
			$this->view->modelobj	=	$this->manager->getModelList();
			$role					=	$this->group->grouplist();
			$this->view->role_list	=	$role;
			$this->view->title		=	Kohana::lang('channel_lang.channel_new');
			$this->main->is_validator=true;
			$this->main->formAction	=	"channel/add";
			$this->display();
		}
	}
	function index(){
		$channel					=	$this->channel->getchannellist();
		$this->view					=	new View("channel/list");
		$this->view->channelobj		=	$channel->result_array();
		$this->view->title			=	Kohana::lang('channel_lang.channel_manager');
		$this->display();
	}
	function delete($channel_id){
		$channel_data	=	$this->channel->getchannel($channel_id);
		//删除频道目录
		if(file::delete_files($channel_data->channel_html_dir,true)){
			//删除频道分类
			$this->category->delete($channel_data->model_value,$channel_id);
			//删除频道内容
			$this->content->delete($channel_data->model_value,$channel_id);
			
			//
			if($this->channel->deletechannel($channel_data->model_value,$channel_id)){
				$this->main->message_type		=	"message";
				$this->main->message	=	Kohana::lang('channel_lang.channel_delete_success');
			}
			else{
				$this->main->message_type		=	"error";
				$this->main->message	=	Kohana::lang('channel_lang.channel_delete_fail');
			}
		}
		else{
			$this->main->message_type		=	"error";
			$this->page["report_msg"]	=	$this->lang->line("delete_dir_failed");
		}
		$this->index();
	}
	function edit($channel_id=false){
		if($this->input->post()){
			$update_channel						=	$this->input->post("channel");
			$update_channel['channel_html_dir']	=	preg_replace("#[/\\\]+#","",$update_channel['channel_html_dir'])."/";
			
			//检查频道数据
			if(!$this->channel->check_channel_name($this->input->post('channel_name'),$this->input->post('channel_id'))){
				if($this->channel->updatechannel($update_channel,$this->input->post('channel_id'))){
					$this->main->message_type		=	"message";
					$this->main->message			=	Kohana::lang("channel_lang.channel_edit_success");

				}
				else{
					$this->main->message_type		=	"error";
					$this->main->message			=	Kohana::lang('channel_lang.channel_edit_fail');
				}
			}
			else{
				$this->main->message_type	=	"notice";
				$this->main->message		=	Kohana::lang('channel_lang.channel_name_already');
			}
			$this->index();
		}
		else{
			$this->view					=	new View("channel/add");
			$this->view->channel_id		=	$channel_id;
			$this->main->formAction		=	"channel/edit";
			$this->main->is_validator	=	true;
			$this->view->channel		=	$this->channel->getchannel($channel_id);
			$this->view->modelobj		=	$this->manager->getModelList();
			$this->view->title			=	Kohana::lang('channel_lang.channel_new');
			$this->view->role_list		=	$this->group->grouplist();
			$this->display();
		}

	}
	function modeldata($modelid){
		$model	=	$this->manager->getModel($modelid);
		echo json_encode($model);
	}
}